/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bundle;

import com.ibm.ws.bundle.ParentableResourceBundle;
import com.ibm.ws.bundle.SimpleLRUCache;
import com.ibm.ws.bundle.WrappedResourceBundle;
import com.ibm.ws.security.util.AccessController;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CachingTextResourceBundle
extends ParentableResourceBundle {
    private static final int DEFAULT_MAX_BAD_ENTRIES = 25;
    private static final int DEFAULT_MAX_BUNDLE_ENTRIES = 150;
    private static SimpleLRUCache bundleCache = null;
    private static SimpleLRUCache badBundleCache = null;
    private SimpleLRUCache keyCache = null;
    private SimpleLRUCache badKeyCache = null;
    private static Vector excludeLazyList = null;
    protected URL fullBundleName = null;
    private static Integer overrideBundleMax = null;
    private static Integer overrideKeyMax = null;
    private static boolean useJvmResourceLoader = false;
    private static boolean emitKeyRequests = false;
    private static String className = "com.ibm.ws.bundle.CachingTextResourceBundle";
    private static Logger logger = Logger.getLogger(className, null);

    public CachingTextResourceBundle() {
        int n = 25;
        if (overrideKeyMax != null) {
            n = overrideKeyMax;
        }
        this.keyCache = n == -1 ? new SimpleLRUCache(-1) : new SimpleLRUCache(n);
    }

    public CachingTextResourceBundle(int n) {
        this.keyCache = n > 0 ? new SimpleLRUCache(n) : new SimpleLRUCache(-1);
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) throws NullPointerException, MissingResourceException {
        int n = 25;
        if (overrideKeyMax != null) {
            n = overrideKeyMax;
        }
        return CachingTextResourceBundle.getBundle(string, locale, classLoader, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader, int n) throws NullPointerException, MissingResourceException {
        boolean bl = true;
        ResourceBundle resourceBundle = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "getBundle(String,Locale,ClassLoader,int)");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, className, "getBundle", "Calling load for bundle: [" + string + "]");
        }
        if (string == null) {
            return null;
        }
        if (locale == null) {
            throw new NullPointerException("Locale cannot be null");
        }
        if (classLoader == null) {
            try {
                classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                try {
                    classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return ClassLoader.getSystemClassLoader();
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException2) {
                    throw new MissingResourceException("Could not determine classloader to search on.  Do not have classloader lookup privilages.", string, privilegedActionException2.toString());
                }
            }
        }
        if (useJvmResourceLoader) {
            resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
        } else {
            SimpleLRUCache simpleLRUCache = bundleCache;
            synchronized (simpleLRUCache) {
                if (bundleCache != null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, className, "getBundle", "Checking bundle cache to see if: [" + string + "] is already loaded.");
                    }
                    resourceBundle = (ResourceBundle)bundleCache.getEntry(string + "_" + locale.toString());
                }
                if (resourceBundle == null) {
                    ParentableResourceBundle parentableResourceBundle = null;
                    ParentableResourceBundle parentableResourceBundle2 = null;
                    ParentableResourceBundle parentableResourceBundle3 = null;
                    ParentableResourceBundle parentableResourceBundle4 = null;
                    String string2 = locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant();
                    parentableResourceBundle = CachingTextResourceBundle.loadBundle(string, string2, classLoader, n);
                    if (parentableResourceBundle != null) {
                        parentableResourceBundle.setLocale(locale);
                    }
                    if ((parentableResourceBundle2 = CachingTextResourceBundle.loadBundle(string, string2 = locale.getLanguage() + "_" + locale.getCountry(), classLoader, n)) != null) {
                        parentableResourceBundle2.setLocale(new Locale(locale.getLanguage(), locale.getCountry()));
                    }
                    if ((parentableResourceBundle3 = CachingTextResourceBundle.loadBundle(string, string2 = locale.getLanguage(), classLoader, n)) != null) {
                        parentableResourceBundle3.setLocale(new Locale(locale.getLanguage()));
                    }
                    if (parentableResourceBundle == null && parentableResourceBundle2 == null && parentableResourceBundle3 == null) {
                        locale = Locale.getDefault();
                        string2 = locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant();
                        parentableResourceBundle = CachingTextResourceBundle.loadBundle(string, string2, classLoader, n);
                        if (parentableResourceBundle != null) {
                            parentableResourceBundle.setLocale(locale);
                        }
                        if ((parentableResourceBundle2 = CachingTextResourceBundle.loadBundle(string, string2 = locale.getLanguage() + "_" + locale.getCountry(), classLoader, n)) != null) {
                            parentableResourceBundle2.setLocale(new Locale(locale.getLanguage(), locale.getCountry()));
                        }
                        if ((parentableResourceBundle3 = CachingTextResourceBundle.loadBundle(string, string2 = locale.getLanguage(), classLoader, n)) != null) {
                            parentableResourceBundle3.setLocale(new Locale(locale.getLanguage()));
                        }
                    }
                    if ((parentableResourceBundle4 = CachingTextResourceBundle.loadBundle(string, null, classLoader, n)) != null) {
                        parentableResourceBundle4.setLocale(Locale.getDefault());
                    }
                    ParentableResourceBundle[] parentableResourceBundleArray = new ParentableResourceBundle[]{parentableResourceBundle, parentableResourceBundle2, parentableResourceBundle3, parentableResourceBundle4};
                    ParentableResourceBundle parentableResourceBundle5 = null;
                    ParentableResourceBundle parentableResourceBundle6 = null;
                    for (int i = 0; i < 4; ++i) {
                        if (parentableResourceBundleArray[i] == null) continue;
                        if (parentableResourceBundle5 == null) {
                            parentableResourceBundle6 = parentableResourceBundle5 = parentableResourceBundleArray[i];
                            continue;
                        }
                        if (parentableResourceBundle6.getParent() != null) break;
                        parentableResourceBundle6.setParent(parentableResourceBundleArray[i]);
                        parentableResourceBundle6 = parentableResourceBundleArray[i];
                    }
                    resourceBundle = parentableResourceBundle5;
                }
            }
            if (resourceBundle == null) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, className, "getBundle", "Bad bundle load request: [" + string + "].");
                }
                throw new MissingResourceException("Bundle could not be loaded", string, "key");
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "getBundle(String,Locale,ClassLoader,int)");
        }
        return resourceBundle;
    }

    private static Class checkAndLoadClassType(String string, String string2, ClassLoader classLoader) {
        Class<?> clazz = null;
        String string3 = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "checkAndLoadClassType(String, String, ClassLoader)");
        }
        string3 = string2 != null ? string + "_" + string2 : string;
        try {
            clazz = classLoader.loadClass(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (logger.isLoggable(Level.FINEST) && clazz != null) {
            logger.logp(Level.FINEST, className, "checkAndLoadClass", "Loaded bundle that was a class-type bundle: [" + string + "].");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "checkAndLoadClassType(String, String, ClassLoader)");
        }
        return clazz;
    }

    private static ParentableResourceBundle loadBundle(String string, String string2, ClassLoader classLoader, int n) {
        String string3 = null;
        ParentableResourceBundle parentableResourceBundle = null;
        String string4 = string;
        if (string2 != null) {
            string4 = string4 + "_" + string2;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "loadBundle(String, String, ClassLoader, int)");
        }
        if (bundleCache.containsEntry(string4)) {
            parentableResourceBundle = (ParentableResourceBundle)bundleCache.getEntry(string4);
        } else if (badBundleCache != null && badBundleCache.containsEntry(string4)) {
            parentableResourceBundle = null;
        } else if (classLoader != null) {
            final Class clazz = CachingTextResourceBundle.checkAndLoadClassType(string, string2, classLoader);
            if (clazz != null) {
                try {
                    ResourceBundle resourceBundle = null;
                    resourceBundle = (ResourceBundle)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return clazz.newInstance();
                        }
                    });
                    parentableResourceBundle = new WrappedResourceBundle(resourceBundle);
                }
                catch (InstantiationException instantiationException) {
                    logger.logp(Level.FINE, className, "loadBundle", "Failed to instantiate a class type bundle for: [" + string + "].");
                    parentableResourceBundle = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    logger.logp(Level.FINE, className, "loadBundle", "Received IllegalAccessException when instantiating a class type bundle for: [" + string + "].");
                    parentableResourceBundle = null;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    logger.logp(Level.FINE, className, "loadBundle", "Could not instantiate a new resource bundle class due to SecurityController exceptions on: [" + string + "].");
                    parentableResourceBundle = null;
                }
                catch (ClassCastException classCastException) {
                    parentableResourceBundle = null;
                }
            } else {
                URL uRL = null;
                string3 = string;
                string3 = string3.replace('.', '/');
                string3 = string2 != null ? string3 + "_" + string2 + ".properties" : string3 + ".properties";
                uRL = classLoader.getResource(string3);
                if (uRL != null) {
                    CachingTextResourceBundle cachingTextResourceBundle = new CachingTextResourceBundle(n);
                    cachingTextResourceBundle.fullBundleName = uRL;
                    parentableResourceBundle = cachingTextResourceBundle;
                }
                if (logger.isLoggable(Level.FINEST) && parentableResourceBundle != null) {
                    logger.logp(Level.FINEST, className, "loadBundle", "Loaded bundle that was a property type and therefore on-demand key-caching is enabled: [" + string + "].");
                }
            }
        }
        if (parentableResourceBundle != null) {
            bundleCache.putEntry(string4, parentableResourceBundle);
        } else {
            if (badBundleCache == null) {
                badBundleCache = new SimpleLRUCache(25);
            }
            badBundleCache.putEntry(string4, null);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "loadBundle(String, String, ClassLoader, int)");
        }
        return parentableResourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleGetObject(String string) throws NullPointerException {
        Object object = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "handleGetObject(String)");
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (emitKeyRequests) {
            System.out.println("Bundle: [" + this.fullBundleName.toString() + "].  Key: [" + string + "].");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, className, "handleGetObject", "Trying to fetch key: [" + string + "].");
        }
        SimpleLRUCache simpleLRUCache = this.keyCache;
        synchronized (simpleLRUCache) {
            if (this.keyCache.containsEntry(string)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, className, "handleGetObject", "Getting key: [" + string + "] from cache.");
                }
                object = this.keyCache.getEntry(string);
            } else if (this.badKeyCache != null && this.badKeyCache.containsEntry(string)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, className, "handleGetObject", "Known bad key: [" + string + "].");
                }
                object = null;
            } else {
                object = this.keyCache.getEntry(string);
                if (!(object != null || this.badKeyCache != null && this.badKeyCache.containsEntry(string))) {
                    object = this.getValueFromResource(string);
                    if (object != null) {
                        this.keyCache.putEntry(string, object);
                    } else {
                        if (this.badKeyCache == null) {
                            this.badKeyCache = new SimpleLRUCache(25);
                        }
                        this.badKeyCache.putEntry(string, string);
                    }
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "handleGetObject(String)");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String getValueFromResource(String var1_1) {
        var2_2 = null;
        var3_3 = null;
        var4_4 = true;
        if (CachingTextResourceBundle.logger.isLoggable(Level.FINER)) {
            CachingTextResourceBundle.logger.entering(CachingTextResourceBundle.className, "getValueFromResource(String)");
        }
        try {
            var3_3 = this.fullBundleName.openStream();
            var4_4 = false;
        }
        catch (Exception var5_5) {
            var3_3 = null;
        }
        if (CachingTextResourceBundle.logger.isLoggable(Level.FINEST)) {
            CachingTextResourceBundle.logger.logp(Level.FINEST, CachingTextResourceBundle.className, "getValueFromResource", "Trying to load key: [" + var1_1 + "] from disk bundle: [" + this.fullBundleName.toString() + "]");
        }
        if (var3_3 != null) {
            try {
                var5_6 = new BufferedReader(new InputStreamReader(var3_3, "ISO-8859-1"));
                var6_12 = var5_6.readLine();
                while (var6_12 != null) {
                    if (CachingTextResourceBundle.logger.isLoggable(Level.FINEST)) {
                        CachingTextResourceBundle.logger.logp(Level.FINEST, CachingTextResourceBundle.className, "getValueFromResource", "Read line from file:  [" + var6_12 + "]");
                    }
                    if ((var6_12 = this.trimLeadingWhitespace(var6_12)).length() > 0 && var6_12.charAt(0) != '#' && var6_12.charAt(0) != '!') {
                        while (var6_12.charAt(var6_12.length() - 1) == '\\') {
                            if (CachingTextResourceBundle.logger.isLoggable(Level.FINEST)) {
                                CachingTextResourceBundle.logger.logp(Level.FINEST, CachingTextResourceBundle.className, "getValueFromResource", "Appending line: [" + var6_12 + "]");
                            }
                            var6_12 = var6_12.substring(0, var6_12.length() - 1);
                            var7_14 = var5_6.readLine();
                            if (var7_14 == null) continue;
                            var6_12 = var6_12 + this.trimLeadingWhitespace(var7_14);
                        }
                        var7_13 = this.findKeySeparator(var6_12);
                        if (var7_13 == -1) continue;
                        var8_15 = null;
                        var9_16 = null;
                        var10_17 = var6_12.substring(0, var7_13).trim();
                        try {
                            var9_16 = this.decodeChars(var10_17);
                        }
                        catch (Exception var11_18) {
                            var9_16 = var10_17;
                        }
                        if (var9_16.equals(var1_1)) {
                            var11_19 = var7_13 + 1;
                            if (var11_19 < var6_12.length()) {
                                var12_20 = var6_12.substring(var11_19, var6_12.length());
                                var12_20 = this.trimLeadingWhitespace(var12_20);
                                try {
                                    var8_15 = this.decodeChars(var12_20);
                                }
                                catch (Exception var13_21) {
                                    var8_15 = var12_20;
                                }
                            } else {
                                var8_15 = "";
                            }
                            var6_12 = null;
                            var2_2 = var8_15;
                            var5_6.close();
                            var4_4 = true;
                            continue;
                        }
                        var6_12 = var5_6.readLine();
                        continue;
                    }
                    var6_12 = var5_6.readLine();
                }
                if (var5_6 == null || var4_4) ** GOTO lbl81
                var5_6.close();
                var4_4 = true;
            }
            catch (UnsupportedEncodingException var5_8) {
                CachingTextResourceBundle.logger.logp(Level.FINE, CachingTextResourceBundle.className, "getValueFromResource", "Input stream could not be opened with encoding type: [ISO-8859-1] on resource: [" + this.fullBundleName.toString() + "].");
            }
            catch (IOException var5_10) {
                CachingTextResourceBundle.logger.logp(Level.FINE, CachingTextResourceBundle.className, "getValueFromResource", "Input stream read failure on resource: [" + this.fullBundleName.toString() + "].");
            }
            finally {
                try {
                    if (var3_3 != null && !var4_4) {
                        var3_3.close();
                        var4_4 = true;
                    }
                }
                catch (IOException var5_9) {}
            }
        } else if (CachingTextResourceBundle.logger.isLoggable(Level.FINEST)) {
            CachingTextResourceBundle.logger.logp(Level.FINEST, CachingTextResourceBundle.className, "getValueFromResource", "Failed to obtain input stream to bundle: [" + this.fullBundleName.toString() + "]");
        }
lbl81:
        // 7 sources

        if (CachingTextResourceBundle.logger.isLoggable(Level.FINER)) {
            CachingTextResourceBundle.logger.exiting(CachingTextResourceBundle.className, "getValueFromResource(String)");
        }
        return var2_2;
    }

    public Enumeration getKeys() {
        Object object;
        HashMap hashMap = this.generateKeyList();
        Enumeration<String> enumeration = null;
        Enumeration enumeration2 = null;
        if (this.parent != null) {
            enumeration = this.parent.getKeys();
        }
        if (enumeration != null) {
            if (hashMap == null) {
                hashMap = new HashMap();
            }
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (hashMap.containsKey(object)) continue;
                hashMap.put(object, null);
            }
            enumeration2 = null;
        }
        if (hashMap != null) {
            object = new Vector(hashMap.size());
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ((Vector)object).add(iterator.next());
            }
            enumeration2 = ((Vector)object).elements();
        } else {
            enumeration2 = new Vector().elements();
        }
        return enumeration2;
    }

    public void printAccessInformation(PrintStream printStream) {
        if (printStream == null) {
            printStream = System.out;
        }
        if (this.keyCache != null) {
            printStream.println("Access data for bundle: [" + this.fullBundleName.toString() + "]");
            this.keyCache.printAccessInformation(printStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void preloadCache(String[] var1_1) {
        if (CachingTextResourceBundle.logger.isLoggable(Level.FINER)) {
            CachingTextResourceBundle.logger.entering(CachingTextResourceBundle.className, "preloadCache(String[])");
        }
        if (var1_1 != null) {
            var2_2 = new HashMap<String, String>(var1_1.length);
            var3_3 = this.keyCache;
            synchronized (var3_3) {
                var4_4 = null;
                var5_5 = true;
                for (var6_6 = 0; var6_6 < var1_1.length; ++var6_6) {
                    if (var1_1[var6_6] == null || this.keyCache.containsEntry(var1_1[var6_6]) || this.badKeyCache != null && this.badKeyCache.containsEntry(var1_1[var6_6])) continue;
                    var2_2.put(var1_1[var6_6], var1_1[var6_6]);
                }
                if (this.keyCache.size() != -1 && var2_2.size() > this.keyCache.freeEntriesRemaining()) {
                    var6_6 = this.keyCache.size() + (var2_2.size() - this.keyCache.freeEntriesRemaining());
                    if (CachingTextResourceBundle.logger.isLoggable(Level.FINEST)) {
                        CachingTextResourceBundle.logger.logp(Level.FINEST, CachingTextResourceBundle.className, "preloadCache", "For bundle: [" + this.fullBundleName.toString() + "] scaling cache to: [" + var6_6 + "] entries.");
                    }
                    this.keyCache.resize(var6_6);
                }
                try {
                    var4_4 = this.fullBundleName.openStream();
                    var5_5 = false;
                }
                catch (Exception var6_7) {
                    var4_4 = null;
                }
                if (CachingTextResourceBundle.logger.isLoggable(Level.FINEST)) {
                    CachingTextResourceBundle.logger.logp(Level.FINEST, CachingTextResourceBundle.className, "preloadCache", "Trying to load keys from disk bundle: [" + this.fullBundleName.toString() + "].");
                }
                if (var4_4 != null) {
                    try {
                        var6_8 = new BufferedReader(new InputStreamReader(var4_4, "ISO-8859-1"));
                        var7_14 = var6_8.readLine();
                        while (var7_14 != null && !var2_2.isEmpty()) {
                            if (CachingTextResourceBundle.logger.isLoggable(Level.FINEST)) {
                                CachingTextResourceBundle.logger.logp(Level.FINEST, CachingTextResourceBundle.className, "preloadCache", "Read line from file:  [" + var7_14 + "].");
                            }
                            if ((var7_14 = this.trimLeadingWhitespace(var7_14)).length() > 0 && var7_14.charAt(0) != '#' && var7_14.charAt(0) != '!') {
                                while (var7_14.charAt(var7_14.length() - 1) == '\\') {
                                    if (CachingTextResourceBundle.logger.isLoggable(Level.FINEST)) {
                                        CachingTextResourceBundle.logger.logp(Level.FINEST, CachingTextResourceBundle.className, "preloadCache", "Appending line: [" + var7_14 + "].");
                                    }
                                    var7_14 = var7_14.substring(0, var7_14.length() - 1);
                                    var8_16 = var6_8.readLine();
                                    if (var8_16 == null) continue;
                                    var7_14 = var7_14 + this.trimLeadingWhitespace(var8_16);
                                }
                                var8_15 = this.findKeySeparator(var7_14);
                                if (var8_15 != -1) {
                                    var9_18 /* !! */  = null;
                                    var10_19 = null;
                                    var11_21 = var7_14.substring(0, var8_15).trim();
                                    try {
                                        var10_19 = this.decodeChars((String)var11_21);
                                    }
                                    catch (Exception var12_22) {
                                        var10_19 = var11_21;
                                    }
                                    if (var2_2.containsKey(var10_19)) {
                                        var12_23 = var8_15 + 1;
                                        if (var12_23 < var7_14.length()) {
                                            var13_25 = var7_14.substring(var12_23, var7_14.length());
                                            var13_25 = this.trimLeadingWhitespace(var13_25);
                                            try {
                                                var9_18 /* !! */  = this.decodeChars(var13_25);
                                            }
                                            catch (Exception var14_26) {
                                                var9_18 /* !! */  = var13_25;
                                            }
                                        } else {
                                            var9_18 /* !! */  = "";
                                        }
                                        var7_14 = null;
                                        this.keyCache.putEntry((String)var10_19, var9_18 /* !! */ );
                                        var2_2.remove(var10_19);
                                    }
                                    var7_14 = var6_8.readLine();
                                    continue;
                                }
                                var7_14 = var6_8.readLine();
                                continue;
                            }
                            var7_14 = var6_8.readLine();
                        }
                        if (var6_8 != null && !var5_5) {
                            var6_8.close();
                            var5_5 = true;
                        }
                        if (var2_2.isEmpty() || (var8_17 = var2_2.keySet()) == null) ** GOTO lbl117
                        var9_18 /* !! */  = new String[var2_2.size()];
                        var10_20 = 0;
                        if (this.badKeyCache == null) {
                            this.badKeyCache = 25 < var9_18 /* !! */ .length ? new SimpleLRUCache(var9_18 /* !! */ .length) : new SimpleLRUCache(25);
                        } else if (this.badKeyCache.size() < var9_18 /* !! */ .length) {
                            // empty if block
                        }
                        this.badKeyCache.resize(var9_18 /* !! */ .length);
                        var11_21 = var8_17.iterator();
                        if (var11_21 != null) {
                            while (var11_21.hasNext()) {
                                var12_24 = (String)var11_21.next();
                                this.badKeyCache.putEntry(var12_24, var12_24);
                                var9_18 /* !! */ [var10_20] = var12_24;
                                ++var10_20;
                            }
                        }
                        if (this.parent == null || !(this.parent instanceof CachingTextResourceBundle)) ** GOTO lbl117
                        ((CachingTextResourceBundle)this.parent).preloadCache(var9_18 /* !! */ );
                    }
                    catch (UnsupportedEncodingException var6_10) {
                        CachingTextResourceBundle.logger.logp(Level.FINE, CachingTextResourceBundle.className, "preloadCache", "Input stream could not be opened with encoding type: [ISO-8859-1] on resource: [" + this.fullBundleName.toString() + "].");
                    }
                    catch (IOException var6_12) {
                        CachingTextResourceBundle.logger.logp(Level.FINE, CachingTextResourceBundle.className, "preloadCache", "Input stream read failure on resource: [" + this.fullBundleName.toString() + "].");
                    }
                    finally {
                        try {
                            if (!var5_5) {
                                var4_4.close();
                            }
                        }
                        catch (IOException var6_11) {}
                    }
                } else if (CachingTextResourceBundle.logger.isLoggable(Level.FINEST)) {
                    CachingTextResourceBundle.logger.logp(Level.FINEST, CachingTextResourceBundle.className, "preloadCache", "Failed to obtain input stream to bundle: [" + this.fullBundleName.toString() + "].");
                }
            }
        }
lbl117:
        // 8 sources

        if (CachingTextResourceBundle.logger.isLoggable(Level.FINER)) {
            CachingTextResourceBundle.logger.exiting(CachingTextResourceBundle.className, "preloadCache(String[])");
        }
    }

    protected void finalize() throws Throwable {
        this.keyCache = null;
        this.badKeyCache = null;
        this.fullBundleName = null;
    }

    private String decodeChars(String string) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "decodeChars(String)");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, className, "decodeChars", "Trying to decode string: [" + string + "]");
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\\') {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (i + 2 < string.length() && string.charAt(i) == '\\' && string.charAt(i + 1) == 'u') {
                int n = 0;
                char c = '\u0000';
                if (string.length() - i >= 5) {
                    ++i;
                    ++i;
                    block19: for (int j = 0; j < 4; ++j) {
                        char c2 = string.charAt(j + i);
                        n <<= 4;
                        switch (c2) {
                            case '0': {
                                n |= 0;
                                continue block19;
                            }
                            case '1': {
                                n |= 1;
                                continue block19;
                            }
                            case '2': {
                                n |= 2;
                                continue block19;
                            }
                            case '3': {
                                n |= 3;
                                continue block19;
                            }
                            case '4': {
                                n |= 4;
                                continue block19;
                            }
                            case '5': {
                                n |= 5;
                                continue block19;
                            }
                            case '6': {
                                n |= 6;
                                continue block19;
                            }
                            case '7': {
                                n |= 7;
                                continue block19;
                            }
                            case '8': {
                                n |= 8;
                                continue block19;
                            }
                            case '9': {
                                n |= 9;
                                continue block19;
                            }
                            case 'A': 
                            case 'a': {
                                n |= 0xA;
                                continue block19;
                            }
                            case 'B': 
                            case 'b': {
                                n |= 0xB;
                                continue block19;
                            }
                            case 'C': 
                            case 'c': {
                                n |= 0xC;
                                continue block19;
                            }
                            case 'D': 
                            case 'd': {
                                n |= 0xD;
                                continue block19;
                            }
                            case 'E': 
                            case 'e': {
                                n |= 0xE;
                                continue block19;
                            }
                            case 'F': 
                            case 'f': {
                                n |= 0xF;
                                continue block19;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed character encoding encountered when decoding unicode characters.");
                            }
                        }
                    }
                    c = (char)(c | n);
                    stringBuffer.append(c);
                    i += 3;
                    continue;
                }
                throw new IllegalArgumentException("Malformed character encoding encountered when decoding unicode characters.");
            }
            if (i + 1 < string.length() && string.charAt(i) == '\\' && string.charAt(i + 1) == 't') {
                stringBuffer.append('\t');
                ++i;
                continue;
            }
            if (i + 1 < string.length() && string.charAt(i) == '\\' && string.charAt(i + 1) == 'r') {
                stringBuffer.append('\r');
                ++i;
                continue;
            }
            if (i + 1 < string.length() && string.charAt(i) == '\\' && string.charAt(i + 1) == 'f') {
                stringBuffer.append('\f');
                ++i;
                continue;
            }
            if (i + 1 < string.length() && string.charAt(i) == '\\' && string.charAt(i + 1) == 'n') {
                stringBuffer.append('\n');
                ++i;
                continue;
            }
            if (i + 1 < string.length() && string.charAt(i) == '\\' && string.charAt(i + 1) == ':') {
                stringBuffer.append(':');
                ++i;
                continue;
            }
            if (i + 1 < string.length() && string.charAt(i) == '\\' && string.charAt(i + 1) == '=') {
                stringBuffer.append('=');
                ++i;
                continue;
            }
            if (i + 1 >= string.length()) continue;
            stringBuffer.append(string.charAt(i + 1));
            ++i;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, className, "decodeChars", "Decoded [" + string + "] to: [" + stringBuffer.toString() + "]");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "decodeChars(String)");
        }
        return stringBuffer.toString();
    }

    private int findKeySeparator(String string) {
        int n = -1;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "findKeySeperator(String)");
        }
        if (string != null) {
            n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '\\') {
                    if (i + 1 >= string.length() - 1 || string.charAt(i + 1) != ':' && string.charAt(i + 1) != '=' && string.charAt(i + 1) != ' ') continue;
                    ++i;
                    continue;
                }
                if (string.charAt(i) != '=' && string.charAt(i) != ':' && string.charAt(i) != ' ') continue;
                n = i;
                break;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "findKeySeperator(String)");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private HashMap generateKeyList() {
        var1_1 = new HashMap<String, Object>();
        var2_2 = null;
        var3_3 = true;
        if (CachingTextResourceBundle.logger.isLoggable(Level.FINER)) {
            CachingTextResourceBundle.logger.entering(CachingTextResourceBundle.className, "generateKeyList()");
        }
        try {
            var2_2 = this.fullBundleName.openStream();
            var3_3 = false;
        }
        catch (Exception var4_4) {
            var2_2 = null;
        }
        if (CachingTextResourceBundle.logger.isLoggable(Level.FINEST)) {
            CachingTextResourceBundle.logger.logp(Level.FINEST, CachingTextResourceBundle.className, "generateKeyList", "Trying to load key set for disk bundle: [" + this.fullBundleName + "]");
        }
        if (var2_2 != null) {
            try {
                var4_5 = new BufferedReader(new InputStreamReader(var2_2, "ISO-8859-1"));
                var5_11 = var4_5.readLine();
                while (var5_11 != null) {
                    if (CachingTextResourceBundle.logger.isLoggable(Level.FINEST)) {
                        CachingTextResourceBundle.logger.logp(Level.FINEST, CachingTextResourceBundle.className, "generateKeyList", "Read line from file:  [" + var5_11 + "]");
                    }
                    if ((var5_11 = this.trimLeadingWhitespace(var5_11)).length() > 0 && var5_11.charAt(0) != '#' && var5_11.charAt(0) != '!') {
                        while (var5_11.charAt(var5_11.length() - 1) == '\\') {
                            if (CachingTextResourceBundle.logger.isLoggable(Level.FINEST)) {
                                CachingTextResourceBundle.logger.logp(Level.FINEST, CachingTextResourceBundle.className, "generateKeyList", "Appending line: [" + var5_11 + "]");
                            }
                            var5_11 = var5_11.substring(0, var5_11.length() - 1);
                            var6_13 = var4_5.readLine();
                            if (var6_13 == null) continue;
                            var5_11 = var5_11 + this.trimLeadingWhitespace(var6_13);
                        }
                        var6_12 = this.findKeySeparator(var5_11);
                        if (var6_12 == -1) continue;
                        var7_14 = null;
                        var8_15 = null;
                        var9_16 = var5_11.substring(0, var6_12).trim();
                        try {
                            var8_15 = this.decodeChars(var9_16);
                        }
                        catch (Exception var10_17) {
                            var8_15 = var9_16;
                        }
                        var1_1.put(var8_15, null);
                        var5_11 = var4_5.readLine();
                        continue;
                    }
                    var5_11 = var4_5.readLine();
                }
                if (var4_5 == null || var3_3) ** GOTO lbl65
                var4_5.close();
                var3_3 = true;
            }
            catch (UnsupportedEncodingException var4_7) {
                CachingTextResourceBundle.logger.logp(Level.FINE, CachingTextResourceBundle.className, "generateKeyList", "Input stream could not be opened with encoding type: [ISO-8859-1] on resource: [" + this.fullBundleName.toString() + "].");
            }
            catch (IOException var4_9) {
                CachingTextResourceBundle.logger.logp(Level.FINE, CachingTextResourceBundle.className, "generateKeyList", "Input stream read failure on resource: [" + this.fullBundleName.toString() + "].");
            }
            finally {
                try {
                    var2_2.close();
                    var3_3 = true;
                }
                catch (IOException var4_8) {}
            }
        } else if (CachingTextResourceBundle.logger.isLoggable(Level.FINEST)) {
            CachingTextResourceBundle.logger.logp(Level.FINEST, CachingTextResourceBundle.className, "generateKeyList", "Failed to obtain input stream to bundle: [" + this.fullBundleName.toString() + "].");
        }
lbl65:
        // 7 sources

        if (CachingTextResourceBundle.logger.isLoggable(Level.FINER)) {
            CachingTextResourceBundle.logger.exiting(CachingTextResourceBundle.className, "generateKeyList()");
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration viewCache() {
        Enumeration enumeration;
        SimpleLRUCache simpleLRUCache = this.keyCache;
        synchronized (simpleLRUCache) {
            enumeration = this.keyCache.getKeys();
        }
        return enumeration;
    }

    private String trimLeadingWhitespace(String string) {
        if (string != null) {
            int n;
            for (n = 0; n < string.length() - 1 && string.charAt(n) == ' '; ++n) {
            }
            if (n > 0 && n < string.length()) {
                string = string.substring(n, string.length());
            }
        }
        return string;
    }

    static {
        Integer n = null;
        String string = System.getProperty("was.bundlecaching.maxbundlecache");
        String string2 = System.getProperty("was.bundlecaching.maxkeycache");
        String string3 = System.getProperty("was.bundlecaching.usevmloader");
        String string4 = System.getProperty("was.bundlecaching.emitkeyrequests");
        if (string2 != null) {
            try {
                n = new Integer(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n != null) {
                overrideKeyMax = n == 0 ? new Integer(1) : (n < 0 ? new Integer(-1) : n);
            }
        }
        if (string != null) {
            n = null;
            try {
                n = new Integer(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                bundleCache = new SimpleLRUCache(150);
            }
            if (n != null) {
                bundleCache = n == 0 ? new SimpleLRUCache(1) : (n < 0 ? new SimpleLRUCache(-1) : new SimpleLRUCache(n));
            }
        } else {
            bundleCache = new SimpleLRUCache(150);
        }
        if (string3 != null) {
            useJvmResourceLoader = string3.equalsIgnoreCase("true");
        }
        if (string4 != null) {
            emitKeyRequests = string4.equalsIgnoreCase("true");
        }
    }
}

