/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.PathUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ClassLoaderUtils {
    private static TraceComponent tc = Tr.register(ClassLoaderUtils.class.getName(), "Websphere ClassLoader", null);

    public static String[] addDependentJars(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDependentJars", PathUtils.arrayToString((String[])stringArray));
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].toLowerCase().endsWith(".jar")) continue;
            ClassLoaderUtils.addDependents(stringArray[i], arrayList);
        }
        String[] stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDependentJars", PathUtils.arrayToString((String[])stringArray2));
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addDependents(String string, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDependents", string);
        }
        boolean bl = tc.isDebugEnabled();
        ZipFile zipFile = null;
        try {
            File file = new File(string);
            String string2 = ClassLoaderUtils.getPrefix(file);
            zipFile = new JarFile(string);
            Manifest manifest = ((JarFile)zipFile).getManifest();
            if (manifest == null) {
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "addDependents", new Object[]{string, "no manifest found"});
                return;
            }
            Attributes attributes = manifest.getMainAttributes();
            if (attributes == null) {
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "addDependents", new Object[]{string, "no attributes found"});
                return;
            }
            String string3 = attributes.getValue(Attributes.Name.CLASS_PATH);
            if (string3 == null) {
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "addDependents", new Object[]{string, "no dependents found"});
                return;
            }
            if (bl) {
                Tr.debug(tc, "dependent classpath detected: " + string3);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                String string5 = string2 + string4;
                if (!PathUtils.listAddNoDup((List)list, (Object)string5)) continue;
                if (bl) {
                    Tr.debug(tc, "adding " + string5);
                }
                ClassLoaderUtils.addDependents(string5, list);
            }
        }
        catch (ZipException zipException) {
            FFDCFilter.processException(zipException, "com.ibm.ws.classloader.ClassLoaderUtils.addDependents", "238");
            if (bl) {
                Tr.debug(tc, "WARNING: could not open " + string + " : " + zipException.getLocalizedMessage());
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.classloader.ClassLoaderUtils.addDependents", "246");
            if (bl) {
                Tr.debug(tc, "WARNING: I/O exception " + string + " : " + iOException.getLocalizedMessage());
            }
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception exception) {}
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "addDependents", string);
    }

    private static String getPrefix(File file) throws IOException {
        String string = file.getCanonicalPath();
        int n = string.lastIndexOf(File.separatorChar);
        if (n >= 0) {
            return string.substring(0, n + 1);
        }
        return string;
    }
}

