/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.classloader.ClassProviderListener;
import com.ibm.ws.classloader.ResourceCache;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketPermission;
import java.net.URL;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SinglePathClassProvider {
    private static TraceComponent tc = Tr.register(SinglePathClassProvider.class.getName(), "Websphere ClassLoader", null);
    protected File pathFile = null;
    protected boolean pathExists = false;
    protected boolean isDirectory = false;
    protected URL url = null;
    protected String path = null;
    protected ZipFile cachedZip = null;
    protected boolean cachingEnabled = false;
    protected Manifest manifest = null;
    private static final boolean emulateURLClassLoader = Boolean.getBoolean("com.ibm.ws.classloader.strict");
    private ResourceCache resourcesInJar = new ResourceCache('/');
    private ResourceCache classesInJar = new ResourceCache('.');

    public SinglePathClassProvider(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SinglePathClassProvider");
        }
        this.pathFile = new File(string);
        try {
            this.path = this.pathFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "40", this);
            this.path = string;
        }
        this.pathExists = this.pathFile.exists();
        this.isDirectory = this.pathFile.isDirectory();
        if (tc.isDebugEnabled()) {
            if (this.pathExists) {
                Tr.debug(tc, "path " + this.pathFile.getPath() + " exists");
            } else {
                Tr.debug(tc, "path " + this.pathFile.getPath() + " does not exist");
            }
            if (this.isDirectory) {
                Tr.debug(tc, "path " + this.pathFile.getPath() + " is a directory");
            }
        }
        if (this.pathExists && !this.isDirectory) {
            this.buildContentsCache();
        }
        try {
            this.url = this.pathFile.getCanonicalFile().toURL();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.classloader.SinglePathClassProvider.run", "59", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SinglePathClassProvider");
        }
    }

    public void setCaching(boolean bl) {
        this.cachingEnabled = bl;
        if (!bl && this.cachedZip != null) {
            try {
                this.cachedZip.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.classloader.SinglePathClassProvider.setCaching", "74", this);
            }
            this.cachedZip = null;
        }
    }

    protected Manifest getManifest() {
        return this.manifest;
    }

    public void reload() {
        this.pathFile = new File(this.path);
        this.pathExists = this.pathFile.exists();
        this.isDirectory = this.pathFile.isDirectory();
        this.resourcesInJar.clear();
        this.classesInJar.clear();
        if (this.pathExists && !this.isDirectory) {
            this.buildContentsCache();
        }
    }

    public void dispose() {
        this.resourcesInJar.clear();
        this.classesInJar.clear();
        this.cachedZip = null;
        this.pathFile = null;
        this.url = null;
        this.manifest = null;
    }

    public URL getURL() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isValid() {
        return this.pathExists;
    }

    public byte[] getClassBytes(String string, ClassProviderListener classProviderListener) {
        byte[] byArray = null;
        if (this.pathExists) {
            byArray = this.isDirectory ? this.getClassBytesFromDir(string, classProviderListener) : this.getClassBytesFromJar(string, classProviderListener);
        }
        return byArray;
    }

    protected byte[] getClassBytesFromDir(final String string, final ClassProviderListener classProviderListener) {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                String string3 = string.replace('.', '/');
                FileInputStream fileInputStream = null;
                try {
                    String string2 = SinglePathClassProvider.this.getRealResourcePath(string3 + ".class");
                    File file = new File(string2);
                    if (!file.exists()) {
                        Object var5_7 = null;
                        return var5_7;
                    }
                    fileInputStream = new FileInputStream(file);
                    byte[] byArray = new byte[(int)file.length()];
                    SinglePathClassProvider.this.readFully(fileInputStream, byArray);
                    classProviderListener.classLoadedFromFile(file);
                    byte[] byArray2 = byArray;
                    return byArray2;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "164", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getClassBytesFromDir", iOException);
                    }
                }
                finally {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "172", this);
                    }
                }
                return null;
            }
        });
    }

    protected byte[] getClassBytesFromJar(final String string, final ClassProviderListener classProviderListener) {
        if (this.classesInJar.contains(string, '.')) {
            return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public Object run() {
                    byte[] byArray;
                    block39: {
                        IOException iOException2222;
                        ZipFile zipFile;
                        ByteArrayOutputStream byteArrayOutputStream;
                        InputStream inputStream;
                        block35: {
                            block34: {
                                String string2;
                                ZipEntry zipEntry;
                                byArray = null;
                                inputStream = null;
                                byteArrayOutputStream = null;
                                zipFile = SinglePathClassProvider.this.cachedZip;
                                if (zipFile == null) {
                                    zipFile = new ZipFile(SinglePathClassProvider.this.pathFile);
                                }
                                if ((zipEntry = zipFile.getEntry((string2 = string.replace('.', '/')) + ".class")) == null) break block34;
                                inputStream = zipFile.getInputStream(zipEntry);
                                long l = zipEntry.getSize();
                                if (l != -1L) {
                                    int n = (int)l;
                                    byArray = new byte[n];
                                    SinglePathClassProvider.this.readFully(inputStream, byArray);
                                } else {
                                    byte[] byArray2 = new byte[4096];
                                    byteArrayOutputStream = new ByteArrayOutputStream();
                                    int n = 0;
                                    while ((n = inputStream.read(byArray2, 0, byArray2.length)) != -1) {
                                        byteArrayOutputStream.write(byArray2, 0, n);
                                    }
                                    byArray = byteArrayOutputStream.toByteArray();
                                }
                                classProviderListener.classLoadedFromFile(SinglePathClassProvider.this.pathFile);
                            }
                            Object var12_12 = null;
                            if (SinglePathClassProvider.this.cachingEnabled) {
                                SinglePathClassProvider.this.cachedZip = zipFile;
                                break block35;
                            }
                            if (zipFile == null) break block35;
                            try {
                                zipFile.close();
                            }
                            catch (IOException iOException2222) {
                                FFDCFilter.processException((Throwable)iOException2222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "230", this);
                            }
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException2222) {
                                FFDCFilter.processException((Throwable)iOException2222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "241", this);
                            }
                        }
                        if (byteArrayOutputStream != null) {
                            try {
                                byteArrayOutputStream.close();
                            }
                            catch (IOException iOException2222) {
                                FFDCFilter.processException((Throwable)iOException2222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "252", this);
                            }
                        }
                        break block39;
                        {
                            catch (IOException iOException3) {
                                IOException iOException42222;
                                FFDCFilter.processException((Throwable)iOException3, "com.ibm.ws.classloader.SinglePathClassProvider.run", "214", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, iOException3.toString());
                                }
                                Object var12_13 = null;
                                if (SinglePathClassProvider.this.cachingEnabled) {
                                    SinglePathClassProvider.this.cachedZip = zipFile;
                                } else if (zipFile != null) {
                                    try {
                                        zipFile.close();
                                    }
                                    catch (IOException iOException42222) {
                                        FFDCFilter.processException((Throwable)iOException42222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "230", this);
                                    }
                                }
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException iOException42222) {
                                        FFDCFilter.processException((Throwable)iOException42222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "241", this);
                                    }
                                }
                                if (byteArrayOutputStream != null) {
                                    try {
                                        byteArrayOutputStream.close();
                                    }
                                    catch (IOException iOException42222) {
                                        FFDCFilter.processException((Throwable)iOException42222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "252", this);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            IOException iOException52222;
                            Object var12_14 = null;
                            if (SinglePathClassProvider.this.cachingEnabled) {
                                SinglePathClassProvider.this.cachedZip = zipFile;
                            } else if (zipFile != null) {
                                try {
                                    zipFile.close();
                                }
                                catch (IOException iOException52222) {
                                    FFDCFilter.processException((Throwable)iOException52222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "230", this);
                                }
                            }
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException52222) {
                                    FFDCFilter.processException((Throwable)iOException52222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "241", this);
                                }
                            }
                            if (byteArrayOutputStream != null) {
                                try {
                                    byteArrayOutputStream.close();
                                }
                                catch (IOException iOException52222) {
                                    FFDCFilter.processException((Throwable)iOException52222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "252", this);
                                }
                            }
                            throw throwable;
                        }
                    }
                    return byArray;
                }
            });
        }
        return null;
    }

    protected String getRealResourcePath(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.path.length() + string.length() + 1);
        stringBuffer.append(this.path);
        stringBuffer.append(File.separatorChar);
        char[] cArray = string.toCharArray();
        if ((cArray.length != 1 || cArray[0] != '/') && cArray[0] != '\\') {
            boolean bl = true;
            int n = 0;
            int n2 = cArray.length;
            for (int i = 0; i < n2; ++i) {
                if (bl) {
                    while ((cArray[i] == '/' || cArray[i] == '\\') && ++i < n2) {
                    }
                }
                if (cArray[i] == '/' || cArray[i] == '\\') {
                    bl = true;
                    cArray[n++] = File.separatorChar;
                    continue;
                }
                bl = false;
                cArray[n++] = cArray[i];
            }
            stringBuffer.append(cArray, 0, n);
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    public String toString() {
        return "SinglePathClassProvider : " + super.toString() + " classpath = " + this.pathFile.getPath();
    }

    public URL getResource(String string) {
        URL uRL = null;
        if (this.pathExists && string != null) {
            if (emulateURLClassLoader && string.startsWith("/")) {
                return null;
            }
            boolean bl = true;
            if (!this.isDirectory) {
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                bl = string.endsWith(".class") ? this.classesInJar.contains(string, '/') : (string.endsWith("/") ? this.classesInJar.containsDir(string, '/') || this.resourcesInJar.containsDir(string, '/') : this.resourcesInJar.contains(string, '/'));
            }
            if (bl) {
                final String string2 = string;
                uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() {
                        URL uRL;
                        block22: {
                            uRL = null;
                            if (SinglePathClassProvider.this.isDirectory) {
                                try {
                                    String string = SinglePathClassProvider.this.getRealResourcePath(string2);
                                    File file = new File(string);
                                    if (!file.exists()) break block22;
                                    uRL = file.getCanonicalFile().toURL();
                                    if (string.indexOf("..") >= 0 && string.indexOf("...") < 0 && !uRL.getFile().startsWith(SinglePathClassProvider.this.url.getFile())) {
                                        return null;
                                    }
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.classloader.SinglePathClassProvider.run", "324", this);
                                }
                            } else {
                                ZipFile zipFile = null;
                                try {
                                    zipFile = new ZipFile(SinglePathClassProvider.this.pathFile);
                                    ZipEntry zipEntry = zipFile.getEntry(string2);
                                    if (zipEntry != null) {
                                        String string = SinglePathClassProvider.this.pathFile.toURL().toString();
                                        uRL = new URL(new URL("wsjar", "", -1, string + "!/"), string2);
                                    }
                                }
                                catch (IOException iOException) {
                                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "350", this);
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.classloader.SinglePathClassProvider.run", "354", this);
                                }
                                finally {
                                    if (zipFile != null) {
                                        try {
                                            zipFile.close();
                                        }
                                        catch (IOException iOException) {
                                            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "410", this);
                                        }
                                    }
                                }
                            }
                        }
                        return uRL;
                    }
                });
            }
        }
        if (uRL != null) {
            uRL = SinglePathClassProvider.checkURL(uRL);
        }
        return uRL;
    }

    private static URL checkURL(URL uRL) {
        try {
            SinglePathClassProvider.check(uRL);
        }
        catch (Exception exception) {
            return null;
        }
        return uRL;
    }

    private static void check(URL uRL) throws IOException {
        Permission permission;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (permission = uRL.openConnection().getPermission()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
                throw securityException;
            }
        }
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected void buildContentsCache() {
        try {
            JarFile jarFile = new JarFile(this.path);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!emulateURLClassLoader && zipEntry.isDirectory()) continue;
                String string = zipEntry.getName();
                if (string.endsWith(".class")) {
                    this.classesInJar.add(string, '/');
                    continue;
                }
                this.resourcesInJar.add(string, '/');
            }
            try {
                this.manifest = jarFile.getManifest();
            }
            catch (Exception exception) {
                // empty catch block
            }
            jarFile.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.buildContentsCache", "453", this);
        }
    }

    private final void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        int n2 = 0;
        for (int i = byArray.length; i > 0; i -= n2) {
            n2 = inputStream.read(byArray, n, i);
            if (n2 < 0) {
                throw new EOFException();
            }
            n += n2;
        }
    }
}

