/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cluster.runtime.ApplicationServerRuntimeImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChainNotInboundException;
import com.ibm.wsspi.channel.framework.exception.NoCFEndPointException;
import com.ibm.wsspi.channel.framework.exception.NullCFEndPointException;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class WLMChainEventListener
extends WsComponentImpl
implements ChainEventListener {
    private static final TraceComponent tc = Tr.register(WLMChainEventListener.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private ChannelFrameworkService cfService;
    private ClusterService clusterService;
    private ClusterMemberService cms;
    private Map endpointCache = new HashMap();
    private Map endpointCacheforInprocess = new HashMap();
    private AdminService adminService;
    private String ivCellName = "";
    private String ivNodeName = "";
    private String ivProcessName = "";

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{object});
        }
        try {
            this.cms = (ClusterMemberService)WsServiceRegistry.getService(this, ClusterMemberService.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, WLMChainEventListener.class.getName() + ".initialize", "127");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize getService Failed");
            }
            throw new ComponentDisabledException();
        }
        ApplicationServerRuntimeImpl.setClusterMemberService(this.cms);
        try {
            this.cfService = (ChannelFrameworkService)WsServiceRegistry.getService(this, ChannelFrameworkService.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, WLMChainEventListener.class.getName() + ".initialize", "142");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize getService Failed");
            }
            throw new ComponentDisabledException();
        }
        if (this.cfService == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", "ChannelFrameworkService is unavailable.  Shutting down the ChainEventListener");
            }
            throw new ComponentDisabledException();
        }
        this.clusterService = ClusterServiceFactory.getClusterService();
        this.adminService = AdminServiceFactory.getAdminService();
        try {
            WsServiceRegistry.addService(this, WLMChainEventListener.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, WLMChainEventListener.class.getName() + ".initialize", "163");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize addService Failed");
            }
            throw new ComponentDisabledException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "start");
            }
            this.ivCellName = this.adminService.getCellName();
            this.ivNodeName = this.adminService.getNodeName();
            this.ivProcessName = this.adminService.getProcessName();
            try {
                this.cfService.addChainEventListener(this, "all_chains");
            }
            catch (ChainException chainException) {
                FFDCFilter.processException((Throwable)chainException, WLMChainEventListener.class.getName() + ".start", "155", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "unexpected exception ", chainException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stop");
            }
            try {
                this.cfService.removeChainEventListener(this, "all_chains");
            }
            catch (ChainException chainException) {
                FFDCFilter.processException((Throwable)chainException, WLMChainEventListener.class.getName() + ".stop", "176", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "unexpected exception ", chainException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void chainInitialized(ChainData chainData) {
    }

    public void chainStarted(ChainData chainData) {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "chainStarted", new Object[]{chainData});
            }
            Identity identity = null;
            byte[] byArray = null;
            try {
                Object object;
                CFEndPoint cFEndPoint;
                block15: {
                    cFEndPoint = this.cfService.getEndPoint(chainData.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "returned CFEndPoint:", cFEndPoint);
                    }
                    try {
                        object = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
                        objectOutputStream.writeByte(0);
                        objectOutputStream.writeObject(cFEndPoint);
                        byArray = ((ByteArrayOutputStream)object).toByteArray();
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, WLMChainEventListener.class.getName() + ".chainStarted", "225", this);
                        if (!tc.isDebugEnabled()) break block15;
                        Tr.debug(tc, "unexpected exception ", iOException);
                    }
                }
                identity = this.mapEndPointToIdentity(cFEndPoint);
                object = null;
                if (cFEndPoint.isLocal()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "endpoint isLocal");
                    }
                    object = this.cms.defineLocalScopedData(identity, byArray);
                    this.endpointCacheforInprocess.put(identity, object);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Define member scope data ");
                    }
                    object = this.cms.defineMemberScopedData(identity, byArray);
                    this.endpointCache.put(identity, object);
                }
            }
            catch (ChainNotInboundException chainNotInboundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempted to start an outbound chain.  Only inbound chains be started.", chainData.getName());
                }
            }
            catch (NoCFEndPointException noCFEndPointException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempted to start a chain which includes a channel that does not implement the WSChannelFactory interface.", chainData.getName());
                }
            }
            catch (NullCFEndPointException nullCFEndPointException) {
                FFDCFilter.processException((Throwable)nullCFEndPointException, WLMChainEventListener.class.getName() + ".chainStarted", "254", this);
                Tr.error(tc, "WLMKEY_UNABLE_TO_RETRIEVE_CFENDPOINT", chainData.getName());
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "unexpected exception ", nullCFEndPointException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chainStarted");
        }
    }

    public void chainStopped(ChainData chainData) {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "chainStopped", new Object[]{chainData});
            }
            try {
                CFEndPoint cFEndPoint = this.cfService.getEndPoint(chainData.getName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "returned CFEndPoint:", cFEndPoint);
                }
                Identity identity = this.mapEndPointToIdentity(cFEndPoint);
                EndPoint endPoint = null;
                endPoint = cFEndPoint.isLocal() ? (EndPoint)this.endpointCacheforInprocess.remove(identity) : (EndPoint)this.endpointCache.remove(identity);
                if (endPoint != null) {
                    if (cFEndPoint.isLocal()) {
                        this.cms.undefineLocalScopedData(endPoint);
                    } else {
                        this.cms.undefineMemberScopedData(endPoint);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The EndPoint associated with chainName was not found in the WLM EndPoint cache.", chainData.getName());
                }
            }
            catch (ChainNotInboundException chainNotInboundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempted to start/stop an outbound chain.  Only inbound chains be started.", chainData.getName());
                }
            }
            catch (NoCFEndPointException noCFEndPointException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempted to start/stop a chain which includes a channel that does not implement the WSChannelFactory interface.", chainData.getName());
                }
            }
            catch (NullCFEndPointException nullCFEndPointException) {
                FFDCFilter.processException((Throwable)nullCFEndPointException, WLMChainEventListener.class.getName() + ".chainStopped", "316", this);
                Tr.error(tc, "WLMKEY_UNABLE_TO_RETRIEVE_CFENDPOINT", chainData);
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug(tc, "unexpected exception ", nullCFEndPointException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chainStopped");
        }
    }

    public void chainDestroyed(ChainData chainData) {
    }

    public void chainUpdated(ChainData chainData) {
    }

    private Identity mapEndPointToIdentity(CFEndPoint cFEndPoint) {
        Identity identity = null;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("NAME", cFEndPoint.getName());
        treeMap.put("CELL", this.ivCellName);
        treeMap.put("NODE", this.ivNodeName);
        treeMap.put("SERVER", this.ivProcessName);
        treeMap.put("TYPE", "CHANNEL");
        treeMap.put("COMPONENT", "CF");
        identity = this.clusterService.getIdentity(treeMap);
        return identity;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.17 ");
        }
    }
}

