/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.rule;

import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.wsspi.cluster.selection.RuleArbitrator;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ApplicableStatesRule
implements SelectionRule {
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private RuleArbitrator arbitrator = null;
    private final byte[] applicableStates;

    public ApplicableStatesRule(byte[] byArray) {
        this.applicableStates = byArray;
    }

    public void subset(List list, StringBuffer stringBuffer) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DescriptionKey descriptionKey = (DescriptionKey)iterator.next();
            if (this.arbitrator != null) {
                this.arbitrator.registerNotificationType(this, descriptionKey, "type.state.change.availability");
            }
            ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)descMgr.getDescription(descriptionKey).getMemento();
            byte by = memento.getAvailability();
            boolean bl = true;
            for (int i = 0; i < this.applicableStates.length; ++i) {
                if (by != this.applicableStates[i]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            iterator.remove();
            stringBuffer.append(descriptionKey).append(" removed: state not applicable. ").append(by);
        }
    }

    public void registerRuleArbitrator(RuleArbitrator ruleArbitrator) {
        this.arbitrator = ruleArbitrator;
    }

    public String toString() {
        return super.toString() + Arrays.toString(this.applicableStates);
    }
}

