/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Concern;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.TriggerInfo;
import com.ibm.ws.cluster.topography.ConcernImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;

public class ContractImpl
implements Contract {
    private static final TraceComponent tc = Tr.register(ContractImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private int frequency = 0;
    private Concern concern = new ConcernImpl(Integer.MAX_VALUE);
    private Set events = new HashSet();

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int n) {
        this.frequency = n;
    }

    public Set getEvents() {
        return this.events;
    }

    public void addEvent(TriggerInfo triggerInfo) {
        this.events.add(triggerInfo);
    }

    public void addAllEvents(Set set) {
        this.events.addAll(set);
    }

    public void removeEvent(TriggerInfo triggerInfo) {
        this.events.remove(triggerInfo);
    }

    public boolean match(TriggerInfo triggerInfo) {
        return triggerInfo == null ? false : (this.events.contains(triggerInfo) ? true : this.match(triggerInfo.getSuperType()));
    }

    public Concern getInterest() {
        return this.concern;
    }

    public void setInterest(Concern concern) {
        this.concern = concern;
    }

    public boolean subset(Contract contract) {
        return contract.getFrequency() <= this.frequency && this.concern.getInterest() == (this.concern.getInterest() & contract.getInterest().getInterest()) && contract.getEvents().containsAll(this.events);
    }

    public Contract getUnion(Contract contract) {
        ContractImpl contractImpl = new ContractImpl();
        contractImpl.setFrequency(this.frequency < contract.getFrequency() ? this.frequency : contract.getFrequency());
        contractImpl.setInterest(new ConcernImpl(this.concern.getInterest() | contract.getInterest().getInterest()));
        contractImpl.addAllEvents(this.events);
        contractImpl.addAllEvents(contract.getEvents());
        return contractImpl;
    }

    public boolean equals(Object object) {
        try {
            Contract contract = (Contract)object;
            if (contract.getFrequency() != this.frequency) {
                return false;
            }
            if (!contract.getInterest().equals(this.concern)) {
                return false;
            }
            if (!((Object)contract.getEvents()).equals(this.events)) {
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.frequency | this.concern.hashCode() | ((Object)this.events).hashCode();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(0);
        objectOutput.writeInt(this.frequency);
        objectOutput.writeObject(this.concern);
        objectOutput.writeObject(this.events);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readByte();
        this.frequency = objectInput.readInt();
        this.concern = (Concern)objectInput.readObject();
        this.events = (Set)objectInput.readObject();
    }

    public String toString() {
        return this.concern.toString() + this.events.toString() + this.frequency;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.2 ");
        }
    }
}

