/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionA;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.IdentityMap;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class IdentityMapImpl
extends DescriptionA
implements IdentityMap {
    private static final TraceComponent tc = Tr.register(IdentityMap.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final int NUMBER_DOUBLE = 5;
    private static final int NUMBER_FLOAT = 4;
    private static final int NUMBER_LONG = 3;
    private static final int NUMBER_INTEGER = 2;
    private static final int NUMBER_SHORT = 1;
    private static final int NUMBER_BYTE = 0;
    private static final int TYPE_NULL = -1;
    private static final int TYPE_NUMBER = 0;
    private static final int TYPE_STRING = 1;
    private static final int TYPE_DESCRIPTION_KEY = 2;
    private static final int TYPE_DESCRIPTION = 3;
    private static final KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private final Map map = Collections.synchronizedMap(new HashMap());

    public IdentityMapImpl(DescriptionKey descriptionKey) {
        super(descriptionKey);
    }

    public int size() {
        return ((MementoImpl)this.getMemento()).m_map.size();
    }

    public boolean isEmpty() {
        return ((MementoImpl)this.getMemento()).m_map.isEmpty();
    }

    public boolean containsKey(Object object) {
        return ((MementoImpl)this.getMemento()).m_map.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return ((MementoImpl)this.getMemento()).m_map.containsValue(object);
    }

    public synchronized Object get(Object object) {
        return ((MementoImpl)this.getMemento()).m_map.get(object);
    }

    public synchronized Object put(Object object, Object object2) {
        Object object3 = this.map.put(object, object2);
        this.updateMemento();
        return object3;
    }

    public synchronized Object remove(Object object) {
        Object v = this.map.remove(object);
        this.updateMemento();
        return v;
    }

    public void putAll(Map map) {
        this.map.putAll(map);
        this.updateMemento();
    }

    public void clear() {
        this.map.clear();
        this.updateMemento();
    }

    public Set keySet() {
        return ((MementoImpl)this.getMemento()).m_map.keySet();
    }

    public Collection values() {
        return ((MementoImpl)this.getMemento()).m_map.values();
    }

    public Set entrySet() {
        return ((MementoImpl)this.getMemento()).m_map.entrySet();
    }

    public String getDefinitionKey() {
        return IdentityMap.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void exportToStream(DataOutput dataOutput, Format format) throws IOException {
        int n;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "exportToStream");
        }
        int n2 = 0;
        dataOutput.writeByte(n2);
        Map map = this.map;
        synchronized (map) {
            n = this.map.size();
            dataOutput.writeInt(n);
            Iterator iterator = this.map.entrySet().iterator();
            for (int i = 0; i < n; ++i) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                this.writeOut(k, dataOutput);
                Object v = entry.getValue();
                this.writeOut(v, dataOutput);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote version " + n2);
            Tr.debug(tc, "wrote size " + n);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeOut(Object object, DataOutput dataOutput) throws IOException {
        if (object == null) {
            dataOutput.writeByte(-1);
            return;
        }
        if (object instanceof Number) {
            dataOutput.writeByte(0);
            Number number = (Number)object;
            if (number instanceof Byte) {
                dataOutput.writeByte(0);
                dataOutput.writeByte(number.byteValue());
                return;
            }
            if (number instanceof Short) {
                dataOutput.writeByte(1);
                dataOutput.writeShort(number.shortValue());
                return;
            }
            if (number instanceof Integer) {
                dataOutput.writeByte(2);
                dataOutput.writeInt(number.intValue());
                return;
            }
            if (number instanceof Long) {
                dataOutput.writeByte(3);
                dataOutput.writeLong(number.longValue());
                return;
            }
            if (number instanceof Float) {
                dataOutput.writeByte(4);
                dataOutput.writeFloat(number.floatValue());
                return;
            }
            if (number instanceof Double) {
                dataOutput.writeByte(5);
                dataOutput.writeDouble(number.doubleValue());
                return;
            }
            if (!tc.isEventEnabled()) throw new IOException("The value for " + object + " was not a correct number type. " + number.getClass());
            Tr.event(tc, "unexpected");
            throw new IOException("The value for " + object + " was not a correct number type. " + number.getClass());
        }
        if (object instanceof CharSequence) {
            dataOutput.writeByte(1);
            dataOutput.writeUTF(object.toString());
            return;
        }
        if (object instanceof DescriptionKey) {
            dataOutput.writeByte(2);
            keyRepository.exportToStream(dataOutput, (DescriptionKey)object);
            return;
        }
        if (object instanceof Description) {
            dataOutput.writeByte(3);
            keyRepository.exportToStream(dataOutput, ((Description)object).getKey());
            return;
        }
        if (!tc.isEventEnabled()) throw new IllegalArgumentException("Object was not a supported type.\n" + object.getClass());
        Tr.event(tc, "unexpected");
        throw new IllegalArgumentException("Object was not a supported type.\n" + object.getClass());
    }

    public synchronized Description.Memento importFromStream(DataInput dataInput, Format format, Description.Memento memento) throws IOException {
        MementoImpl mementoImpl;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "importFromStream");
        }
        if ((mementoImpl = (MementoImpl)memento) == null) {
            mementoImpl = (MementoImpl)this.createMemento();
        }
        byte by = dataInput.readByte();
        int n = dataInput.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read version " + by);
            Tr.debug(tc, "read size " + n);
        }
        for (int i = 0; i < n; ++i) {
            Object object = this.readIn(dataInput);
            Object object2 = this.readIn(dataInput);
            mementoImpl.m_map.put(object, object2);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "importFromStream");
        }
        return mementoImpl;
    }

    private Object readIn(DataInput dataInput) throws IOException {
        Object object = null;
        byte by = dataInput.readByte();
        block1 : switch (by) {
            case -1: {
                object = null;
                break;
            }
            case 0: {
                byte by2 = dataInput.readByte();
                switch (by2) {
                    case 0: {
                        object = new Byte(dataInput.readByte());
                        break block1;
                    }
                    case 1: {
                        object = new Short(dataInput.readShort());
                        break block1;
                    }
                    case 2: {
                        object = new Integer(dataInput.readInt());
                        break block1;
                    }
                    case 3: {
                        object = new Long(dataInput.readLong());
                        break block1;
                    }
                    case 4: {
                        object = new Float(dataInput.readFloat());
                        break block1;
                    }
                    case 5: {
                        object = new Double(dataInput.readDouble());
                        break block1;
                    }
                }
                object = null;
                break;
            }
            case 1: {
                object = dataInput.readUTF();
                break;
            }
            case 2: {
                object = keyRepository.importFromStream(dataInput);
                break;
            }
            case 3: {
                DescriptionKey descriptionKey = keyRepository.importFromStream(dataInput);
                String string = dataInput.readUTF();
                try {
                    object = descMgr.getDescription(descriptionKey, string);
                    break;
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, IdentityMapImpl.class.getName() + ".readIn", "438", this, new Object[]{descriptionKey, string});
                    IOException iOException = new IOException("Unable to fluff up description.  Exception logged to ffdc.");
                    iOException.initCause(exception);
                    throw iOException;
                }
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    public Description.Memento createMemento() {
        return new MementoImpl();
    }

    public void setMemento(Description.Memento memento) {
        Map.Entry entry;
        MementoImpl mementoImpl = (MementoImpl)this.getMemento();
        super.setMemento(memento);
        Iterator iterator = mementoImpl.m_map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (((MementoImpl)memento).m_map.containsKey(entry.getKey())) continue;
            this.notifyListeners("type.key.removed", entry.getKey());
        }
        iterator = ((MementoImpl)memento).m_map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!mementoImpl.m_map.containsKey(entry.getKey())) {
                this.notifyListeners("type.key.added", entry.getKey());
                continue;
            }
            Object v = ((MementoImpl)memento).m_map.get(entry.getKey());
            Object v2 = mementoImpl.m_map.get(entry.getKey());
            if (v == null && v2 != null) {
                this.notifyListeners("type.value.modified", entry.getKey());
                continue;
            }
            if (v != null && v2 == null) {
                this.notifyListeners("type.value.modified", entry.getKey());
                continue;
            }
            if (v == null || v.equals(v2)) continue;
            this.notifyListeners("type.value.modified", entry.getKey());
        }
    }

    public String toString() {
        return super.toString() + (this.map == null ? null : this.map.toString());
    }

    public final class MementoImpl
    extends DescriptionA.MementoA {
        private final Map m_map = new HashMap();

        public String toString() {
            return super.toString() + this.m_map;
        }
    }
}

