/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.models.config.ipc.ssl.KeySetGroup;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.crypto.config.KeySetManager;
import com.ibm.ws.crypto.config.WSKeySetGroup;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;

public class KeySetGroupManager {
    private static final TraceComponent tc = Tr.register(KeySetGroupManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static KeySetGroupManager thisClass = null;
    private HashMap keySetGroupMap = new HashMap();

    private KeySetGroupManager() {
    }

    public static KeySetGroupManager getInstance() {
        if (thisClass == null) {
            thisClass = new KeySetGroupManager();
        }
        return thisClass;
    }

    public void initializeKeySetGroups(Security security2, boolean bl) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeKeySetGroups");
        }
        try {
            if (bl) {
                this.keySetGroupMap.clear();
            }
            KeySetManager.getInstance().initializeKeySets(security2, bl);
            EList eList = security2.getKeySetGroups();
            if (eList != null && eList.size() > 0) {
                for (int i = 0; i < eList.size(); ++i) {
                    KeySetGroup keySetGroup = (KeySetGroup)eList.get(i);
                    if (keySetGroup == null) continue;
                    String string = keySetGroup.getManagementScope().getScopeName();
                    if (string != null && !ManagementScopeManager.getInstance().currentScopeContained(string)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Skipping keyset group name \"" + keySetGroup.getName() + "\" having scope \"" + string + "\".");
                        continue;
                    }
                    WSKeySetGroup wSKeySetGroup = new WSKeySetGroup(keySetGroup);
                    if (wSKeySetGroup == null) continue;
                    this.keySetGroupMap.put(keySetGroup.getName(), wSKeySetGroup);
                }
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception initializing KeySetGroups.", new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.crypto.config.KeySetGroupManager.initializeKeySetGroups", "104", this);
            throw new KeyException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeKeySetGroups");
        }
    }

    public WSKeySetGroup getKeySetGroup(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeySetGroup -> " + string);
        }
        boolean bl = false;
        WSKeySetGroup wSKeySetGroup = (WSKeySetGroup)this.keySetGroupMap.get(string);
        if (wSKeySetGroup != null) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeySetGroup -> " + bl);
        }
        return wSKeySetGroup;
    }
}

