/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.matcher.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.QuickHeaderMatcher;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import java.util.Iterator;

public class HttpHeaderMatcher
extends QuickHeaderMatcher {
    private static final TraceComponent tc = Tr.register(HttpHeaderMatcher.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpHeaderMatcher myInstance = null;

    private HttpHeaderMatcher() {
        this.init();
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpHeaderMatcher();
        }
    }

    public static final HttpHeaderMatcher getRef() {
        if (null == myInstance) {
            HttpHeaderMatcher.createSingleton();
        }
        return myInstance;
    }

    public void init() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing HTTP header matcher");
        }
        HttpHeaderKeys httpHeaderKeys = HttpConstants.HDR_ACCEPT;
        Iterator iterator = HttpHeaderKeys.getAllKeys().iterator();
        while (iterator.hasNext()) {
            httpHeaderKeys = (HttpHeaderKeys)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Matcher storing " + httpHeaderKeys);
            }
            super.add(httpHeaderKeys);
        }
        super.init();
    }

    public static void main(String[] stringArray) {
        System.out.println("Started");
        HttpHeaderMatcher httpHeaderMatcher = HttpHeaderMatcher.getRef();
        System.out.println();
        System.out.println("The following should find matches...");
        String string = "Connection";
        System.out.println("Matching " + string + " (String) " + httpHeaderMatcher.matchHeader(string));
        string = "Accept";
        System.out.println("Matching " + string + " (StringBuffer) " + httpHeaderMatcher.matchHeader(new StringBuffer(string)));
        string = "CACHE-control";
        System.out.println("Matching " + string + " (byte[]) " + httpHeaderMatcher.matchHeader(string.getBytes()));
        string = "conTENT-LenGTH";
        System.out.println("Matching " + string + " (String) " + httpHeaderMatcher.matchHeader(string));
        string = "$WSZIP";
        System.out.println("Matching " + string + " (byte[]) " + httpHeaderMatcher.matchHeader(string.getBytes()));
        System.out.println();
        System.out.println("The following should return NO_MATCH...");
        string = "mySuperHeader";
        System.out.println("Matching " + string + " (String) " + httpHeaderMatcher.matchHeader(string));
        StringBuffer stringBuffer = new StringBuffer("yourSpectacularHeader");
        System.out.println("Matching " + new String(stringBuffer) + " (StringBuffer) " + httpHeaderMatcher.matchHeader(stringBuffer));
        try {
            httpHeaderMatcher.matchHeader("test\r\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("CRLF found with string (4): " + illegalArgumentException.getMessage());
        }
        try {
            httpHeaderMatcher.matchHeader("te\rst".getBytes());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("CRLF found with bytes (2): " + illegalArgumentException.getMessage());
        }
        try {
            httpHeaderMatcher.matchHeader(new StringBuffer("t\nest"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("CRLF found with stringbuffer (1): " + illegalArgumentException.getMessage());
        }
    }
}

