/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.matcher.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.values.VersionValues;

public class VersionMatcher {
    private static final TraceComponent tc = Tr.register(VersionMatcher.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final byte[] HTTP_BYTES = new byte[]{72, 84, 84, 80, 47};
    private static final char[] HTTP_CHARS = new char[]{'H', 'T', 'T', 'P', '/'};
    private static VersionMatcher myInstance = null;

    private VersionMatcher() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "VersionMatcher created");
        }
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new VersionMatcher();
        }
    }

    public static final VersionMatcher getRef() {
        if (null == myInstance) {
            VersionMatcher.createSingleton();
        }
        return myInstance;
    }

    public VersionValues matchVersion(String string) {
        int n;
        int n2 = string.length();
        if (8 > n2) {
            return null;
        }
        for (n = 0; n < HTTP_CHARS.length; ++n) {
            if (string.charAt(n) == HTTP_CHARS[n]) continue;
            return null;
        }
        if ('.' == string.charAt(n)) {
            return null;
        }
        if ('0' == string.charAt(n)) {
            ++n;
            while (n < n2 && '0' == string.charAt(n)) {
                ++n;
            }
            if (n == n2) {
                return null;
            }
        }
        int n3 = 0;
        if ('.' != string.charAt(n) && (1 != (n3 = string.charAt(n) - 48) || ++n == n2 || '.' != string.charAt(n))) {
            return null;
        }
        if (++n == n2) {
            return null;
        }
        int n4 = string.charAt(n) - 48;
        VersionValues versionValues = null;
        if (0 == n3) {
            if (9 == n4) {
                versionValues = HttpConstants.HTTP_VERSION_09;
            }
        } else if (0 == n4) {
            versionValues = HttpConstants.HTTP_VERSION_10;
        } else if (1 == n4) {
            versionValues = HttpConstants.HTTP_VERSION_11;
        }
        if (null != versionValues) {
            for (int i = ++n; i < n2; ++i) {
                if ('0' == string.charAt(i)) continue;
                return null;
            }
        }
        return versionValues;
    }

    public VersionValues matchVersion(StringBuffer stringBuffer) {
        int n;
        int n2 = stringBuffer.length();
        if (8 > n2) {
            return null;
        }
        for (n = 0; n < HTTP_CHARS.length; ++n) {
            if (stringBuffer.charAt(n) == HTTP_CHARS[n]) continue;
            return null;
        }
        if ('.' == stringBuffer.charAt(n)) {
            return null;
        }
        if ('0' == stringBuffer.charAt(n)) {
            ++n;
            while (n < n2 && '0' == stringBuffer.charAt(n)) {
                ++n;
            }
            if (n == n2) {
                return null;
            }
        }
        int n3 = 0;
        if ('.' != stringBuffer.charAt(n) && (1 != (n3 = stringBuffer.charAt(n) - 48) || ++n == n2 || '.' != stringBuffer.charAt(n))) {
            return null;
        }
        if (++n == n2) {
            return null;
        }
        int n4 = stringBuffer.charAt(n) - 48;
        VersionValues versionValues = null;
        if (0 == n3) {
            if (9 == n4) {
                versionValues = HttpConstants.HTTP_VERSION_09;
            }
        } else if (0 == n4) {
            versionValues = HttpConstants.HTTP_VERSION_10;
        } else if (1 == n4) {
            versionValues = HttpConstants.HTTP_VERSION_11;
        }
        if (null != versionValues) {
            for (int i = ++n; i < n2; ++i) {
                if ('0' == stringBuffer.charAt(i)) continue;
                return null;
            }
        }
        return versionValues;
    }

    public VersionValues matchVersion(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        if (8 > n2) {
            return null;
        }
        for (n = 0; n < HTTP_CHARS.length; ++n) {
            if (byArray[n] == HTTP_BYTES[n]) continue;
            return null;
        }
        if (46 == byArray[n]) {
            return null;
        }
        if (48 == byArray[n]) {
            ++n;
            while (n < n2 && 48 == byArray[n]) {
                ++n;
            }
            if (n == n2) {
                return null;
            }
        }
        int n3 = 0;
        if (46 != byArray[n] && (1 != (n3 = byArray[n] - 48) || ++n == n2 || 46 != byArray[n])) {
            return null;
        }
        if (++n == n2) {
            return null;
        }
        int n4 = byArray[n] - 48;
        VersionValues versionValues = null;
        if (0 == n3) {
            if (9 == n4) {
                versionValues = HttpConstants.HTTP_VERSION_09;
            }
        } else if (0 == n4) {
            versionValues = HttpConstants.HTTP_VERSION_10;
        } else if (1 == n4) {
            versionValues = HttpConstants.HTTP_VERSION_11;
        }
        if (null != versionValues) {
            for (int i = ++n; i < n2; ++i) {
                if (48 == byArray[i]) continue;
                return null;
            }
        }
        return versionValues;
    }

    public static void main(String[] stringArray) {
        VersionMatcher versionMatcher = VersionMatcher.getRef();
        System.out.println("matching...");
        System.out.println();
        System.out.println("Following should find matches...");
        String string = "HTTP/1.0";
        System.out.println("Matching (String) " + string + " " + versionMatcher.matchVersion(string));
        string = "HTTP/1.1";
        System.out.println("Matching (String) " + string + " " + versionMatcher.matchVersion(string));
        string = "HTTP/0.9";
        System.out.println("Matching (String) " + string + " " + versionMatcher.matchVersion(string));
        string = "HTTP/001.100";
        System.out.println("Matching (String) " + string + " " + versionMatcher.matchVersion(string));
        string = "HTTP/000.9";
        System.out.println("Matching (String) " + string + " " + versionMatcher.matchVersion(string));
        string = "HTTP/1.0";
        System.out.println("Matching (StringBuffer) " + string + " " + versionMatcher.matchVersion(new StringBuffer(string)));
        string = "HTTP/1.1";
        System.out.println("Matching (StringBuffer) " + string + " " + versionMatcher.matchVersion(new StringBuffer(string)));
        string = "HTTP/0.9";
        System.out.println("Matching (StringBuffer) " + string + " " + versionMatcher.matchVersion(new StringBuffer(string)));
        string = "HTTP/001.0000";
        System.out.println("Matching (StringBuffer) " + string + " " + versionMatcher.matchVersion(new StringBuffer(string)));
        string = "HTTP/00000001.1";
        System.out.println("Matching (StringBuffer) " + string + " " + versionMatcher.matchVersion(new StringBuffer(string)));
        string = "HTTP/1.0";
        System.out.println("Matching (byte[]) " + string + " " + versionMatcher.matchVersion(string.getBytes()));
        string = "HTTP/1.1";
        System.out.println("Matching (byte[]) " + string + " " + versionMatcher.matchVersion(string.getBytes()));
        string = "HTTP/0.9";
        System.out.println("Matching (byte[]) " + string + " " + versionMatcher.matchVersion(string.getBytes()));
        string = "HTTP/00001.0";
        System.out.println("Matching (byte[]) " + string + " " + versionMatcher.matchVersion(string.getBytes()));
        string = "HTTP/000.900";
        System.out.println("Matching (byte[]) " + string + " " + versionMatcher.matchVersion(string.getBytes()));
        System.out.println();
        System.out.println("Following should return null responses...");
        string = "HTTP/2.0";
        System.out.println("Matching (StringBuffer) " + string + " " + versionMatcher.matchVersion(new StringBuffer(string)));
        string = "ftp/1.0";
        System.out.println("Matching (byte[]) " + string + " " + versionMatcher.matchVersion(string.getBytes()));
        string = "HTTP/0.1";
        System.out.println("Matching (String) " + string + " " + versionMatcher.matchVersion(string));
        string = "HTTP/0003.0";
        System.out.println("Matching (String) " + string + " " + versionMatcher.matchVersion(string));
        string = "HTTP/.00";
        System.out.println("Matching (String) " + string + " " + versionMatcher.matchVersion(string));
        string = "http/q.9";
        System.out.println("Matching (byte[]) " + string + " " + versionMatcher.matchVersion(string.getBytes()));
        string = "HTTP/000.9001";
        System.out.println("Matching (byte[]) " + string + " " + versionMatcher.matchVersion(string.getBytes()));
        string = "HTTP/001.1001";
        System.out.println("Matching (String) " + string + " " + versionMatcher.matchVersion(string));
        string = "HTTP/001.0001";
        System.out.println("Matching (StringBuffer) " + string + " " + versionMatcher.matchVersion(new StringBuffer(string)));
    }
}

