/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging;

import com.ibm.ws.logging.WsLogger;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerHelper {
    public static final String EXTENSION_NAME_HANDLER_PREFERENCE = "handler_preference";
    public static final String EXTENSION_VALUE_HANDLER_PREFERENCE_OPERATOR = "operator";
    public static final String EXTENSION_NAME_DIAGNOSTIC_PROVIDER_ID = "DiagnosticProvider";
    public static final String EXTENSION_NAME_SERVICELOG_ONLY_PREFERENCE = "service_log_only";

    public static void addLoggerToGroup(Logger logger, String string) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to addLoggerToGroup must not be null");
        }
        if (string == null) {
            throw new NullPointerException("group name passed as argument to addLoggerToGroup must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to addLoggerToGroup must be a named logger");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;: ");
        while (stringTokenizer.hasMoreTokens()) {
            ((WsLogger)logger).addToGroup(stringTokenizer.nextToken().trim());
        }
    }

    public static String getExtension(Logger logger, String string) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to getExtension must not be null");
        }
        if (string == null) {
            throw new NullPointerException("name passed as argument to getExtension must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to getExtension must be a named logger");
        }
        return ((WsLogger)logger).getExtension(string);
    }

    public static Map getExtensions(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to getExtensions must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to getExtensions must be a named logger");
        }
        return ((WsLogger)logger).getExtensions();
    }

    public static void addExtension(Logger logger, String string, String string2) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to addExtension must not be null");
        }
        if (string == null) {
            throw new NullPointerException("name passed as argument to addExtension must not be null");
        }
        if (string2 == null) {
            throw new NullPointerException("value passed as argument to addExtension must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to addExtension must be a named logger");
        }
        ((WsLogger)logger).addExtension(string, string2);
    }

    public static void addExtensions(Logger logger, Map map) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to addExtensions must not be null");
        }
        if (map == null) {
            throw new NullPointerException("extensions passed as argument to addExtensions must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to addExtensions must be a named logger");
        }
        ((WsLogger)logger).addExtensions(map);
    }

    public static void removeExtension(Logger logger, String string) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to removeExtension must not be null");
        }
        if (string == null) {
            throw new NullPointerException("name passed as argument to removeExtension must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to removeExtension must be a named logger");
        }
        ((WsLogger)logger).removeExtension(string);
    }

    public static void clearExtensions(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to clearExtensions must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to clearExtensions must be a named logger");
        }
        ((WsLogger)logger).clearExtensions();
    }

    public static void setAttributes(Logger logger, String string, String string2, String string3, Level level) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to setAttributes must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to setAttributes must be a named logger");
        }
        WsLogger wsLogger = (WsLogger)logger;
        if (string != null) {
            wsLogger.setOrganization(string);
        }
        if (string2 != null) {
            wsLogger.setProduct(string2);
        }
        if (string3 != null) {
            wsLogger.setComponent(string3);
        }
        if (level != null) {
            wsLogger.setMinimumLocalizationLevel(level);
        }
    }
}

