/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.util.PortConflictResolverException;
import com.ibm.ws.management.util.PortConflictResolverNoTrace;
import java.io.File;

public class PortConflictResolver
extends PortConflictResolverNoTrace {
    private static TraceComponent tc = Tr.register(PortConflictResolver.class, "Admin", null);

    public PortConflictResolver() throws PortConflictResolverException {
    }

    public PortConflictResolver(String[] stringArray) throws PortConflictResolverException {
        super(stringArray);
    }

    public synchronized int getPort(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPort " + n);
        }
        int n2 = super.getPort(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPort " + n2);
        }
        return n2;
    }

    protected boolean reservePortInternal(String string) {
        boolean bl = super.reservePortInternal(string);
        if (tc.isDebugEnabled()) {
            if (bl) {
                Tr.debug(tc, string + " successfully reserved.");
            } else {
                Tr.debug(tc, string + " already in use");
            }
        }
        return bl;
    }

    public boolean unreservePort(int n) {
        boolean bl = super.unreservePort(n);
        if (tc.isDebugEnabled()) {
            String string = Integer.toString(n);
            if (bl) {
                Tr.debug(tc, string + " successfully unreserved.");
            } else {
                Tr.debug(tc, string + " was not previously reserved.");
            }
        }
        return bl;
    }

    protected void readPortsFromAllConfigRoots() throws PortConflictResolverException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Reading ports from", this.getConfigRoots());
        }
        super.readPortsFromAllConfigRoots();
    }

    protected void readPortsFromConfigRoot(String string) throws PortConflictResolverException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readPortsFromConfigRoot", string);
        }
        super.readPortsFromConfigRoot(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readPortsFromConfigRoot");
        }
    }

    protected void readPorts(String string, String string2, String[] stringArray) throws PortConflictResolverException {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[ ");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i + 1 >= stringArray.length) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" ]");
            Tr.entry(tc, "readPorts", new String[]{string, string2, stringBuffer.toString()});
        }
        super.readPorts(string, string2, stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readPorts");
        }
    }

    protected void parseServerIndex(File file) throws PortConflictResolverException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseServerIndex", file);
        }
        super.parseServerIndex(file);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseServerIndex");
        }
    }
}

