/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.metadata;

import com.ibm.ejs.csi.ResRefImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.GlobalTranConfigData;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.LocalTranConfigData;
import com.ibm.websphere.csi.ResRef;
import com.ibm.websphere.csi.ResRefList;
import com.ibm.ws.naming.java.javaNameSpace;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ContainerComponentMetaData;
import com.ibm.ws.runtime.metadata.CustomContainerComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.Context;

public class CustomContainerComponentMetaDataImpl
implements CustomContainerComponentMetaData {
    private static final TraceComponent tc = Tr.register(CustomContainerComponentMetaDataImpl.class, null, null);
    private static final String EOLN = System.getProperty("line.separator");
    private CustomContainerComponentMetaData.CustomResRefList _resRefList;
    private CustomContainerComponentMetaData.CustomLocalTranCfg _localTranConfigData;
    private CustomContainerComponentMetaData.CustomGlobalTranCfg _globalTranConfigData;
    private J2EEName _j2eeName;
    private javaNameSpace _javaNameSpace;
    private Context _javaNamespaceContext;
    private String _name;
    private ComponentMetaData _sourceMetaData = null;

    public CustomContainerComponentMetaDataImpl() {
        this._resRefList = new CustomResRefListImpl();
        this._localTranConfigData = new CustomLocalTranCfgImpl();
        this._globalTranConfigData = new CustomGlobalTranCfgImpl();
    }

    public CustomContainerComponentMetaDataImpl(ComponentMetaData componentMetaData) {
        this._sourceMetaData = componentMetaData;
        this._name = componentMetaData.getName();
        this._j2eeName = componentMetaData.getJ2EEName();
        if (componentMetaData instanceof ContainerComponentMetaData) {
            ContainerComponentMetaData containerComponentMetaData = (ContainerComponentMetaData)componentMetaData;
            this._globalTranConfigData = new CustomGlobalTranCfgImpl(containerComponentMetaData.getGlobalTranConfigData());
            this._localTranConfigData = new CustomLocalTranCfgImpl(containerComponentMetaData.getLocalTranConfigData());
            this._resRefList = new CustomResRefListImpl(containerComponentMetaData.getResourceRefList());
            this._javaNameSpace = containerComponentMetaData.getJavaNameSpace();
            this._javaNamespaceContext = containerComponentMetaData.getJavaNameSpaceContext();
        }
    }

    public ModuleMetaData getModuleMetaData() {
        return this._sourceMetaData.getModuleMetaData();
    }

    public J2EEName getJ2EEName() {
        return this._j2eeName;
    }

    public void setJ2EEName(J2EEName j2EEName) {
        this._j2eeName = j2EEName;
    }

    public Context getJavaNameSpaceContext() {
        return this._javaNamespaceContext;
    }

    public void setJavaNameSpaceContext(Context context) {
        this._javaNamespaceContext = context;
    }

    public javaNameSpace getJavaNameSpace() {
        return this._javaNameSpace;
    }

    public void setJavaNameSpace(javaNameSpace javaNameSpace2) {
        this._javaNameSpace = javaNameSpace2;
    }

    public String getName() {
        return this._name;
    }

    public void setMetaData(MetaDataSlot metaDataSlot, Object object) {
        this._sourceMetaData.setMetaData(metaDataSlot, object);
    }

    public Object getMetaData(MetaDataSlot metaDataSlot) {
        return this._sourceMetaData.getMetaData(metaDataSlot);
    }

    public void release() {
        this._sourceMetaData.release();
    }

    public LocalTranConfigData getLocalTran() {
        return this._localTranConfigData;
    }

    public LocalTranConfigData getLocalTranConfigData() {
        return this._localTranConfigData;
    }

    public CustomContainerComponentMetaData.CustomLocalTranCfg getCustomLocalTranConfigData() {
        return this._localTranConfigData;
    }

    public GlobalTranConfigData getGlobalTranConfigData() {
        return this._globalTranConfigData;
    }

    public CustomContainerComponentMetaData.CustomGlobalTranCfg getCustomGlobalTranConfigData() {
        return this._globalTranConfigData;
    }

    public ResRefList getResourceRefList() {
        return this._resRefList;
    }

    public CustomContainerComponentMetaData.CustomResRefList getCustomResourceRefList() {
        return this._resRefList;
    }

    public MetaData getSourceMetaData() {
        return this._sourceMetaData;
    }

    public String toString() {
        String string = EOLN;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "                                 ";
        stringBuffer.append(string + string2 + "*** START CustomContainerComponentMetaData fields ***");
        stringBuffer.append(string + string2 + "name=" + this._name);
        stringBuffer.append(string + string2 + "j2eeName=" + this._j2eeName);
        stringBuffer.append(this._localTranConfigData);
        stringBuffer.append(this._globalTranConfigData);
        stringBuffer.append(this._resRefList);
        stringBuffer.append(string + string2 + "srcMetaData Type=" + (this._sourceMetaData == null ? null : this._sourceMetaData.getClass()));
        stringBuffer.append(string + string2 + "*** END CustomContainerComponentMetaData fields  ***");
        stringBuffer.append(string + string2 + "--- Source Meta-Data ---");
        stringBuffer.append(string + (this._sourceMetaData == null ? "-none-" : this._sourceMetaData.toString()));
        return stringBuffer.toString();
    }

    public class CustomGlobalTranCfgImpl
    implements CustomContainerComponentMetaData.CustomGlobalTranCfg {
        private int transactionTimeout;
        private boolean sendWSAT;

        private CustomGlobalTranCfgImpl() {
            this.transactionTimeout = 0;
            this.sendWSAT = false;
        }

        private CustomGlobalTranCfgImpl(GlobalTranConfigData globalTranConfigData) {
            this.transactionTimeout = globalTranConfigData.getTransactionTimeout();
            this.sendWSAT = globalTranConfigData.isSendWSAT();
        }

        public boolean isSendWSAT() {
            return this.sendWSAT;
        }

        public void setSendWSAT(boolean bl) {
            this.sendWSAT = bl;
        }

        public int getTransactionTimeout() {
            return this.transactionTimeout;
        }

        public void setTransactionTimeout(int n) {
            this.transactionTimeout = n;
        }

        public String toString() {
            String string = EOLN;
            String string2 = "                                 ";
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string + string2 + "      ****** CustomGlobalTranCfgImpl *******");
            stringBuffer.append(string + string2 + "transactionTimeout=" + this.transactionTimeout);
            stringBuffer.append(string + string2 + "isSendWSAT=" + this.sendWSAT);
            return stringBuffer.toString();
        }
    }

    public class CustomResRefListImpl
    implements CustomContainerComponentMetaData.CustomResRefList {
        private Vector _resRefVector;

        private CustomResRefListImpl() {
            this.setDefault();
        }

        private CustomResRefListImpl(ResRefList resRefList) {
            if (resRefList == null) {
                this.setDefault();
            } else {
                int n = resRefList.size();
                this._resRefVector = new Vector(n);
                for (int i = 0; i < n; ++i) {
                    ResRefImpl resRefImpl = new ResRefImpl(resRefList.get(i));
                    this._resRefVector.add(i, resRefImpl);
                }
            }
        }

        private void setDefault() {
            this._resRefVector = new Vector();
        }

        public void addResRef(String string, String string2, String string3, String string4, int n, int n2, int n3) {
            this._resRefVector.add(new ResRefImpl(string, string2, string3, string4, n, n2, n3));
        }

        public ResRef findByName(String string) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "findByName", string);
            }
            Iterator iterator = this._resRefVector.iterator();
            ResRef resRef = null;
            while (iterator.hasNext() && !string.equals((resRef = (ResRef)iterator.next()).getName())) {
                resRef = null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (resRef == null) {
                    Tr.debug(tc, "Resource with name '" + string + "' not found. Returning null.");
                } else {
                    Tr.debug(tc, "Returning " + ((ResRefImpl)resRef).toString());
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "findByName");
            }
            return resRef;
        }

        public ResRef findByJNDIName(String string) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "findByJNDIName", string);
            }
            Iterator iterator = this._resRefVector.iterator();
            ResRef resRef = null;
            while (iterator.hasNext() && !string.equals((resRef = (ResRef)iterator.next()).getJNDIName())) {
                resRef = null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (resRef == null) {
                    Tr.debug(tc, "Resource with JNDIName '" + string + "' not found. Returning null.");
                } else {
                    Tr.debug(tc, "Returning " + ((ResRefImpl)resRef).toString());
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "findByJNDIName");
            }
            return resRef;
        }

        public void setLookupString(String string) {
        }

        public int size() {
            return this._resRefVector.size();
        }

        public ResRef get(int n) {
            return (ResRef)this._resRefVector.get(n);
        }

        public String toString() {
            String string = EOLN;
            String string2 = "                                 ";
            StringBuffer stringBuffer = new StringBuffer();
            int n = this._resRefVector.size();
            stringBuffer.append(string + string2 + "      ******* CustomResRefListImpl ******* ");
            stringBuffer.append(string + string2 + "ResRefList size=" + n);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(((ResRefImpl)this._resRefVector.get(i)).toString());
            }
            return stringBuffer.toString();
        }
    }

    public class CustomLocalTranCfgImpl
    implements CustomContainerComponentMetaData.CustomLocalTranCfg {
        private int boundary;
        private int resolver;
        private int unresolvedAction;

        private CustomLocalTranCfgImpl() {
            this.boundary = 0;
            this.resolver = 0;
            this.unresolvedAction = 0;
        }

        private CustomLocalTranCfgImpl(LocalTranConfigData localTranConfigData) {
            this.boundary = localTranConfigData.getValueBoundary();
            this.resolver = localTranConfigData.getValueResolver();
            this.unresolvedAction = localTranConfigData.getValueUnresolvedAction();
        }

        public int getValueBoundary() {
            return this.boundary;
        }

        public int getValueResolver() {
            return this.resolver;
        }

        public int getValueUnresolvedAction() {
            return this.unresolvedAction;
        }

        public void setValueBoundary(int n) {
            this.boundary = n;
        }

        public void setValueResolver(int n) {
            this.resolver = n;
        }

        public void setValueUnresolvedAction(int n) {
            this.unresolvedAction = n;
        }

        public String toString() {
            String string = EOLN;
            String string2 = "                                 ";
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string + string2 + "      ****** CustomLTCDataImpl *******");
            if (this.boundary == 1) {
                stringBuffer.append(string + string2 + "Boundary=ACTIVITY");
            } else if (this.boundary == 0) {
                stringBuffer.append(string + string2 + "Boundary=BEAN_METHOD");
            } else {
                stringBuffer.append(string + string2 + "Boundary=UNKNOWN");
            }
            if (this.resolver == 0) {
                stringBuffer.append(string + string2 + "Resolver=APPLICATION");
            } else if (this.resolver == 1) {
                stringBuffer.append(string + string2 + "Resolver=CONTAINER_AT_BOUNDARY");
            } else {
                stringBuffer.append(string + string2 + "Resolver=UNKNOWN");
            }
            if (this.unresolvedAction == 0) {
                stringBuffer.append(string + string2 + "UnResolvedAction=ROLLBACK");
            } else if (this.unresolvedAction == 1) {
                stringBuffer.append(string + string2 + "UnResolvedAction=COMMIT");
            } else {
                stringBuffer.append(string + string2 + "UnResolvedAction=UNKNOWN");
            }
            return stringBuffer.toString();
        }
    }
}

