/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.timeutils.QuickApproxTime;
import java.util.ArrayList;

public class SSLHandshakeErrorTracker {
    protected static final TraceComponent tc = Tr.register(SSLHandshakeErrorTracker.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    public static final int MAX_ERRORS_PER_INTERVAL = 5;
    protected int maxErrorsPerInterval = 5;
    public static final int ERROR_INTERVAL = 3600000;
    protected int errorInterval = 3600000;
    protected QuickApproxTime approxTime = QuickApproxTime.getRef();
    protected ArrayList errorTimes = new ArrayList();
    protected boolean arrayItemRemoved = false;

    public void noteHandshakeError(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "noteHandshakeError");
        }
        this.addErrorTime(this.approxTime.getApproxTime());
        if (this.errorMessageNeeded()) {
            String string = null;
            if (exception != null) {
                string = exception.toString();
            }
            Tr.error(tc, "handshake.failure", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "noteHandshakeError");
        }
    }

    protected void addErrorTime(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addErrorTime");
        }
        this.errorTimes.add(this.errorTimes.size(), new Long(l));
        if (this.errorTimes.size() > this.maxErrorsPerInterval) {
            this.errorTimes.remove(0);
            this.arrayItemRemoved = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addErrorTime");
        }
    }

    protected boolean errorMessageNeeded() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "errorMessageNeeded");
        }
        boolean bl = false;
        if (!this.arrayItemRemoved) {
            bl = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Have yet to hit maximum time entries.");
            }
        } else {
            long l = (Long)this.errorTimes.get(0);
            long l2 = (Long)this.errorTimes.get(this.maxErrorsPerInterval - 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Comparing first time, " + l + ", to last error time, " + l2);
            }
            if (l2 - l > (long)this.errorInterval) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "errorMessageNeeded");
        }
        return bl;
    }

    protected void setMaximumErrorsPerInterval(int n) {
        this.maxErrorsPerInterval = n;
    }

    protected void setErrorInterval(int n) {
        this.errorInterval = n;
    }
}

