/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.List;
import java.util.Properties;

public class FIPSManager {
    private static final TraceComponent tc = Tr.register(FIPSManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static FIPSManager thisClass = null;
    private boolean fipsEnabled = false;

    private FIPSManager() {
    }

    public static FIPSManager getInstance() {
        if (thisClass == null) {
            thisClass = new FIPSManager();
        }
        return thisClass;
    }

    public boolean isFIPSEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFIPSEnabled");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFIPSEnabled -> " + this.fipsEnabled);
        }
        return this.fipsEnabled;
    }

    public void initializeFIPS() throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeFips");
        }
        try {
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.security.useFIPS");
                    if (string == null) {
                        string = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.jsse2.JSSEFIPS");
                    }
                    if (string == null) {
                        string = Security.getProperty("USEFIPS_ENABLED");
                    }
                    if (string == null) {
                        string = Security.getProperty("com.ibm.websphere.security.fips.enabled");
                    }
                    return string;
                }
            });
            if (string != null && string.equalsIgnoreCase("true")) {
                this.fipsEnabled = true;
                Security.setProperty("DEFAULT_JCE_PROVIDER", "IBMJCEFIPS");
                Security.setProperty("USEFIPS_ENABLED", "true");
                Security.setProperty("com.ibm.websphere.security.fips.enabled", "true");
                Tr.info(tc, "ssl.fips.enabled.CWPKI0012I");
                this.checkDefaultProviderListFromJavaSecurity();
                JSSEProviderFactory.initializeFips();
            } else {
                Security.setProperty("DEFAULT_JCE_PROVIDER", "IBMJCE");
                Security.setProperty("USEFIPS_ENABLED", "false");
                Security.setProperty("com.ibm.websphere.security.fips.enabled", "false");
            }
            Security.setProperty("com.ibm.websphere.security.fips.jsseProviders", "IBMJSSE2");
            Security.setProperty("com.ibm.websphere.security.fips.jceProviders", "IBMJCEFIPS");
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception initializing FIPS.", new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.FIPSManager.initializeFIPS", "135", this);
            throw new SSLException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeFips");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDefaultProviderListFromJavaSecurity() {
        BufferedReader bufferedReader = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkDefaultProviderListFromJavaSecurity");
        }
        String string3 = System.getProperty("java.home");
        string2 = string3 + File.separator + "lib" + File.separator + "security" + File.separator + "java.security";
        try {
            bufferedReader = new BufferedReader(new FileReader(string2));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.trim().startsWith("#") || string.trim().length() <= 0 || !string.trim().startsWith("security.provider")) continue;
                if (string.indexOf("com.ibm.crypto.fips.provider.IBMJCEFIPS") != -1) {
                    bl = true;
                }
                if (string.indexOf("com.ibm.crypto.provider.IBMJCE") == -1) continue;
                if (bl) {
                } else {
                    Tr.warning(tc, "ssl.checkProviderList.warning.CWPKI0013W");
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "In FIPS mode, IBMJCEFIPS provider is not found before the IBMJCE provider in the java.security file.");
                    }
                }
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "FileNotFoundException caught for " + string2);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught: " + exception.getMessage());
            }
        }
        finally {
            block26: {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block26;
                    Tr.debug(tc, "Exception caught: " + exception.getMessage());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkDefaultProviderListFromJavaSecurity");
        }
    }

    private Properties getProperties(List list) {
        Properties properties = new Properties();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Property property = (Property)list.get(i);
                properties.put(property.getName(), property.getValue());
            }
        }
        return properties;
    }
}

