/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerOutputStream;
import com.ibm.websphere.models.config.ipc.ssl.KeyFileFormatKind;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.CertificateManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.WSPKCSInKeyStore;
import com.ibm.ws.ssl.core.WSPKCSInKeyStoreList;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;

public class KeyStoreManager {
    private static final TraceComponent tc = Tr.register(KeyStoreManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static KeyStoreManager thisClass = null;
    private HashMap keyStoreMap = new HashMap();
    private HashMap acceleratorMap = new HashMap();
    private static HashMap expandMap = new HashMap();
    private static String host;
    private static WSPKCSInKeyStoreList pkcsStoreList;
    static /* synthetic */ Class class$java$io$File;

    private KeyStoreManager() {
    }

    public static KeyStoreManager getInstance() {
        if (thisClass == null) {
            KeyStoreManager.getHostName();
            thisClass = new KeyStoreManager();
        }
        return thisClass;
    }

    public void loadKeyStores(com.ibm.websphere.models.config.security.Security security2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadKeyStores");
        }
        this.clearKeyStoreMap();
        EList eList = security2.getKeyStores();
        for (int i = 0; i < eList.size(); ++i) {
            com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)eList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loading KeyStore name " + keyStore.getName() + ".");
            }
            this.loadWCCMKeyStore(keyStore);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadKeyStores");
        }
    }

    public void loadWCCMKeyStore(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadWCCMKeyStore");
        }
        String string = null;
        if (keyStore.getManagementScope() != null) {
            string = keyStore.getManagementScope().getScopeName();
        }
        if (string != null && !ManagementScopeManager.getInstance().currentScopeContained(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyStore is not in the current scope.");
            }
            return;
        }
        String string2 = keyStore.getName();
        WSKeyStore wSKeyStore = new WSKeyStore(keyStore);
        if (string2 != null && wSKeyStore != null) {
            this.addKeyStoreIfNotDuplicate(string2, wSKeyStore);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadWCCMKeyStore (keystore)");
        }
    }

    public WSKeyStore[] loadOldWCCMKeyStores(String string, String string2, SecureSocketLayer secureSocketLayer) throws Exception {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadOldWCCMKeyStore");
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        String string15 = null;
        String string16 = null;
        String string17 = null;
        if (secureSocketLayer != null && string2 != null && string2.equals("SSSL")) {
            if (secureSocketLayer != null && secureSocketLayer.isSetEnableCryptoHardwareSupport() && secureSocketLayer.isEnableCryptoHardwareSupport()) {
                string7 = "JCE4758KS";
                string5 = secureSocketLayer.getKeyFileName();
                if (string5 != null) {
                    string5 = "safkeyringhw:///" + string5;
                }
                if ((string6 = secureSocketLayer.getKeyFilePassword()) == null) {
                    string6 = "password";
                }
                string13 = "true";
            } else {
                string7 = "JCERACFKS";
                string5 = secureSocketLayer.getKeyFileName();
                if (string5 != null) {
                    string5 = "safkeyring:///" + string5;
                }
                if ((string6 = secureSocketLayer.getKeyFilePassword()) == null) {
                    string6 = "password";
                }
                string13 = "false";
            }
        } else {
            if (secureSocketLayer != null && secureSocketLayer.isSetEnableCryptoHardwareSupport() && secureSocketLayer.isEnableCryptoHardwareSupport()) {
                string13 = "true";
                object2 = secureSocketLayer.getCryptoHardware();
                string17 = object2.getTokenType();
                string14 = object2.getLibraryFile();
                string15 = object2.getPassword();
            } else {
                string13 = "false";
            }
            if (secureSocketLayer == null && System.getProperty("javax.net.ssl.keyStoreProvider") != null) {
                string8 = System.getProperty("javax.net.ssl.keyStoreProvider");
            }
            if (secureSocketLayer != null && secureSocketLayer.getKeyFileName() != null && !secureSocketLayer.getKeyFileName().equals("")) {
                string5 = this.expand(secureSocketLayer.getKeyFileName());
            } else if (secureSocketLayer == null && System.getProperty("javax.net.ssl.keyStore") != null) {
                string5 = System.getProperty("javax.net.ssl.keyStore");
            }
            if (secureSocketLayer != null && secureSocketLayer.getKeyFilePassword() != null && !secureSocketLayer.getKeyFilePassword().equals("")) {
                string6 = secureSocketLayer.getKeyFilePassword();
            } else if (secureSocketLayer == null && System.getProperty("javax.net.ssl.keyStorePassword") != null && (string6 = System.getProperty("javax.net.ssl.keyStorePassword")) != null) {
                string6 = SSLConfig.decodePassword(string6);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Decoded keyStorePassword from system prop.");
                }
                System.setProperty("javax.net.ssl.keyStorePassword", string6);
            }
            if (secureSocketLayer != null && secureSocketLayer.getKeyFileFormat() != null && !secureSocketLayer.getKeyFileFormat().equals("")) {
                string7 = KeyStoreManager.getKeyStoreType(secureSocketLayer.getKeyFileFormat());
            } else if (secureSocketLayer == null && System.getProperty("javax.net.ssl.keyStoreType") != null) {
                string7 = System.getProperty("javax.net.ssl.keyStoreType");
            }
            if (secureSocketLayer == null && System.getProperty("javax.net.ssl.keyStoreProvider") != null) {
                string8 = System.getProperty("javax.net.ssl.keyStoreProvider");
            }
            if (secureSocketLayer != null && secureSocketLayer.getTrustFileName() != null && !secureSocketLayer.getTrustFileName().equals("")) {
                string9 = this.expand(secureSocketLayer.getTrustFileName());
            } else if (secureSocketLayer == null && System.getProperty("javax.net.ssl.trustStore") != null) {
                string9 = System.getProperty("javax.net.ssl.trustStore");
            }
            if (secureSocketLayer != null && secureSocketLayer.getTrustFilePassword() != null && !secureSocketLayer.getTrustFilePassword().equals("")) {
                string10 = secureSocketLayer.getTrustFilePassword();
            } else if (secureSocketLayer == null && System.getProperty("javax.net.ssl.trustStorePassword") != null && (string10 = System.getProperty("javax.net.ssl.trustStorePassword")) != null) {
                string10 = SSLConfig.decodePassword(string10);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Decoded trustStorePassword from system prop.");
                }
                System.setProperty("javax.net.ssl.trustStorePassword", string10);
            }
            if (secureSocketLayer != null && secureSocketLayer.getTrustFileFormat() != null && !secureSocketLayer.getTrustFileFormat().equals("")) {
                string11 = KeyStoreManager.getKeyStoreType(secureSocketLayer.getTrustFileFormat());
            } else if (secureSocketLayer == null && System.getProperty("javax.net.ssl.trustStoreType") != null) {
                string11 = System.getProperty("javax.net.ssl.trustStoreType");
            }
            if (secureSocketLayer == null && System.getProperty("javax.net.ssl.trustStoreProvider") != null) {
                string12 = System.getProperty("javax.net.ssl.trustStoreProvider");
            }
        }
        if (secureSocketLayer != null) {
            for (int i = 0; i < secureSocketLayer.getProperties().size(); ++i) {
                object = (Property)secureSocketLayer.getProperties().get(i);
                if (object == null) continue;
                if (object.getName().equals("com.ibm.ssl.tokenSlot")) {
                    string16 = object.getValue();
                    continue;
                }
                if (object.getName().equals("com.ibm.ssl.keyStoreClientAlias")) {
                    string3 = object.getValue();
                    continue;
                }
                if (!object.getName().equals("com.ibm.ssl.keyStoreServerAlias")) continue;
                string4 = object.getValue();
            }
        }
        object2 = null;
        object = null;
        if (string14 != null || string5 != null) {
            object2 = new WSKeyStore();
            if (string13 != null) {
                ((Properties)object2).setProperty("com.ibm.ssl.tokenEnabled", string13);
            }
            ((Properties)object2).setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
            if (string3 != null) {
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreClientAlias", string3);
            }
            if (string4 != null) {
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreServerAlias", string4);
            }
            if (secureSocketLayer != null && string2 != null && string2.equals("SSSL")) {
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
                if (string5 != null) {
                    ((Properties)object2).setProperty("com.ibm.ssl.keyStore", string5);
                }
                if (string6 != null) {
                    ((Properties)object2).setProperty("com.ibm.ssl.keyStorePassword", string6);
                }
                if (string7 != null) {
                    ((Properties)object2).setProperty("com.ibm.ssl.keyStoreType", string7);
                    if (!(string7.equals("JKS") || string7.equals("JCEKS") || string7.equals("PKCS12"))) {
                        ((Properties)object2).setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                    } else {
                        ((Properties)object2).setProperty("com.ibm.ssl.keyStoreFileBased", "true");
                    }
                }
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreReadOnly", "true");
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "false");
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "false");
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreUseForAcceleration", "false");
            } else if (string13.equals("true")) {
                if (string14 != null) {
                    ((Properties)object2).setProperty("com.ibm.ssl.tokenLibraryFile", string14);
                    ((Properties)object2).setProperty("com.ibm.ssl.keyStore", string14);
                }
                if (string15 != null) {
                    ((Properties)object2).setProperty("com.ibm.ssl.tokenPassword", string15);
                    ((Properties)object2).setProperty("com.ibm.ssl.keyStorePassword", string15);
                }
                if (string17 != null) {
                    ((Properties)object2).setProperty("com.ibm.ssl.tokenType", string17);
                    ((Properties)object2).setProperty("com.ibm.ssl.keyStoreType", string17);
                }
                if (string16 != null) {
                    ((Properties)object2).setProperty("com.ibm.ssl.tokenSlot", string16);
                    ((Properties)object2).setProperty("com.ibm.ssl.keyStoreSlot", string16);
                }
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreProvider", "IBMPKCS11Impl");
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreReadOnly", "true");
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "true");
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "false");
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreUseForAcceleration", "true");
            } else {
                if (string5 != null) {
                    ((Properties)object2).setProperty("com.ibm.ssl.keyStore", string5);
                }
                if (string6 != null) {
                    ((Properties)object2).setProperty("com.ibm.ssl.keyStorePassword", string6);
                }
                if (string7 != null) {
                    ((Properties)object2).setProperty("com.ibm.ssl.keyStoreType", string7);
                    if (!(string7.equals("JKS") || string7.equals("JCEKS") || string7.equals("PKCS12"))) {
                        ((Properties)object2).setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                    } else {
                        ((Properties)object2).setProperty("com.ibm.ssl.keyStoreFileBased", "true");
                    }
                }
                if (string7 != null && string7.equals("JCE4758KS")) {
                    ((Properties)object2).setProperty("com.ibm.ssl.keyStoreReadOnly", "true");
                } else {
                    ((Properties)object2).setProperty("com.ibm.ssl.keyStoreReadOnly", "false");
                }
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "false");
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "true");
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreUseForAcceleration", "false");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding KeyStore name: " + string + "_key");
            }
            ((Properties)object2).setProperty("com.ibm.ssl.keyStoreName", string + "_key");
            this.addKeyStoreIfNotDuplicate(string + "_key", (WSKeyStore)object2);
        }
        if (string9 != null) {
            object = new WSKeyStore();
            ((Properties)object).setProperty("com.ibm.ssl.tokenEnabled", "false");
            ((Properties)object).setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
            ((Properties)object).setProperty("com.ibm.ssl.keyStore", string9);
            if (string10 != null) {
                ((Properties)object).setProperty("com.ibm.ssl.keyStorePassword", string10);
            }
            if (string11 != null) {
                ((Properties)object).setProperty("com.ibm.ssl.keyStoreType", string11);
                if (!(string11.equals("JKS") || string11.equals("JCEKS") || string11.equals("PKCS12"))) {
                    ((Properties)object).setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                } else {
                    ((Properties)object).setProperty("com.ibm.ssl.keyStoreFileBased", "true");
                }
            }
            if (string11 != null && string11.equals("JCE4758KS")) {
                ((Properties)object).setProperty("com.ibm.ssl.keyStoreReadOnly", "true");
            } else {
                ((Properties)object).setProperty("com.ibm.ssl.keyStoreReadOnly", "false");
            }
            ((Properties)object).setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
            ((Properties)object).setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "false");
            ((Properties)object).setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "true");
            ((Properties)object).setProperty("com.ibm.ssl.keyStoreUseForAcceleration", "false");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding TrustStore name: " + string + "_trust");
            }
            ((Properties)object).setProperty("com.ibm.ssl.keyStoreName", string + "_trust");
            this.addKeyStoreIfNotDuplicate(string + "_trust", (WSKeyStore)object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Total Number of KeyStores: " + this.keyStoreMap.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadOldWCCMKeyStore");
        }
        if (object2 != null && object != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning key and trust.");
            }
            return new WSKeyStore[]{object2, object};
        }
        if (object2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Copying key to trust.");
            }
            object = (WSKeyStore)((Properties)object2).clone();
            ((Properties)object).setProperty("com.ibm.ssl.keyStoreName", string + "_trust");
            this.addKeyStoreIfNotDuplicate(string + "_trust", (WSKeyStore)object);
            return new WSKeyStore[]{object2, object};
        }
        if (object != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Copying trust to key.");
            }
            object2 = (WSKeyStore)((Properties)object).clone();
            ((Properties)object2).setProperty("com.ibm.ssl.keyStoreName", string + "_key");
            this.addKeyStoreIfNotDuplicate(string + "_key", (WSKeyStore)object2);
            return new WSKeyStore[]{object2, object};
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not returning any KeyStores from old WCCM config.");
        }
        return null;
    }

    public boolean checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot(SSLConfig sSLConfig) {
        boolean bl;
        boolean bl2;
        block63: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot");
            }
            bl2 = false;
            bl = false;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                String string10;
                Object object6;
                Object object7;
                Object object8;
                Object object9;
                Object object10;
                Serializable serializable;
                Object object11;
                String string11 = sSLConfig.getProperty("com.ibm.ssl.keyStoreName");
                WSKeyStore wSKeyStore = this.getKeyStore(string11);
                if (wSKeyStore == null) {
                    wSKeyStore = new WSKeyStore();
                    if (string11 != null) {
                        wSKeyStore.setProperty("com.ibm.ssl.keyStoreName", string11);
                    }
                    if ((string3 = sSLConfig.getProperty("com.ibm.ssl.keyStoreFileBased")) != null) {
                        wSKeyStore.setProperty("com.ibm.ssl.keyStoreFileBased", string3);
                    }
                    if ((string8 = sSLConfig.getProperty("com.ibm.ssl.keyStoreReadOnly")) != null) {
                        wSKeyStore.setProperty("com.ibm.ssl.keyStoreReadOnly", string8);
                    }
                    if ((string4 = sSLConfig.getProperty("com.ibm.ssl.keyStore")) != null) {
                        wSKeyStore.setProperty("com.ibm.ssl.keyStore", string4);
                    }
                    if ((string5 = sSLConfig.getProperty("com.ibm.ssl.keyStorePassword")) != null) {
                        wSKeyStore.setProperty("com.ibm.ssl.keyStorePassword", string5);
                    }
                    if ((string = sSLConfig.getProperty("com.ibm.ssl.tokenEnabled")) != null) {
                        wSKeyStore.setProperty("com.ibm.ssl.tokenEnabled", string);
                    }
                    if ((string6 = sSLConfig.getProperty("com.ibm.ssl.keyStoreType")) != null) {
                        wSKeyStore.setProperty("com.ibm.ssl.keyStoreType", string6);
                        if (!(string6.equals("JKS") || string6.equals("JCEKS") || string6.equals("PKCS12"))) {
                            wSKeyStore.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                            string3 = "false";
                        } else {
                            wSKeyStore.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
                            string3 = "true";
                        }
                        if (string6.equals("IBMPKCS11Impl") || string6.equals("JCE4758KS")) {
                            wSKeyStore.setProperty("com.ibm.ssl.tokenEnabled", "true");
                            string8 = "true";
                        }
                        if (string6.equals("IBMPKCS11Impl") || string6.equals("JCE4758KS") || string6.equals("JCERACFKS")) {
                            wSKeyStore.setProperty("com.ibm.ssl.keyStoreReadOnly", "true");
                            string8 = "true";
                        } else {
                            wSKeyStore.setProperty("com.ibm.ssl.keyStoreReadOnly", "false");
                            string8 = "false";
                        }
                    }
                    if ((string2 = sSLConfig.getProperty("com.ibm.ssl.tokenConfigFile")) != null) {
                        wSKeyStore.setProperty("com.ibm.ssl.tokenConfigFile", string2);
                    }
                    if ((string7 = sSLConfig.getProperty("com.ibm.ssl.keyStoreProvider")) != null) {
                        wSKeyStore.setProperty("com.ibm.ssl.keyStoreProvider", string7);
                    }
                    if ((string9 = sSLConfig.getProperty("com.ibm.ssl.keyStoreScope")) != null) {
                        wSKeyStore.setProperty("com.ibm.ssl.keyStoreScope", string9);
                    }
                    this.keyStoreMap.put(string11, wSKeyStore);
                }
                if (string3 == null) {
                    string3 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreFileBased");
                }
                if (string8 == null) {
                    string8 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreReadOnly");
                }
                if (string4 == null) {
                    string4 = wSKeyStore.getProperty("com.ibm.ssl.keyStore");
                }
                String string12 = null;
                Certificate certificate = null;
                if (string3 != null && string3.equals("true") && string8 != null && string8.equals("false") && string11 != null && string11.endsWith("DefaultKeyStore")) {
                    try {
                        object11 = new URL(string4);
                        string12 = ((URL)object11).getFile();
                        while (string12.startsWith("/")) {
                            string12 = string12.substring(1);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        string12 = string4;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "File path for OutputStream: " + string12);
                    }
                    object11 = null;
                    serializable = Boolean.FALSE;
                    if (string12 != null) {
                        object11 = new File(string12);
                        object10 = new FileExistsAction((File)object11);
                        serializable = (Boolean)AccessController.doPrivileged(object10);
                    }
                    if (object11 != null && ((Boolean)serializable).booleanValue()) {
                        bl2 = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot -> (keystore exists)");
                        }
                    } else if (object11 != null) {
                        object10 = string12;
                        if (string5 == null) {
                            string5 = wSKeyStore.getProperty("com.ibm.ssl.keyStorePassword");
                        }
                        if (string6 == null) {
                            string6 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreType");
                        }
                        if (string7 == null) {
                            string7 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreProvider");
                        }
                        if (string9 == null) {
                            string9 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreScope");
                        }
                        object9 = Boolean.TRUE;
                        object8 = Boolean.FALSE;
                        object7 = Boolean.TRUE;
                        object6 = new KeyStoreInfo(string11, (String)object10, string5, string7, string6, (Boolean)object9, null, string9, null, (Boolean)object8, (Boolean)object7, Boolean.FALSE, null, new Integer(0), Boolean.FALSE, null);
                        string10 = sSLConfig.getProperty("com.ibm.ssl.keyStoreClientAlias");
                        object5 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqAlias", "default");
                        object4 = null;
                        object4 = string10 != null ? string10 : (object5 != null ? object5 : "default");
                        object3 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqKeySize", "1024");
                        object2 = this.expand(SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqSubjectDN", "cn=${hostname},o=IBM,c=US"));
                        object = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqDays", "5475");
                        int n = new Integer((String)object3);
                        int n2 = new Integer((String)object);
                        CertReqInfo certReqInfo = new CertReqInfo((String)object4, n, (String)object2, n2, (KeyStoreInfo)object6, null);
                        try {
                            certificate = CertificateManager.getInstance().selfSignedCertificateCreate(certReqInfo);
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            FFDCFilter.processException(noClassDefFoundError, "com.ibm.ws.ssl.config.KeyStoreManager.checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot", "777", this, new Object[]{noClassDefFoundError});
                            Tr.error(tc, "ssl.self.signed.create.error.CWPKI0032E", new Object[]{noClassDefFoundError.toString()});
                            throw noClassDefFoundError;
                        }
                    }
                }
                object11 = sSLConfig.getProperty("com.ibm.ssl.trustStoreName");
                serializable = this.getKeyStore((String)object11);
                object10 = null;
                object9 = null;
                object8 = null;
                object7 = null;
                object6 = null;
                string10 = null;
                string = null;
                string2 = null;
                if (serializable == null) {
                    serializable = new WSKeyStore();
                    if (object11 != null) {
                        ((Properties)serializable).setProperty("com.ibm.ssl.keyStoreName", (String)object11);
                    }
                    if ((object10 = sSLConfig.getProperty("com.ibm.ssl.trustStoreFileBased")) != null) {
                        ((Properties)serializable).setProperty("com.ibm.ssl.keyStoreFileBased", (String)object10);
                    }
                    if ((object9 = sSLConfig.getProperty("com.ibm.ssl.trustStore")) != null) {
                        ((Properties)serializable).setProperty("com.ibm.ssl.keyStore", (String)object9);
                    }
                    if ((object8 = sSLConfig.getProperty("com.ibm.ssl.trustStorePassword")) != null) {
                        ((Properties)serializable).setProperty("com.ibm.ssl.keyStorePassword", (String)object8);
                    }
                    if (string != null) {
                        ((Properties)serializable).setProperty("com.ibm.ssl.tokenEnabled", string);
                    }
                    if ((object7 = sSLConfig.getProperty("com.ibm.ssl.trustStoreType")) != null) {
                        if (((String)object7).equals("IBMPKCS11Impl") || ((String)object7).equals("JCE4758KS")) {
                            ((Properties)serializable).setProperty("com.ibm.ssl.tokenEnabled", "true");
                        }
                        if (((String)object7).equals("JCERACFKS") || ((String)object7).equals("JCE4758KS")) {
                            ((Properties)serializable).setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                            ((Properties)serializable).setProperty("com.ibm.ssl.keyStoreReadOnly", "true");
                            string3 = "false";
                            string8 = "true";
                        }
                        ((Properties)serializable).setProperty("com.ibm.ssl.keyStoreType", (String)object7);
                    }
                    if ((string2 = sSLConfig.getProperty("com.ibm.ssl.tokenConfigFile")) != null) {
                        ((Properties)serializable).setProperty("com.ibm.ssl.tokenConfigFile", string2);
                    }
                    if ((object6 = sSLConfig.getProperty("com.ibm.ssl.trustStoreProvider")) != null) {
                        ((Properties)serializable).setProperty("com.ibm.ssl.keyStoreProvider", (String)object6);
                    }
                    if ((string10 = sSLConfig.getProperty("com.ibm.ssl.trustStoreReadOnly")) != null) {
                        ((Properties)serializable).setProperty("com.ibm.ssl.keyStoreReadOnly", string10);
                    }
                    this.keyStoreMap.put(object11, serializable);
                }
                if (object10 == null) {
                    object10 = ((Properties)serializable).getProperty("com.ibm.ssl.keyStoreFileBased");
                }
                if (object9 == null) {
                    object9 = ((Properties)serializable).getProperty("com.ibm.ssl.keyStore");
                }
                object5 = null;
                if (bl2 || object10 == null || !((String)object10).equals("true") || object11 == null || !((String)object11).endsWith("DefaultTrustStore")) break block63;
                try {
                    object4 = new URL((String)object9);
                    object5 = ((URL)object4).getFile();
                    while (((String)object5).startsWith("/")) {
                        object5 = ((String)object5).substring(1);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    object5 = object9;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "File path for OutputStream: " + (String)object5);
                }
                if (((Boolean)(object2 = (Boolean)AccessController.doPrivileged(object3 = new FileExistsAction((File)(object4 = new File((String)object5)))))).booleanValue()) {
                    bl = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot -> (truststore exists)");
                    }
                } else {
                    object = ((WSKeyStore)serializable).getKeyStore(false, false);
                    String string13 = "default_signer";
                    if (object != null && certificate != null) {
                        ((KeyStore)object).setCertificateEntry(string13, certificate);
                        ((WSKeyStore)serializable).store();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Signer set in new truststore file.");
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.ssl.config.KeyStoreManager.checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot", "916", this, new Object[]{exception});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception creating client keystore and/or truststore.", new Object[]{exception});
                }
                Tr.error(tc, "ssl.client.keystore.create.error.CWPKI0031E", new Object[]{exception.getMessage()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot -> " + new Boolean(!bl2 && !bl).toString());
        }
        return !bl2 && !bl;
    }

    public Certificate checkIfKeyStoreExistsAndCreateIfNot(WSKeyStore wSKeyStore, SSLConfig sSLConfig) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfKeyStoreExistsAndCreateIfNot");
        }
        String string = wSKeyStore.getProperty("com.ibm.ssl.keyStoreFileBased");
        String string2 = wSKeyStore.getProperty("com.ibm.ssl.keyStore");
        String string3 = System.getProperty("was.repository.root");
        String string4 = null;
        string4 = string3 != null ? string3 : KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
        String string5 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Key store location: " + string2);
        }
        if (string5 != null && string5.endsWith("DefaultKeyStore") && string != null && string.equals("true")) {
            File file = new File(string2);
            FileExistsAction fileExistsAction = new FileExistsAction(file);
            Boolean bl = (Boolean)AccessController.doPrivileged(fileExistsAction);
            if (bl.booleanValue()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot -> (exists)");
                }
                return null;
            }
            try {
                String string6 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreName");
                String string7 = wSKeyStore.getProperty("com.ibm.ssl.keyStorePassword");
                String string8 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreType");
                String string9 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreProvider");
                String string10 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreScope");
                String string11 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreCreateCMSStash");
                Boolean bl2 = Boolean.TRUE;
                if (string11 != null) {
                    bl2 = new Boolean(string11);
                }
                Boolean bl3 = Boolean.TRUE;
                Boolean bl4 = Boolean.FALSE;
                Boolean bl5 = Boolean.TRUE;
                KeyStoreInfo keyStoreInfo = new KeyStoreInfo(string6, string2, string7, string9, string8, bl3, null, string10, null, bl4, bl5, bl2, null, new Integer(0), Boolean.FALSE, null);
                String string12 = sSLConfig.getProperty("com.ibm.ssl.keyStoreClientAlias");
                String string13 = sSLConfig.getProperty("com.ibm.ssl.keyStoreServerAlias");
                String string14 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqAlias", "default");
                String string15 = null;
                string15 = string13 != null ? string13 : (string12 != null ? string12 : (string14 != null ? string14 : "default"));
                String string16 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqKeySize", "1024");
                String string17 = this.expand(SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqSubjectDN", "cn=${hostname},o=IBM,c=US"));
                String string18 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqDays", "5475");
                int n = new Integer(string16);
                int n2 = new Integer(string18);
                CertReqInfo certReqInfo = new CertReqInfo(string15, n, string17, n2, keyStoreInfo, null);
                Certificate certificate = CertificateManager.getInstance().selfSignedCertificateCreate(certReqInfo);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot");
                }
                return certificate;
            }
            catch (Exception exception) {
                if (exception instanceof SSLException) {
                    throw (SSLException)exception;
                }
                throw new SSLException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot (not filebased or in config root)");
        }
        return null;
    }

    public void checkIfTrustStoreExistsAndCreateIfNot(WSKeyStore wSKeyStore, SSLConfig sSLConfig, Certificate certificate) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfTrustStoreExistsAndCreateIfNot");
        }
        String string = wSKeyStore.getProperty("com.ibm.ssl.keyStoreFileBased");
        String string2 = wSKeyStore.getProperty("com.ibm.ssl.keyStore");
        String string3 = System.getProperty("was.repository.root");
        String string4 = null;
        string4 = string3 != null ? string3 : KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
        String string5 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreName");
        if (string5 != null && string5.endsWith("DefaultTrustStore") && string != null && string.equals("true")) {
            File file = new File(string2);
            FileExistsAction fileExistsAction = new FileExistsAction(file);
            Boolean bl = (Boolean)AccessController.doPrivileged(fileExistsAction);
            if (bl.booleanValue()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfTrustStoreExistsAndCreateIfNot -> (exists)");
                }
                return;
            }
            try {
                String string6 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreName");
                String string7 = wSKeyStore.getProperty("com.ibm.ssl.keyStorePassword");
                String string8 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreType");
                String string9 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreProvider");
                String string10 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreScope");
                KeyStore keyStore = this.getKeyStore(string6, string8, string9, string2, string7, string10, true, sSLConfig);
                String string11 = "default_signer";
                if (keyStore != null && certificate != null) {
                    keyStore.setCertificateEntry(string11, certificate);
                    FileOutputStream fileOutputStream = new FileOutputStream(string2);
                    keyStore.store(fileOutputStream, string7.toCharArray());
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkIfTrustStoreExistsAndCreateIfNot (signer set)");
                    }
                    return;
                }
            }
            catch (Exception exception) {
                if (exception instanceof SSLException) {
                    throw (SSLException)exception;
                }
                throw new SSLException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfTrustStoreExistsAndCreateIfNot (not filebased or in config root)");
        }
    }

    public void addKeyStoreIfNotDuplicate(String string, WSKeyStore wSKeyStore) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addKeyStoreIfNotDuplicate", string);
        }
        if (this.keyStoreMap.size() > 0) {
            object = this.keyStoreMap.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                WSKeyStore wSKeyStore2 = (WSKeyStore)entry.getValue();
                if (!wSKeyStore2.equals(wSKeyStore)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found a matching KeyStore, adding reference to existing.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding keystore lookup as: " + string);
                }
                this.keyStoreMap.put(string, wSKeyStore2);
                String string2 = wSKeyStore2.getProperty("com.ibm.ssl.keyStoreUseForAcceleration");
                if (string2 != null && string2.equals("true")) {
                    this.acceleratorMap.put(string, wSKeyStore2);
                }
                return;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding KeyStore to the Map: " + string + ", values: " + wSKeyStore);
        }
        if (SSLConfigManager.getInstance().validationEnabled()) {
            wSKeyStore.provideExpirationWarnings(new Integer("60"), string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding keystore lookup as: " + string);
        }
        this.keyStoreMap.put(string, wSKeyStore);
        object = wSKeyStore.getProperty("com.ibm.ssl.keyStoreUseForAcceleration");
        if (object != null && ((String)object).equals("true")) {
            this.acceleratorMap.put(string, wSKeyStore);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addKeyStoreIfNotDuplicate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exchangeSigners(String string, com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore, String string2, com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exchangeSigners", new Object[]{keyStore.getLocation(), keyStore2.getLocation()});
        }
        FileOutputStream fileOutputStream = null;
        try {
            String string3 = keyStore.getName();
            String string4 = this.fixupConfigRootForSignerExchange(string, keyStore.getLocation());
            String string5 = keyStore.getPassword();
            String string6 = keyStore.getType();
            String string7 = keyStore.getProvider();
            String string8 = keyStore.getManagementScope().getScopeName();
            KeyStore keyStore3 = this.getKeyStore(string3, string6, string7, string4, string5, string8, true, null);
            String string9 = keyStore2.getName();
            String string10 = this.fixupConfigRootForSignerExchange(string2, keyStore2.getLocation());
            String string11 = keyStore2.getPassword();
            String string12 = keyStore2.getType();
            String string13 = keyStore2.getProvider();
            String string14 = keyStore2.getManagementScope().getScopeName();
            boolean bl = false;
            KeyStore keyStore4 = this.getKeyStore(string9, string12, string13, string10, string11, string14, true, null);
            if (keyStore3 != null && keyStore4 != null) {
                Object object;
                Object object2;
                Enumeration<String> enumeration = keyStore3.aliases();
                while (enumeration.hasMoreElements()) {
                    boolean bl2;
                    object2 = enumeration.nextElement();
                    if (!keyStore3.isKeyEntry((String)object2)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key alias: " + (String)object2);
                    }
                    object = (X509Certificate)keyStore3.getCertificate((String)object2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Certificate DN: " + ((X509Certificate)object).getIssuerDN().getName());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Certificate S/N: " + ((X509Certificate)object).getSerialNumber());
                    }
                    if (!(bl2 = this.checkIfSignerAlreadyExistsInTrustStore((X509Certificate)object, keyStore4)) && !keyStore4.containsAlias((String)object2)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding alias \"" + (String)object2 + "\" from keystore \"" + string4 + "\" to keystore \"" + string10 + "\".");
                        }
                        keyStore4.setCertificateEntry((String)object2, (Certificate)object);
                        bl = true;
                        continue;
                    }
                    if (bl2) continue;
                    int n = 1;
                    String string15 = null;
                    while (keyStore4.containsAlias(string15 = (String)object2 + "_" + n++)) {
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding alias \"" + string15 + "\" from keystore \"" + string4 + "\" to keystore \"" + string10 + "\".");
                    }
                    if (keyStore4.containsAlias(string15)) continue;
                    keyStore4.setCertificateEntry(string15, (Certificate)object);
                    bl = true;
                }
                if (bl) {
                    if (string12 != null && (string12.equals("CMSKS") || string12.equals("IBMi5OSKeyStore"))) {
                        object2 = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                        object = ((Class)object2).getMethod("storeCMSKeyStore", KeyStore.class, String.class, String.class, String.class, String.class);
                        ((Method)object).invoke(((Class)object2).newInstance(), keyStore4, string10, string11, string12, "true");
                    } else {
                        fileOutputStream = new FileOutputStream(string10);
                        keyStore4.store(fileOutputStream, string11.toCharArray());
                    }
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ssl.config.KeyStoreManager.exchangeSigners", "1226", this, new Object[]{exception});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception exchanging signers.", new Object[]{exception});
            }
            Tr.error(tc, "ssl.signer.exchange.error.CWPKI0030E", new Object[]{exception.getMessage()});
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exchangeSigners");
        }
    }

    public boolean checkIfSignerAlreadyExistsInTrustStore(X509Certificate x509Certificate, KeyStore keyStore) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkIfSignerAlreadyExistsInTrustStore");
            }
            try {
                String string = this.generateDigest("MD5", x509Certificate);
                if (string == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkIfSignerAlreadyExistsInTrustStore -> false (could not generate digest)");
                    }
                    return false;
                }
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    X509Certificate x509Certificate2;
                    String string2;
                    String string3 = enumeration.nextElement();
                    if (!keyStore.containsAlias(string3) || !string.equals(string2 = this.generateDigest("MD5", x509Certificate2 = (X509Certificate)keyStore.getCertificate(string3)))) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "checkIfSignerAlreadyExistsInTrustStore -> true (digest matches)");
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.ssl.config.KeyStoreManager.checkIfSignerAlreadyExistsInTrustStore", "1287", this, new Object[]{exception});
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception checking if signer already exists.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfSignerAlreadyExistsInTrustStore -> false (no digest matches)");
        }
        return false;
    }

    private String fixupConfigRootForSignerExchange(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupConfigRoot", new Object[]{string, string2});
        }
        String string3 = string2;
        int n = string2.indexOf("/cells/");
        if (n != -1) {
            String string4 = string2.substring(n);
            string3 = string + string4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupConfigRoot -> " + string3);
        }
        return string3;
    }

    public WSKeyStore getKeyStore(String string) {
        WSKeyStore wSKeyStore = (WSKeyStore)this.keyStoreMap.get(string);
        if (wSKeyStore != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning a keyStore for name: " + string);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find a keyStore for name: " + string);
            }
        }
        return wSKeyStore;
    }

    public String[] getKeyStoreAliases() {
        return this.keyStoreMap.keySet().toArray(new String[0]);
    }

    public String[] getAcceleratorAliases() {
        return this.acceleratorMap.keySet().toArray(new String[0]);
    }

    public static String getKeyStoreType(KeyFileFormatKind keyFileFormatKind) {
        String string = null;
        if (keyFileFormatKind != null) {
            switch (keyFileFormatKind.getValue()) {
                case 2: {
                    string = "JCEKS";
                    break;
                }
                default: {
                    string = keyFileFormatKind.getName();
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getKeyStore(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, SSLConfig sSLConfig) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStore", new Object[]{string, string2, string3, string4, string6, new Boolean(bl), SSLConfigManager.mask(string5)});
        }
        if (string != null && !bl && (object = (WSKeyStore)this.keyStoreMap.get(string)) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getKeyStore (from WSKeyStore)");
            }
            return ((WSKeyStore)object).getKeyStore(false, false);
        }
        object = null;
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        boolean bl2 = true;
        int n = 0;
        boolean bl3 = true;
        ArrayList<Object> arrayList = new ArrayList();
        while (bl2) {
            Object object2;
            bl3 = !string2.equals("JCERACFKS");
            if (!string2.equals("CMSKS") && !string2.equals("IBMi5OSKeyStore")) {
                object = KeyStore.getInstance(string2);
            }
            char[] cArray = null;
            if (string5 != null) {
                cArray = string5.toCharArray();
            }
            try {
                Method method;
                Class<?> clazz;
                Serializable serializable;
                if (null == string4) {
                    if (string2 != null && (string2.equals("CMSKS") || string2.equals("IBMi5OSKeyStore"))) {
                        serializable = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                        object2 = ((Class)serializable).getMethod("loadCMSKeyStore", class$java$io$File == null ? KeyStoreManager.class$("java.io.File") : class$java$io$File, class$java$lang$String == null ? KeyStoreManager.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? KeyStoreManager.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? KeyStoreManager.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? KeyStoreManager.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? KeyStoreManager.class$("java.lang.String") : class$java$lang$String);
                        object = (KeyStore)((Method)object2).invoke(((Class)serializable).newInstance(), null, string4, string5, string2, string3, "true");
                        bl2 = false;
                        continue;
                    }
                    ((KeyStore)object).load(null, cArray);
                    bl2 = false;
                    continue;
                }
                serializable = new File(string4);
                object2 = new FileExistsAction((File)serializable);
                Boolean bl4 = (Boolean)AccessController.doPrivileged(object2);
                if (!bl4.booleanValue() && bl3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getKeyStore created new KeyStore: " + string4);
                    }
                    if (string2 != null && (string2.equals("CMSKS") || string2.equals("IBMi5OSKeyStore"))) {
                        clazz = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                        method = clazz.getMethod("loadCMSKeyStore", class$java$io$File == null ? KeyStoreManager.class$("java.io.File") : class$java$io$File, class$java$lang$String == null ? KeyStoreManager.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? KeyStoreManager.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? KeyStoreManager.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? KeyStoreManager.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? KeyStoreManager.class$("java.lang.String") : class$java$lang$String);
                        object = (KeyStore)method.invoke(clazz.newInstance(), null, string4, string5, string2, string3, "true");
                        bl2 = false;
                        continue;
                    }
                    ((KeyStore)object).load(null, cArray);
                    bl2 = false;
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getKeyStore created a new inputStream: " + string4);
                }
                if (string2 != null && (string2.equals("CMSKS") || string2.equals("IBMi5OSKeyStore"))) {
                    clazz = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                    method = clazz.getMethod("loadCMSKeyStore", class$java$io$File == null ? KeyStoreManager.class$("java.io.File") : class$java$io$File, class$java$lang$String == null ? KeyStoreManager.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? KeyStoreManager.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? KeyStoreManager.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? KeyStoreManager.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? KeyStoreManager.class$("java.lang.String") : class$java$lang$String);
                    object = (KeyStore)method.invoke(clazz.newInstance(), serializable, string4, string5, string2, string3, "true");
                    bl2 = false;
                    continue;
                }
                inputStream = this.getInputStream(string4, bl);
                ((KeyStore)object).load(inputStream, cArray);
                bl2 = false;
            }
            catch (IOException iOException) {
                if (iOException.getMessage().equalsIgnoreCase("Invalid keystore format") || iOException.getMessage().indexOf("DerInputStream.getLength()") != -1) {
                    if (n == 0) {
                        object2 = "unknown";
                        if (sSLConfig != null) {
                            object2 = sSLConfig.getProperty("com.ibm.ssl.alias");
                        }
                        Tr.warning(tc, "ssl.keystore.type.invalid.CWPKI0018W", (Object)new Object[]{string2, object2});
                        arrayList = new ArrayList<String>(Security.getAlgorithms("KeyStore"));
                    }
                    if (n >= arrayList.size()) {
                        throw iOException;
                    }
                    if (!(string2 = (String)arrayList.get(n++)).equals("PKCS11") && !string2.equals("IBMCMSKS")) continue;
                    string2 = (String)arrayList.get(n++);
                    continue;
                }
                throw iOException;
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStore (from SSLConfig properties)");
        }
        return object;
    }

    public InputStream getInputStream(String string, boolean bl) throws MalformedURLException, IOException {
        try {
            GetKeyStoreInputStreamAction getKeyStoreInputStreamAction = new GetKeyStoreInputStreamAction(string, bl);
            return (InputStream)AccessController.doPrivileged(getKeyStoreInputStreamAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            FFDCFilter.processException(privilegedActionException, "com.ibm.ws.ssl.provider.AbstractJSSEProvider", "1520", this, new Object[]{exception});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", new Object[]{exception});
            }
            if (exception instanceof MalformedURLException) {
                throw (MalformedURLException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception.getMessage());
        }
    }

    public OutputStream getOutputStream(String string) throws MalformedURLException, IOException {
        try {
            GetKeyStoreOutputStreamAction getKeyStoreOutputStreamAction = new GetKeyStoreOutputStreamAction(string);
            return (OutputStream)AccessController.doPrivileged(getKeyStoreOutputStreamAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            FFDCFilter.processException(privilegedActionException, "com.ibm.ws.ssl.config.KeyStoreManager.getOutputStream", "1594", this, new Object[]{exception});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", new Object[]{exception});
            }
            if (exception instanceof MalformedURLException) {
                throw (MalformedURLException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception.getMessage());
        }
    }

    public String generateDigest(String string, X509Certificate x509Certificate) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "generateDigest", new Object[]{string});
            }
            try {
                if (x509Certificate != null) {
                    DerOutputStream derOutputStream = new DerOutputStream();
                    derOutputStream.write(x509Certificate.getEncoded());
                    MessageDigest messageDigest = MessageDigest.getInstance(string);
                    messageDigest.update(derOutputStream.toByteArray());
                    byte[] byArray = messageDigest.digest();
                    String string2 = new HexDumpEncoder().encode(byArray);
                    string2 = string2.replaceAll("\\s", ":");
                    String[] stringArray = string2.split(":");
                    if (stringArray != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i] == null || stringArray[i].length() != 2) continue;
                            stringBuffer.append(stringArray[i]);
                            stringBuffer.append(":");
                        }
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                        return stringBuffer.toString().toUpperCase();
                    }
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "generateDigest", new Object[]{noClassDefFoundError});
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.KeyStoreManager.generateDigest", "1660", this);
                if (!tc.isEntryEnabled()) break block8;
                Tr.exit(tc, "generateDigest", new Object[]{exception});
            }
        }
        return null;
    }

    protected void clearKeyStoreMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearKeyStoreMap");
        }
        this.keyStoreMap.clear();
        this.acceleratorMap.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearKeyStoreMap");
        }
    }

    public String expand(String string) {
        String string2;
        block29: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "expand");
            }
            String string3 = string;
            string2 = null;
            String string4 = null;
            string2 = (String)expandMap.get(string3);
            if (string2 != null && !string2.equals("")) {
                string2 = string2.replace('\\', '/');
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "expand -> " + string2);
                }
                return string2;
            }
            try {
                String string5;
                String string6;
                int n;
                Object object;
                if (SSLConfigManager.getInstance().isServerProcess()) {
                    if (string.indexOf("${CONFIG_ROOT}") != -1) {
                        string4 = System.getProperty("was.repository.root");
                        if (string4 != null) {
                            string4 = string4.replace('\\', '/');
                            string2 = string;
                            string2 = string2.replaceAll("\\$\\{CONFIG_ROOT\\}", string4);
                        }
                        if (string4 == null && (string4 = System.getProperty("user.install.root")) != null) {
                            string4 = string4 + "/config";
                            string4 = string4.replace('\\', '/');
                            string2 = string;
                            string2 = string2.replaceAll("\\$\\{CONFIG_ROOT\\}", string4);
                        }
                    } else if (string.indexOf("${WORKSPACE_ROOT}") != -1) {
                        string4 = (System.getProperty("websphere.workspace.root") != null ? System.getProperty("websphere.workspace.root") : System.getProperty("user.install.root")) + File.separator + "wstemp";
                        if (string4 != null) {
                            string4 = string4.replace('\\', '/');
                            string2 = string;
                            string2 = string2.replaceAll("\\$\\{WORKSPACE_ROOT\\}", string4);
                        }
                    } else {
                        Class<?> clazz = Class.forName("com.ibm.ws.ssl.core.SSLComponentImpl");
                        object = clazz.getMethod("expand", String.class);
                        string2 = (String)((Method)object).invoke(null, string3);
                    }
                    string3 = string2;
                }
                if ((n = string3.indexOf("${user.root}")) != -1) {
                    object = string3.substring(0, n);
                    string6 = string3.substring(n + "${user.root}".length());
                    string5 = SSLConfigManager.getInstance().getGlobalProperty("user.root");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "User install root: " + string5);
                    }
                    if (string5 != null) {
                        string2 = object != null && !((String)object).equals("") ? (String)object + string5 + string6 : string5 + string6;
                        string3 = string2;
                    }
                }
                if ((n = string3.indexOf("${USER_INSTALL_ROOT}")) != -1) {
                    object = string3.substring(0, n);
                    string6 = string3.substring(n + "${USER_INSTALL_ROOT}".length());
                    string5 = SSLConfigManager.getInstance().getGlobalProperty("user.root");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "User install root: " + string5);
                    }
                    if (string5 != null) {
                        string2 = object != null && !((String)object).equals("") ? (String)object + string5 + string6 : string5 + string6;
                        string3 = string2;
                    }
                }
                if ((n = string3.indexOf("${CONFIG_ROOT}")) != -1) {
                    object = string3.substring(0, n);
                    string6 = string3.substring(n + "${CONFIG_ROOT}".length());
                    string5 = SSLConfigManager.getInstance().getGlobalProperty("was.repository.root");
                    if (string5 == null && (string5 = System.getProperty("user.install.root")) != null) {
                        string5 = string5 + "/config";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "User install root: " + string5);
                    }
                    if (string5 != null) {
                        string2 = object != null && !((String)object).equals("") ? (String)object + string5 + string6 : string5 + string6;
                        string3 = string2;
                    }
                }
                if ((n = string3.indexOf("${WORKSPACE_ROOT}")) != -1) {
                    object = string3.substring(0, n);
                    string6 = string3.substring(n + "${WORKSPACE_ROOT}".length());
                    string5 = (SSLConfigManager.getInstance().getGlobalProperty("websphere.workspace.root") != null ? SSLConfigManager.getInstance().getGlobalProperty("websphere.workspace.root") : SSLConfigManager.getInstance().getGlobalProperty("user.root")) + File.separator + "wstemp";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "User install root: " + string5);
                    }
                    if (string5 != null) {
                        string2 = object != null && !((String)object).equals("") ? (String)object + string5 + string6 : string5 + string6;
                        string3 = string2;
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.KeyStoreManager.expand", "1911", this);
                if (!tc.isDebugEnabled()) break block29;
                Tr.debug(tc, "Expand exception: ", new Object[]{exception});
            }
        }
        if (string2 != null) {
            string2 = string2.replace('\\', '/');
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "expand -> " + string2);
            }
            expandMap.put(string, string2);
            return string2;
        }
        string = string.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expand -> (not expanded)");
        }
        return string;
    }

    public static String getHostName() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getHostName");
            }
            try {
                if (host == null && (host = InetAddress.getLocalHost().getCanonicalHostName()) != null) {
                    expandMap.put("cn=${hostname},o=IBM,c=US", "cn=" + host + ",o=IBM,c=US");
                    expandMap.put("${hostname}", host);
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception getting canonical hostname.", new Object[]{unknownHostException});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHostName -> " + host);
        }
        return host;
    }

    public Boolean createPluginKeyStore(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPluginKeyStore", new Object[]{string, string2});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPluginKeyStore");
        }
        return Boolean.TRUE;
    }

    public static String expandHostNameVariable(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandHostNameVariable", new Object[]{string, string2});
        }
        String string3 = string;
        int n = string.indexOf("${hostname}");
        if (n != -1) {
            String string4 = string.substring(0, n);
            String string5 = string.substring(n + "${hostname}".length());
            if (string4 != null && !string4.equals("") && string5 != null && !string5.equals("")) {
                string3 = string4 + string2 + string5;
            } else if (string4 != null && !string4.equals("")) {
                string3 = string4 + string2;
            } else if (string5 != null && !string5.equals("")) {
                string3 = string2 + string5;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandHostNameVariable -> " + string3);
        }
        return string3;
    }

    private static String fixupLocationWithRepositoryRoot(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupLocationWithRepositoryRoot", new Object[]{string, string2});
        }
        int n = string2.indexOf("/cells/");
        String string3 = string2;
        if (n != -1) {
            String string4 = string2.substring(n);
            string3 = string + string4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupLocationWithRepositoryRoot -> " + string3);
        }
        return string3;
    }

    public boolean isHWKeyStore(String string) {
        String string2 = "false";
        WSKeyStore wSKeyStore = (WSKeyStore)this.keyStoreMap.get(string);
        if (wSKeyStore != null) {
            string2 = wSKeyStore.getProperty("com.ibm.ssl.tokenEnabled");
        }
        return "true".equalsIgnoreCase(string2);
    }

    public Provider getHWCryptoProviderInstance(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHWCryptoProviderInstance");
        }
        WSPKCSInKeyStore wSPKCSInKeyStore = null;
        Provider provider = null;
        WSKeyStore wSKeyStore = (WSKeyStore)this.keyStoreMap.get(string);
        boolean bl = false;
        if (wSKeyStore != null) {
            String string2 = wSKeyStore.getProperty("com.ibm.ssl.keyStore");
            String string3 = wSKeyStore.getProperty("com.ibm.ssl.keyStorePassword");
            String string4 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreType");
            String string5 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreProvider");
            String string6 = wSKeyStore.getProperty("com.ibm.ssl.keyStoreUseForAcceleration");
            try {
                if (string6 != null && string6.equals("true")) {
                    bl = true;
                }
                wSPKCSInKeyStore = pkcsStoreList.insert(string4, string2, string3, true, string5, bl);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot get the HW crypto initialization status" + new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.KeyStoreManager.getHWCryptoProviderInstance", "2060", this);
                Tr.error(tc, "Cannot get the HW crypto initialization status", new Object[]{exception.getMessage()});
            }
            if (wSPKCSInKeyStore != null) {
                try {
                    provider = wSPKCSInKeyStore.getHWCryptoProviderInstance(string2);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cannot get the HW crypto provider instance" + new Object[]{exception});
                    }
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.KeyStoreManager.getHWCryptoProviderInstance", "2072", this);
                    Tr.error(tc, "Cannot get the HW crypto provider instance", new Object[]{exception.getMessage()});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHWCryptoProviderInstance");
        }
        return provider;
    }

    public void returnHWCryptoProviderInstance(String string, Provider provider) {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "returnHWCryptoProviderInstance");
            }
            WSPKCSInKeyStore wSPKCSInKeyStore = null;
            WSKeyStore wSKeyStore = (WSKeyStore)this.keyStoreMap.get(string);
            if (wSKeyStore != null) {
                block8: {
                    String string2 = wSKeyStore.getProperty("com.ibm.ssl.keyStore");
                    try {
                        wSPKCSInKeyStore = pkcsStoreList.getListElement(string2);
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block8;
                        Tr.debug(tc, "Cannot get the HW crypto keystore list element" + new Object[]{string2, exception});
                    }
                }
                if (wSPKCSInKeyStore != null) {
                    try {
                        wSPKCSInKeyStore.returnHWCryptoProviderInstance(provider);
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug(tc, "Cannot return provider instance" + new Object[]{exception});
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returnHWCryptoProviderInstance");
        }
    }

    static {
        pkcsStoreList = new WSPKCSInKeyStoreList();
    }

    class FileExistsAction
    implements PrivilegedAction {
        private File file = null;

        public FileExistsAction(File file) {
            this.file = file;
        }

        public Object run() {
            try {
                return new Boolean(this.file.exists());
            }
            catch (Exception exception) {
                return Boolean.FALSE;
            }
        }
    }

    class GetKeyStoreOutputStreamAction
    implements PrivilegedExceptionAction {
        private String file = null;

        public GetKeyStoreOutputStreamAction(String string) {
            this.file = string;
        }

        public Object run() throws MalformedURLException, IOException {
            Serializable serializable;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "GetKeyStoreOutputStreamAction.run", new Object[]{this.file});
            }
            FileOutputStream fileOutputStream = null;
            try {
                serializable = new URL(this.file);
                this.file = ((URL)serializable).getFile();
                while (this.file.startsWith("/")) {
                    this.file = this.file.substring(1);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "File path for OutputStream: " + this.file);
            }
            if (((File)(serializable = new File(this.file))).exists() && !((File)serializable).canWrite()) {
                throw new IOException("Cannot write to KeyStore file: " + this.file);
            }
            fileOutputStream = new FileOutputStream((File)serializable);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "GetKeyStoreOutputStreamAction.run");
            }
            return fileOutputStream;
        }
    }

    class GetKeyStoreInputStreamAction
    implements PrivilegedExceptionAction {
        private String file = null;
        private boolean createStream = false;

        public GetKeyStoreInputStreamAction(String string, boolean bl) {
            this.file = string;
            this.createStream = bl;
        }

        public Object run() throws MalformedURLException, IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "GetKeyStoreInputStreamAction.run");
            }
            InputStream inputStream = null;
            URL uRL = null;
            File file = new File(this.file);
            if (this.createStream && !file.exists()) {
                file.createNewFile();
                uRL = file.toURL();
            } else {
                if (file.exists() && file.length() == 0L) {
                    throw new IOException("Keystore file exists, but is empty: " + this.file);
                }
                uRL = !file.exists() ? new URL(this.file) : file.toURL();
            }
            inputStream = uRL.openStream();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "GetKeyStoreInputStreamAction.run");
            }
            return inputStream;
        }
    }
}

