/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.security.SSLConfigGroup;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.ssl.config.CurrentProcessData;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;

public class ManagementScopeManager {
    private static final TraceComponent tc = Tr.register(ManagementScopeManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static ManagementScopeManager thisClass = null;
    private static ManagementScopeManager clientClass = null;
    private CurrentProcessData cpd = null;
    private HashMap inboundEndPointAliasMap = new HashMap();
    private HashMap outboundEndPointAliasMap = new HashMap();
    private String inboundProcessAlias = null;
    private String outboundProcessAlias = null;
    private String inboundNodeAlias = null;
    private String outboundNodeAlias = null;
    private HashMap inboundNodeGroupAliasMap = new HashMap();
    private HashMap outboundNodeGroupAliasMap = new HashMap();
    private String inboundClusterAlias = null;
    private String outboundClusterAlias = null;
    private String inboundCellAlias = null;
    private String outboundCellAlias = null;
    private String inboundEffectiveProcessAlias = null;
    private String inboundEffectiveProcessScope = null;
    private String outboundEffectiveProcessAlias = null;
    private String outboundEffectiveProcessScope = null;

    private ManagementScopeManager(CurrentProcessData currentProcessData) {
        this.cpd = currentProcessData;
    }

    public static synchronized ManagementScopeManager getInstance() {
        if (!SSLConfigManager.getInstance().isServerProcess()) {
            if (clientClass == null) {
                CurrentProcessData currentProcessData = new CurrentProcessData("client", "client", "client", "client", new String[]{"client"}, "client", "client", "client", new String[]{"client"}, new String[]{"client"}, "client", "client", "client", "client");
                clientClass = new ManagementScopeManager(currentProcessData);
            }
            return clientClass;
        }
        if (thisClass == null) {
            throw new IllegalStateException("ManagementScopeManager not yet initialized");
        }
        return thisClass;
    }

    public static synchronized ManagementScopeManager getInstance(CurrentProcessData currentProcessData) {
        if (thisClass == null) {
            thisClass = new ManagementScopeManager(currentProcessData);
        }
        return thisClass;
    }

    public String getProcessType() {
        return this.cpd.getProcessType();
    }

    public String getProcessName() {
        return this.cpd.getProcessName();
    }

    public String getServerType() {
        return this.cpd.getServerType();
    }

    public String getNodeName() {
        return this.cpd.getNodeName();
    }

    public String getCellName() {
        return this.cpd.getCellName();
    }

    public String getJvmType() {
        return this.cpd.getJvmType();
    }

    public String getClusterName() {
        return this.cpd.getClusterName();
    }

    public String[] getFullScopeNames() {
        return this.cpd.getCurrentScopeNames();
    }

    public String[] getNodeGroupScopeNames() {
        return this.cpd.getCurrentNodeGroupScopeNames();
    }

    public String getClusterScopeName() {
        return this.cpd.getCurrentClusterScopeName();
    }

    public String getProcessScopeName() {
        return this.cpd.getCurrentProcessScopeName();
    }

    public String getNodeScopeName() {
        return this.cpd.getCurrentNodeScopeName();
    }

    public String getCellScopeName() {
        return this.cpd.getCurrentCellScopeName();
    }

    public boolean currentScopeContained(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "currentScopeContained", new Object[]{string});
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "currentScopeContained: cannot compare scopes if one or both are null.");
            }
            return false;
        }
        String[] stringArray = this.getFullScopeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.equals("client")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "currentScopeContained: current scope is client, returning true.");
                }
                return true;
            }
            if (string2.equals(string)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "currentScopeContained: scopes are equal, returning true.");
                }
                return true;
            }
            if (string2.startsWith(string)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "currentScopeContained: scope is exact substring of currentScope, returning true.");
                }
                return true;
            }
            ManagementScopeData managementScopeData = new ManagementScopeData(string);
            if (managementScopeData == null) continue;
            if (managementScopeData.getScopeType().equals("endpoint") || managementScopeData.getScopeType().equals("server")) {
                String string3 = managementScopeData.formProcessScope();
                String string4 = this.getProcessScopeName();
                if (string3 != null && string4 != null && string3.equals(string4)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "currentScopeContained: server scopes match.");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "!currentScopeContained: server scopes do not match.");
                }
                return false;
            }
            if (managementScopeData.getScopeType().equals("cluster")) {
                String string5 = managementScopeData.formClusterScope();
                String string6 = this.getClusterScopeName();
                if (string5 != null && string6 != null && string5.equals(string6)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "currentScopeContained: cluster scopes match.");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "!currentScopeContained: cluster scopes do not match.");
                }
                return false;
            }
            if (managementScopeData.getScopeType().equals("node")) {
                String string7 = managementScopeData.formNodeScope();
                String string8 = this.getNodeScopeName();
                if (string7 != null && string8 != null && string7.equals(string8)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "currentScopeContained: node scopes match.");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "!currentScopeContained: node scopes do not match.");
                }
                return false;
            }
            if (managementScopeData.getScopeType().equals("nodegroup")) {
                String string9 = managementScopeData.formNodeGroupScope();
                String[] stringArray2 = this.getNodeGroupScopeNames();
                if (string9 != null) {
                    for (int j = 0; j < stringArray2.length; ++j) {
                        if (!string9.equals(stringArray2[j])) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "currentScopeContained: nodegroup scopes match.");
                        }
                        return true;
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "!currentScopeContained: nodegroup scopes do not match.");
                }
                return false;
            }
            if (managementScopeData.getScopeType().equals("cell")) {
                String string10 = managementScopeData.formCellScope();
                String string11 = this.getCellScopeName();
                if (string10 != null && string11 != null && string10.equals(string11)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "currentScopeContained: cell scopes match.");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "!currentScopeContained: cell scopes do not match.");
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "!currentScopeContained: scopes do not match.");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CurrentScopeNames is null.");
        }
        return false;
    }

    public void loadSSLConfigGroups(Security security2, boolean bl) {
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadSSLConfigGroups");
        }
        if ((eList = security2.getSslConfigGroups()) != null) {
            String string;
            Object object;
            Object object2;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                object2 = (SSLConfigGroup)iterator.next();
                if (object2 == null) continue;
                object = object2.getManagementScope();
                string = null;
                string = object != null ? object.getScopeName() : ManagementScopeManager.getInstance().getCellScopeName();
                if (!this.currentScopeContained(string)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "SSLConfigGroup \"" + object2.getName() + "\" with scope \"" + string + "\" is not in the current process scope.");
                    continue;
                }
                ManagementScopeData managementScopeData = new ManagementScopeData(string);
                String string2 = object2.getDirection();
                String string3 = object2.getCertificateAlias();
                String string4 = object2.getSslConfig().getAlias();
                String string5 = null;
                string5 = string3 != null && string3.length() > 0 ? string4 + "," + string3 : string4;
                if (managementScopeData == null) continue;
                if (managementScopeData.getScopeType().equals("endpoint")) {
                    if (string2.equals("inbound")) {
                        this.inboundEndPointAliasMap.put(string, string5);
                        continue;
                    }
                    this.outboundEndPointAliasMap.put(string, string5);
                    continue;
                }
                if (managementScopeData.getScopeType().equals("server")) {
                    if (string2.equals("inbound")) {
                        this.inboundProcessAlias = string5;
                        continue;
                    }
                    this.outboundProcessAlias = string5;
                    continue;
                }
                if (managementScopeData.getScopeType().equals("cluster")) {
                    if (string2.equals("inbound")) {
                        this.inboundClusterAlias = string5;
                        continue;
                    }
                    this.outboundClusterAlias = string5;
                    continue;
                }
                if (managementScopeData.getScopeType().equals("node")) {
                    if (string2.equals("inbound")) {
                        this.inboundNodeAlias = string5;
                        continue;
                    }
                    this.outboundNodeAlias = string5;
                    continue;
                }
                if (managementScopeData.getScopeType().equals("nodegroup")) {
                    if (string2.equals("inbound")) {
                        this.inboundNodeGroupAliasMap.put(string, string5);
                        continue;
                    }
                    this.outboundNodeGroupAliasMap.put(string, string5);
                    continue;
                }
                if (managementScopeData.getScopeType().equals("cell")) {
                    if (string2.equals("inbound")) {
                        this.inboundCellAlias = string5;
                        continue;
                    }
                    this.outboundCellAlias = string5;
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Scope data with the following information is not a known scope type: " + managementScopeData);
            }
            if (this.inboundProcessAlias != null) {
                this.inboundEffectiveProcessAlias = this.inboundProcessAlias;
                this.inboundEffectiveProcessScope = "server";
            } else if (this.inboundClusterAlias != null) {
                this.inboundEffectiveProcessAlias = this.inboundClusterAlias;
                this.inboundEffectiveProcessScope = "cluster";
            } else if (this.inboundNodeAlias != null) {
                this.inboundEffectiveProcessAlias = this.inboundNodeAlias;
                this.inboundEffectiveProcessScope = "node";
            } else if (this.inboundNodeGroupAliasMap != null && this.inboundNodeGroupAliasMap.size() > 0) {
                object2 = this.inboundNodeGroupAliasMap.entrySet().iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    if (object == null) continue;
                    this.inboundEffectiveProcessAlias = (String)object.getValue();
                    this.inboundEffectiveProcessScope = "nodegroup";
                    break;
                }
            } else if (this.inboundCellAlias != null) {
                this.inboundEffectiveProcessAlias = this.inboundCellAlias;
                this.inboundEffectiveProcessScope = "cell";
            } else {
                object2 = SSLConfigManager.getInstance().getDefaultSSLConfig();
                if (object2 != null) {
                    object = ((Properties)object2).getProperty("com.ibm.ssl.alias");
                    string = ((Properties)object2).getProperty("com.ibm.ssl.keyStoreServerAlias");
                    this.inboundCellAlias = string != null && !string.equals("") ? (String)object + "," + string : object;
                }
                this.inboundEffectiveProcessAlias = this.inboundCellAlias;
                this.inboundEffectiveProcessScope = "cell";
            }
            if (this.outboundProcessAlias != null) {
                this.outboundEffectiveProcessAlias = this.outboundProcessAlias;
                this.outboundEffectiveProcessScope = "server";
            } else if (this.outboundClusterAlias != null) {
                this.outboundEffectiveProcessAlias = this.outboundClusterAlias;
                this.outboundEffectiveProcessScope = "cluster";
            } else if (this.outboundNodeAlias != null) {
                this.outboundEffectiveProcessAlias = this.outboundNodeAlias;
                this.outboundEffectiveProcessScope = "node";
            } else if (this.outboundNodeGroupAliasMap != null && this.outboundNodeGroupAliasMap.size() > 0) {
                object2 = this.outboundNodeGroupAliasMap.entrySet().iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    if (object == null) continue;
                    this.outboundEffectiveProcessAlias = (String)object.getValue();
                    this.outboundEffectiveProcessScope = "nodegroup";
                    break;
                }
            } else if (this.outboundCellAlias != null) {
                this.outboundEffectiveProcessAlias = this.outboundCellAlias;
                this.outboundEffectiveProcessScope = "cell";
            } else {
                object2 = SSLConfigManager.getInstance().getDefaultSSLConfig();
                if (object2 != null) {
                    object = ((Properties)object2).getProperty("com.ibm.ssl.alias");
                    string = ((Properties)object2).getProperty("com.ibm.ssl.keyStoreClientAlias");
                    this.outboundCellAlias = string != null && !string.equals("") ? (String)object + "," + string : object;
                }
                this.outboundEffectiveProcessAlias = this.outboundCellAlias;
                this.outboundEffectiveProcessScope = "cell";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Effective inbound group alias is \"" + this.inboundEffectiveProcessAlias + "\" from scope \"" + this.inboundEffectiveProcessScope + "\".");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Effective outbound group alias is \"" + this.outboundEffectiveProcessAlias + "\" from scope \"" + this.outboundEffectiveProcessScope + "\".");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadSSLConfigGroups");
        }
    }

    public String getConfigAndCertAliasesFromGroups(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigAndCertAliasesFromGroups", new Object[]{map});
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        if (map != null) {
            string3 = (String)map.get("com.ibm.ssl.direction");
            String string4 = null;
            if (map != null) {
                string4 = (String)map.get("com.ibm.ssl.endPointName");
            }
            String string5 = this.getProcessScopeName();
            string2 = string5 + ":(endpoint):" + string4;
            if (string3.equals("inbound")) {
                string = (String)this.inboundEndPointAliasMap.get(string2);
                if (string != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getConfigAndCertAliasesFromGroups (found from inbound endpoint) -> " + string);
                    }
                    return string;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getConfigAndCertAliasesFromGroups (found from inbound scope) -> " + this.inboundEffectiveProcessAlias);
                }
                return this.inboundEffectiveProcessAlias;
            }
            string = (String)this.outboundEndPointAliasMap.get(string2);
            if (string != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getConfigAndCertAliasesFromGroups (found from outbound endpoint) -> " + string);
                }
                return string;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConfigAndCertAliasesFromGroups (found from outbound scope) -> " + this.outboundEffectiveProcessAlias);
            }
            return this.outboundEffectiveProcessAlias;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigAndCertAliasesFromGroups (found from outbound scope without connection info) -> " + this.outboundEffectiveProcessAlias);
        }
        return this.outboundEffectiveProcessAlias;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("*** INBOUND ***\n");
        stringBuffer.append("\nCell Alias: ");
        stringBuffer.append(this.inboundCellAlias);
        stringBuffer.append("\nNodeGroup Alias(es): ");
        stringBuffer.append(this.inboundNodeGroupAliasMap);
        stringBuffer.append("\nNode Alias: ");
        stringBuffer.append(this.inboundNodeAlias);
        stringBuffer.append("\nServer Alias: ");
        stringBuffer.append(this.inboundProcessAlias);
        stringBuffer.append("\nCluster Alias: ");
        stringBuffer.append(this.inboundClusterAlias);
        stringBuffer.append("\nEndPoint Alias(es): ");
        stringBuffer.append(this.inboundEndPointAliasMap);
        stringBuffer.append("\nEffective Process Alias: ");
        stringBuffer.append(this.inboundEffectiveProcessAlias);
        stringBuffer.append("\nEffective Process Scope: ");
        stringBuffer.append(this.inboundEffectiveProcessScope);
        stringBuffer.append("\n\n*** OUTBOUND ***\n");
        stringBuffer.append("\nCell Alias: ");
        stringBuffer.append(this.outboundCellAlias);
        stringBuffer.append("\nNodeGroup Alias(es): ");
        stringBuffer.append(this.outboundNodeGroupAliasMap);
        stringBuffer.append("\nNode Alias: ");
        stringBuffer.append(this.outboundNodeAlias);
        stringBuffer.append("\nServer Alias: ");
        stringBuffer.append(this.outboundProcessAlias);
        stringBuffer.append("\nCluster Alias: ");
        stringBuffer.append(this.outboundClusterAlias);
        stringBuffer.append("\nEndPoint Alias(es): ");
        stringBuffer.append(this.outboundEndPointAliasMap);
        stringBuffer.append("\nEffective Process Alias: ");
        stringBuffer.append(this.outboundEffectiveProcessAlias);
        stringBuffer.append("\nEffective Process Scope: ");
        stringBuffer.append(this.outboundEffectiveProcessScope);
        return stringBuffer.toString();
    }
}

