/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.JSSEProviderFactory;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Stack;
import java.util.prefs.Preferences;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public final class WSPKCSInKeyStore {
    private static final TraceComponent tc = Tr.register(WSPKCSInKeyStore.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private KeyManagerFactory kmf;
    private KeyStore ks;
    private TrustManagerFactory tmf;
    private KeyStore ts;
    private JSSEProvider jsseProvider = null;
    private static Provider hwProvider = null;
    private String tokenLib_key;
    private String tokenType_key;
    private String tokenLib_trust;
    private String tokenType_trust;
    private static String pkcsType = "PKCS11IMPLKS";
    private static String pkcsProvider = "IBMPKCS11Impl";
    public static final int DEFAULT_SLOT = 0;
    public static final int SLOT_NOT_SPECIFIED = -1;
    private Stack providerInstancePool = new Stack();
    private int noOfWorkerThreads = 0;
    private int noOfProvidersCreated = 0;
    private BufferedReader fileReader = null;
    private StringBuffer tokenConfigBuffer = new StringBuffer();
    private String nameAttribute = null;

    public WSPKCSInKeyStore(String string, String string2) throws Exception {
        this.initializePKCS11ImplProvider(string, string2);
    }

    public WSPKCSInKeyStore(String string) throws Exception {
        this.initializePKCS11ImplProvider(string);
    }

    public void asKeyStore(String string, String string2, String string3, String string4, boolean bl) throws Exception {
        if ("IBMPKCS11Impl".equalsIgnoreCase(string4)) {
            string4 = hwProvider.getName();
        }
        this.jsseProvider = JSSEProviderFactory.getInstance(string4);
        try {
            if (this.tokenLib_key != null && this.tokenLib_key.compareToIgnoreCase(string2) == 0 && this.ks != null) {
                return;
            }
            if (this.tokenLib_trust != null && string2.compareTo(this.tokenLib_trust) == 0 && this.ts != null) {
                this.kmf = this.jsseProvider.getKeyManagerFactoryInstance();
                this.ks = this.ts;
                if (!bl) {
                    this.kmf.init(this.ts, string3.toCharArray());
                }
            } else {
                this.kmf = this.jsseProvider.getKeyManagerFactoryInstance();
                this.ks = KeyStore.getInstance(pkcsType, hwProvider.getName());
                if (!bl) {
                    this.ks.load(null, string3.toCharArray());
                    this.kmf.init(this.ks, string3.toCharArray());
                }
            }
            this.tokenLib_key = new String(string2);
            this.tokenType_key = new String(string);
        }
        catch (Exception exception) {
            this.kmf = null;
            this.ks = null;
            this.tokenLib_key = null;
            this.tokenType_key = null;
            throw exception;
        }
    }

    public void asTrustStore(String string, String string2, String string3, String string4, boolean bl) throws Exception {
        this.jsseProvider = JSSEProviderFactory.getInstance(string4);
        try {
            if (this.tokenLib_trust != null && this.tokenLib_trust.compareToIgnoreCase(string2) == 0 && this.ts != null) {
                return;
            }
            if (this.tokenLib_key != null && string2.compareTo(this.tokenLib_key) == 0 && this.ks != null) {
                this.tmf = this.jsseProvider.getTrustManagerFactoryInstance();
                this.ts = this.ks;
                if (!bl) {
                    this.tmf.init(this.ks);
                }
            } else {
                this.tmf = this.jsseProvider.getTrustManagerFactoryInstance();
                this.ts = KeyStore.getInstance(pkcsType, hwProvider.getName());
                if (!bl) {
                    this.ts.load(null, string3.toCharArray());
                    this.tmf.init(this.ts);
                }
            }
            this.tokenLib_trust = new String(string2);
            this.tokenType_trust = new String(string);
        }
        catch (Exception exception) {
            this.tmf = null;
            this.ts = null;
            this.tokenLib_trust = null;
            this.tokenType_trust = null;
            throw exception;
        }
    }

    public KeyManagerFactory getKMF() {
        return this.kmf;
    }

    public KeyStore getKS() {
        return this.ks;
    }

    public TrustManagerFactory getTMF() {
        return this.tmf;
    }

    public KeyStore getTS() {
        return this.ts;
    }

    public String getlibName_key() {
        return this.tokenLib_key;
    }

    public String getlibName_trust() {
        return this.tokenLib_trust;
    }

    public String gettokType_key() {
        return this.tokenType_key;
    }

    public String gettokType_trust() {
        return this.tokenType_trust;
    }

    public void initializePKCS11ImplProvider(String string, String string2) throws Exception {
        Provider provider = Security.getProvider("IBMPKCS11Impl");
        if (provider == null && string != null && string2 != null) {
            Preferences preferences = Preferences.userNodeForPackage(IBMPKCS11Impl.class);
            preferences.put("IBMPKCSImpl DLL", string);
            preferences.put("IBMPKCSImpl password", string2);
            AddHardwareProviderAction addHardwareProviderAction = new AddHardwareProviderAction();
            try {
                AccessController.doPrivileged(addHardwareProviderAction);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.orbssl.WSPKCSInKeyStore", "249");
                throw exception;
            }
            finally {
                if (preferences != null) {
                    preferences.remove("IBMPKCSImpl DLL");
                    preferences.remove("IBMPKCSImpl password");
                }
            }
            provider = Security.getProvider("IBMPKCS11Impl");
        }
    }

    public void initializePKCS11ImplProvider(String string) throws Exception {
        final String string2 = string;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    hwProvider = (Provider)new IBMPKCS11Impl(string2);
                    Security.addProvider(hwProvider);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The provider: " + hwProvider + "is added at the end of the provider list");
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot initialize IBMPKCS11Impl provider: ", new Object[]{exception});
            }
            FFDCFilter.processException(exception, "com.ibm.ws.security.orbssl.WSPKCSInKeyStore", "259");
            throw exception;
        }
        BufferedReader bufferedReader = this.convertFileToBuffer(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Provider getHWCryptoProviderInstance(String string) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHWCryptoProviderInstance(String)");
        }
        Serializable serializable = this.providerInstancePool;
        synchronized (serializable) {
            if (!this.providerInstancePool.empty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "try to get the HW crypto provider instance from pool");
                }
                if ((object = (Provider)this.providerInstancePool.pop()) != null) {
                    return object;
                }
            }
        }
        ++this.noOfProvidersCreated;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "continue creating new HW crypto provider instance");
        }
        serializable = new StringBuffer();
        ((StringBuffer)serializable).append(this.nameAttribute).append(this.noOfProvidersCreated).append(LINE_SEPARATOR).append(this.tokenConfigBuffer);
        object = new BufferedReader(new StringReader(((StringBuffer)serializable).toString()));
        try {
            return new IBMPKCS11Impl((BufferedReader)object);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot get the HW crypto provider instance" + new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.WSPKCSInKeyStore.getHWCryptoProviderInstance", "273", this);
            Tr.error(tc, "Cannot get the HW crypto provider instance", new Object[]{string, exception.getMessage()});
            throw exception;
        }
    }

    private BufferedReader convertFileToBuffer(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        try {
            if (this.fileReader == null) {
                this.fileReader = new BufferedReader(new FileReader(string));
                try {
                    while ((string2 = this.fileReader.readLine()) != null) {
                        String string3 = string2.trim();
                        if (string3.startsWith("name")) {
                            this.nameAttribute = string3;
                            continue;
                        }
                        this.tokenConfigBuffer.append(string3).append(LINE_SEPARATOR);
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException(iOException, "com.ibm.ws.security.orbssl.WSPKCSInKeyStore", "333");
                    throw iOException;
                }
                finally {
                    if (this.fileReader != null) {
                        try {
                            this.fileReader.close();
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException(iOException, "com.ibm.ws.security.orbssl.WSPKCSInKeyStore", "342");
                            throw iOException;
                        }
                    }
                }
            }
            stringBuffer.append(this.nameAttribute).append(this.noOfProvidersCreated).append(LINE_SEPARATOR).append(this.tokenConfigBuffer);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException(fileNotFoundException, "com.ibm.ws.security.orbssl.WSPKCSInKeyStore", "352");
            throw fileNotFoundException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Name attribute and other card related info: " + this.nameAttribute + ":" + this.tokenConfigBuffer.toString());
        }
        return new BufferedReader(new StringReader(stringBuffer.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Provider getHWCryptoProviderInstance(String string, String string2) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHWCryptoProviderInstance(String, String)");
        }
        Serializable serializable = this.providerInstancePool;
        synchronized (serializable) {
            if (!this.providerInstancePool.empty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "try to get the HW crypto provider instance from pool");
                }
                if ((object = (Provider)this.providerInstancePool.pop()) != null) {
                    return object;
                }
            }
        }
        ++this.noOfProvidersCreated;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "continue creating new HW provider instance");
        }
        serializable = new StringBuffer();
        object = "thread-" + this.noOfProvidersCreated;
        ((StringBuffer)serializable).append("name=" + (String)object);
        ((StringBuffer)serializable).append(LINE_SEPARATOR);
        ((StringBuffer)serializable).append("library=" + string);
        ((StringBuffer)serializable).append(LINE_SEPARATOR);
        ((StringBuffer)serializable).append("slotListIndex=" + string2);
        ((StringBuffer)serializable).append(LINE_SEPARATOR);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(((StringBuffer)serializable).toString()));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getting new HW crypto provider instance : " + ((StringBuffer)serializable).toString());
        }
        try {
            return new IBMPKCS11Impl(bufferedReader);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot get the HW crypto provider instance" + new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.WSPKCSInKeyStore.getHWCryptoProviderInstance", "273", this);
            Tr.error(tc, "Cannot get the HW crypto provider instance", new Object[]{string, string2, exception.getMessage()});
            throw exception;
        }
    }

    public void returnHWCryptoProviderInstance(Provider provider) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "returnHWCryptoProviderInstance()");
        }
        if (provider != null) {
            this.providerInstancePool.push(provider);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returnHWCryptoProviderInstance()");
        }
    }

    static class AddHardwareProviderAction
    implements PrivilegedAction {
        public Object run() {
            Security.addProvider((Provider)new IBMPKCS11Impl());
            return null;
        }
    }
}

