/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class CharBuffer
implements Serializable {
    protected char[] value;
    protected int count;
    private static final long serialVersionUID = 9027788665325452609L;

    public CharBuffer() {
        this(16);
    }

    public CharBuffer(int n) {
        this.value = new char[n];
    }

    public CharBuffer(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    private final void copy() {
        char[] cArray = new char[this.value.length];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
    }

    public void ensureCapacity(int n) {
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
    }

    private void expandCapacity(int n) {
        int n2 = (this.value.length + 1) * 2;
        if (n > n2) {
            n2 = n;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        this.count = n;
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < n2) {
            System.arraycopy(this.value, n, cArray, n3, n2 - n);
        } else if (n > n2) {
            throw new StringIndexOutOfBoundsException("StringBuffer.getChars(): begin > end");
        }
    }

    public void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.value[n] = c;
    }

    public CharBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public CharBuffer append(String string) {
        int n;
        int n2;
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n2 = this.count + (n = string.length())) > this.value.length) {
            this.expandCapacity(n2);
        }
        string.getChars(0, n, this.value, this.count);
        this.count = n2;
        return this;
    }

    public CharBuffer append(char[] cArray) {
        int n = cArray.length;
        int n2 = this.count + n;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        System.arraycopy(cArray, 0, this.value, this.count, n);
        this.count = n2;
        return this;
    }

    public CharBuffer append(char[] cArray, int n, int n2) {
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(cArray, n, this.value, this.count, n2);
        this.count = n3;
        return this;
    }

    public CharBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public CharBuffer append(char c) {
        int n = this.count + 1;
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        this.value[this.count++] = c;
        return this;
    }

    public CharBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public CharBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public CharBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public CharBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public CharBuffer delete(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 > 0) {
            System.arraycopy(this.value, n + n3, this.value, n, this.count - n2);
            this.count -= n3;
        }
        return this;
    }

    public CharBuffer deleteCharAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, n + 1, this.value, n, this.count - n - 1);
        --this.count;
        return this;
    }

    public CharBuffer replace(int n, int n2, String string) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = string.length();
        int n4 = this.count + n3 - (n2 - n);
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        }
        System.arraycopy(this.value, n2, this.value, n + n3, this.count - n2);
        string.getChars(0, n3, this.value, n);
        this.count = n4;
        return this;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        return new String(this.value, n, n2 - n);
    }

    public CharBuffer insert(int n, char[] cArray, int n2, int n3) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n2 < 0 || n2 + n3 > cArray.length) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        int n4 = this.count + n3;
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        }
        System.arraycopy(this.value, n, this.value, n + n3, this.count - n);
        System.arraycopy(cArray, n2, this.value, n, n3);
        this.count = n4;
        return this;
    }

    public CharBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public CharBuffer insert(int n, String string) {
        int n2;
        int n3;
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n3 = this.count + (n2 = string.length())) > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars(0, n2, this.value, n);
        this.count = n3;
        return this;
    }

    public CharBuffer insert(int n, char[] cArray) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = cArray.length;
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        System.arraycopy(cArray, 0, this.value, n, n2);
        this.count = n3;
        return this;
    }

    public CharBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public CharBuffer insert(int n, char c) {
        int n2 = this.count + 1;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        System.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        this.count = n2;
        return this;
    }

    public CharBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public CharBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public CharBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public CharBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public CharBuffer reverse() {
        int n = this.count - 1;
        for (int i = n - 1 >> 1; i >= 0; --i) {
            char c = this.value[i];
            this.value[i] = this.value[n - i];
            this.value[n - i] = c;
        }
        return this;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    public char[] getValue() {
        return this.value;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.value = (char[])this.value.clone();
    }
}

