/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.DefaultClientPlatformHelper;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.PlatformHelper;

public class PlatformHelperFactory {
    private static PlatformHelper helper = null;
    public static boolean FORCE_DIST = Boolean.getBoolean("com.ibm.websphere.zos.forcedist");
    private static final String zWASHelper = "com.ibm.ws.management.util.PlatformHelperImpl";
    private static final String distHelper = "com.ibm.ws.management.DefaultPlatformHelper";

    public static void setPlatformHelper(PlatformHelper platformHelper) {
        helper = platformHelper;
    }

    public static PlatformHelper getPlatformHelper() {
        if (helper == null) {
            try {
                helper = FORCE_DIST ? (PlatformHelper)Class.forName(distHelper).newInstance() : (PlatformHelper)ImplFactory.loadImplFromKey(PlatformHelper.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException(classNotFoundException, "com.ibm.ws.util.PlatformHelperFactory.getPlatformHelper", "72");
                helper = PlatformHelperFactory.getBackupHelper();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                FFDCFilter.processException(noClassDefFoundError, "com.ibm.ws.util.PlatformHelperFactory.getPlatformHelper", "79");
                helper = PlatformHelperFactory.getBackupHelper();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.util.PlatformHelperFactory.getPlatformHelper", "86");
                helper = PlatformHelperFactory.getBackupHelper();
            }
        }
        return helper;
    }

    protected static PlatformHelper getBackupHelper() {
        try {
            String string = System.getProperty("os.name");
            PlatformHelper platformHelper = null;
            platformHelper = string != null && (string.equalsIgnoreCase("OS/390") || string.equalsIgnoreCase("z/OS")) ? (PlatformHelper)Class.forName(zWASHelper).newInstance() : (PlatformHelper)Class.forName(distHelper).newInstance();
            if (platformHelper != null) {
                return platformHelper;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.util.PlatformHelperFactory.getBackupHelper", "123");
        }
        return new DefaultClientPlatformHelper();
    }
}

