/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.utilHandlerClass;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;

public class URLHandlerFactory
implements URLStreamHandlerFactory {
    private static final TraceComponent tc = Tr.register(URLHandlerFactory.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private Map streamHandlerTable;

    public URLHandlerFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "URLHandlerFactory ctor");
        }
        this.streamHandlerTable = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "URLHandlerFactory ctor");
        }
    }

    public void registerProvider(String string, String string2) {
        String string3 = URLHandlerFactory.getClassName(string2);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerProvider " + string + " : " + string3);
        }
        if (string != null && string3 != null) {
            this.streamHandlerTable.put(string, new utilHandlerClass(string3, string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerProvider(provider,class)");
        }
    }

    public void deregisterProvider(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterProvider");
        }
        if (string != null) {
            this.streamHandlerTable.remove(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterProvider");
        }
    }

    public boolean queryProvider(String string) {
        Tr.entry(tc, "queryProvider");
        boolean bl = false;
        if (string != null) {
            bl = this.streamHandlerTable.containsKey(string);
        }
        Tr.exit(tc, "queryProvider");
        return bl;
    }

    public URLStreamHandler createURLStreamHandler(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createURLStreamHandler for protocol=" + string);
        }
        URLStreamHandler uRLStreamHandler = null;
        if (string != null && string.length() > 0) {
            string = string.toLowerCase();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "streamHandlerTable=" + this.streamHandlerTable);
            }
            utilHandlerClass utilHandlerClass2 = (utilHandlerClass)this.streamHandlerTable.get(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handler class " + utilHandlerClass2 + " retrieved from streamHandlerTable");
            }
            if (utilHandlerClass2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found a handlerClass object for " + string);
                }
                if (utilHandlerClass2.getClassname() != null) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "attempting to get a class loader for " + utilHandlerClass2.getClasspath());
                        }
                        ClassLoader classLoader = URLHandlerFactory.getResourceClassLoader(tc, utilHandlerClass2.getClasspath(), null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Attempting to load " + utilHandlerClass2.getClassname());
                        }
                        Class<?> clazz = classLoader.loadClass(utilHandlerClass2.getClassname());
                        uRLStreamHandler = (URLStreamHandler)clazz.newInstance();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found streamHandlerClass " + utilHandlerClass2.getClassname() + " for protocol " + string);
                        }
                    }
                    catch (Throwable throwable) {
                        String[] stringArray = new String[]{utilHandlerClass2.getClassname(), string};
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "URLStreamHandlerError " + throwable.toString() + " " + utilHandlerClass2.getClassname() + " " + string);
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find streamHandlerClass for: " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createURLStreamHandler returning handler:" + uRLStreamHandler);
        }
        return uRLStreamHandler;
    }

    public static String getClassName(String string) {
        String string2 = new String(string);
        string2 = string2.replace(File.pathSeparatorChar, '.');
        return string2;
    }

    public static String appendClasspathStrings(String string, String string2) {
        if (!URLHandlerFactory.isStringEmpty(string)) {
            string = string.trim();
        }
        if (!URLHandlerFactory.isStringEmpty(string2)) {
            string2 = string2.trim();
        }
        if (!URLHandlerFactory.isStringEmpty(string2)) {
            if (URLHandlerFactory.isStringEmpty(string)) {
                return string2;
            }
            if (string.endsWith(File.pathSeparator)) {
                return string + string2;
            }
            return string + File.pathSeparator + string2;
        }
        return string;
    }

    public static boolean isStringEmpty(String string) {
        return string == null || string.length() <= 0;
    }

    public static ClassLoader getResourceClassLoader(TraceComponent traceComponent, String string, ClassLoader classLoader) throws MalformedURLException {
        ClassLoader classLoader2 = null;
        if (traceComponent.isEntryEnabled()) {
            Tr.entry(traceComponent, "getResourceClassLoader " + string + " : " + classLoader);
        }
        if (string == null || string.equalsIgnoreCase("")) {
            classLoader2 = Thread.currentThread().getContextClassLoader();
            if (classLoader2 == null) {
                classLoader2 = ClassLoader.getSystemClassLoader();
            }
        } else {
            URL[] uRLArray;
            if (traceComponent.isDebugEnabled()) {
                Tr.debug(traceComponent, "parsing urls classpath=" + string);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), File.pathSeparator);
            ArrayList<URL[]> arrayList = new ArrayList<URL[]>();
            while (stringTokenizer.hasMoreTokens()) {
                uRLArray = stringTokenizer.nextToken().trim();
                if (uRLArray.equals("")) continue;
                arrayList.add(uRLArray);
            }
            uRLArray = URLHandlerFactory.toLocalURLs(arrayList, File.separator);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < uRLArray.length; ++i) {
                stringBuffer.append("\n       " + uRLArray[i]);
            }
            if (traceComponent.isDebugEnabled()) {
                Tr.debug(traceComponent, "loadingurls: " + stringBuffer.toString());
            }
            classLoader2 = classLoader == null ? new URLClassLoader(uRLArray, Thread.currentThread().getContextClassLoader()) : new URLClassLoader(uRLArray, classLoader);
        }
        return classLoader2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL[] toLocalURLs(List list, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            String string2 = (String)list.get(i);
            File file = new File(string2);
            if (!file.isAbsolute()) {
                string2 = URLHandlerFactory.getOSUri(string, string2);
                file = new File(string2);
            }
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                if (!string2.endsWith(File.separator)) {
                    string2 = string2 + File.separatorChar;
                }
            } else {
                object = null;
                try {
                    object = new ZipFile(file);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                finally {
                    if (object != null) {
                        try {
                            ((ZipFile)object).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            try {
                file = new File(string2);
                object = file.toURL();
                arrayList.add(object);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        URL[] uRLArray = new URL[arrayList.size()];
        return arrayList.toArray(uRLArray);
    }

    public static String getOSUri(String string, String string2) {
        String string3 = URLHandlerFactory.getOSUri(string);
        String string4 = URLHandlerFactory.getOSUri(string2);
        return URLHandlerFactory.concatUri(string3, string4, File.separatorChar);
    }

    public static String getOSUri(String string) {
        char c = File.separatorChar;
        if (c != '/') {
            return string.replace('/', c);
        }
        return string.replace('\\', c);
    }

    public static String concatUri(String string, String string2, char c) {
        String string3 = string;
        if (!string.endsWith(c + "") && !string2.startsWith(c + "")) {
            string3 = string3 + c;
        }
        return string3 + string2;
    }
}

