/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.description;

import com.ibm.ws.webservices.engine.description.BaseDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;

public class ParameterDesc
extends BaseDesc {
    public static final byte IN = 1;
    public static final byte OUT = 2;
    public static final byte INOUT = 3;
    public static String PART_NAME = "partName";
    public static String PART_QNAME_STRING = "partQNameString";
    public static String MIME_TYPE = "MIMEType";
    private Class javaType = null;
    private Class javaSigType = null;
    private String _javaType = null;
    private String _javaSigType = null;
    private QName name;
    private QName typeQName;
    private byte mode = 1;
    private int order = -1;
    private boolean isReturn = false;
    private boolean inHeader = false;
    private boolean outHeader = false;
    private boolean minOccursIs0 = false;
    private boolean maxOccursIs1 = true;
    private boolean wsdl11MIME = true;

    public ParameterDesc() {
    }

    public ParameterDesc(ParameterDesc parameterDesc) {
        this.name = parameterDesc.name;
        this.mode = parameterDesc.mode;
        this.typeQName = parameterDesc.typeQName;
        this.javaType = parameterDesc.javaType;
        this._javaType = parameterDesc._javaType;
        this.javaSigType = parameterDesc.javaSigType;
        this._javaSigType = parameterDesc._javaSigType;
        this.order = parameterDesc.order;
        this.isReturn = parameterDesc.isReturn;
        this.inHeader = parameterDesc.inHeader;
        this.outHeader = parameterDesc.outHeader;
        this.minOccursIs0 = parameterDesc.minOccursIs0;
        this.maxOccursIs1 = parameterDesc.maxOccursIs1;
        this.wsdl11MIME = parameterDesc.wsdl11MIME;
        this.setOptions(parameterDesc.getOptions());
    }

    public ParameterDesc(QName qName, byte by, QName qName2) {
        this.name = qName;
        this.mode = by;
        this.typeQName = qName2;
    }

    public ParameterDesc(QName qName, byte by, QName qName2, Class clazz, boolean bl, boolean bl2) {
        this(qName, by, qName2);
        this.javaType = clazz;
        this.inHeader = bl;
        this.outHeader = bl2;
    }

    public ParameterDesc(QName qName, byte by, QName qName2, Class clazz, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(qName, by, qName2);
        this.javaType = clazz;
        this.inHeader = bl;
        this.outHeader = bl2;
        this.minOccursIs0 = bl3;
        this.maxOccursIs1 = bl4;
    }

    public ParameterDesc(QName qName, byte by, QName qName2, Class clazz, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this(qName, by, qName2);
        this.setJavaType(clazz);
        this.isReturn = bl;
        this.inHeader = bl2;
        this.outHeader = bl3;
        this.minOccursIs0 = bl4;
        this.maxOccursIs1 = bl5;
        this.wsdl11MIME = bl6;
    }

    public ParameterDesc(QName qName, byte by, QName qName2, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this(qName, by, qName2);
        this._javaType = string;
        this.isReturn = bl;
        this.inHeader = bl2;
        this.outHeader = bl3;
        this.minOccursIs0 = bl4;
        this.maxOccursIs1 = bl5;
        this.wsdl11MIME = bl6;
    }

    public QName getQName() {
        return this.name;
    }

    public String getName() {
        if (this.name == null) {
            return null;
        }
        return this.name.getLocalPart();
    }

    public void setName(String string) {
        this.name = new QName("", string);
    }

    public void setQName(QName qName) {
        this.name = qName;
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    public void setTypeQName(QName qName) {
        this.typeQName = qName;
    }

    public Class getJavaType() {
        if (this._javaType != null) {
            this.javaType = this.toClass(this._javaType);
            this._javaType = null;
        }
        return this.javaType;
    }

    public void setJavaType(Class clazz) {
        this.javaType = clazz;
        if (this.javaSigType == null && this._javaSigType == null) {
            this.javaSigType = clazz;
        }
        this._javaType = null;
        this._javaSigType = null;
    }

    public Class getJavaSigType() {
        if (this._javaSigType != null) {
            this.javaSigType = this.toClass(this._javaSigType);
            this._javaSigType = null;
        }
        return this.javaSigType;
    }

    public void setJavaSigType(Class clazz) {
        if (clazz != null && ((this.mode == 1 || this.isReturn) && Holder.class.isAssignableFrom(clazz) || this.mode != 1 && !this.isReturn && !Holder.class.isAssignableFrom(clazz))) {
            throw new IllegalArgumentException(Messages.getMessage("setJavaTypeErr00", clazz.getName(), ParameterDesc.getModeAsString(this.mode)));
        }
        this.javaSigType = clazz;
        this._javaSigType = null;
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte by) {
        this.mode = by;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public void setInHeader(boolean bl) {
        this.inHeader = bl;
    }

    public boolean isInHeader() {
        return this.inHeader;
    }

    public void setOutHeader(boolean bl) {
        this.outHeader = bl;
    }

    public boolean isOutHeader() {
        return this.outHeader;
    }

    public boolean getIsReturn() {
        return this.isReturn;
    }

    public void setIsReturn(boolean bl) {
        this.isReturn = bl;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ParameterDesc parameterDesc = (ParameterDesc)object;
        if (this.name != null && !this.name.equals(parameterDesc.name) || this.name == null && parameterDesc.name != null) {
            return false;
        }
        if (this.mode != parameterDesc.mode) {
            return false;
        }
        if (this.typeQName != null && !this.typeQName.equals(parameterDesc.typeQName) || this.typeQName == null && parameterDesc.typeQName != null) {
            return false;
        }
        if (this.javaType != parameterDesc.javaType) {
            return false;
        }
        if (this.javaSigType != parameterDesc.javaSigType) {
            return false;
        }
        if (this.inHeader != parameterDesc.inHeader) {
            return false;
        }
        if (this.outHeader != parameterDesc.outHeader) {
            return false;
        }
        if (this.minOccursIs0 != parameterDesc.minOccursIs0) {
            return false;
        }
        return this.maxOccursIs1 == parameterDesc.maxOccursIs1;
    }

    public int hashCode() {
        int n = 0;
        if (this.name != null) {
            n += this.name.hashCode();
        }
        if (this.typeQName != null) {
            n += this.typeQName.hashCode();
        }
        if (this.javaType != null) {
            n += this.javaType.hashCode();
        }
        return n;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + "identity:    " + JavaUtils.getObjectIdentity(this) + "\n";
        string2 = string2 + string + "name:       " + this.name + "\n";
        string2 = string2 + string + "mode:       " + (this.mode == 1 ? "IN" : (this.mode == 3 ? "INOUT" : "OUT:  position:" + this.order)) + "\n";
        string2 = string2 + string + "isReturn:   " + this.isReturn + "\n";
        string2 = string2 + string + "typeQName:  " + this.typeQName + "\n";
        string2 = string2 + string + "javaType:   " + this.javaType + "\n";
        string2 = string2 + string + "javaSigType:" + this.javaSigType + "\n";
        string2 = string2 + string + "inHeader:   " + this.inHeader + "\n";
        string2 = string2 + string + "outHeader:  " + this.outHeader + "\n";
        string2 = string2 + string + "minOccursIs0:" + this.minOccursIs0 + "\n";
        string2 = string2 + string + "maxOccursIs1:" + this.maxOccursIs1 + "\n";
        string2 = string2 + string + "properties: \n";
        string2 = string2 + this.toStringConfigurable(string + " ");
        return string2;
    }

    public static byte modeFromString(String string) {
        int n = 1;
        if (string == null) {
            return 1;
        }
        if (string.equalsIgnoreCase("out")) {
            n = 2;
        } else if (string.equalsIgnoreCase("inout")) {
            n = 3;
        }
        return (byte)n;
    }

    public static String getModeAsString(byte by) {
        if (by == 3) {
            return "inout";
        }
        if (by == 2) {
            return "out";
        }
        if (by == 1) {
            return "in";
        }
        throw new IllegalArgumentException(Messages.getMessage("badParameterMode", Byte.toString(by)));
    }

    public boolean isMinOccursIs0() {
        return this.minOccursIs0;
    }

    public void setMinOccursIs0(boolean bl) {
        this.minOccursIs0 = bl;
    }

    public boolean isMaxOccursIs1() {
        return this.maxOccursIs1;
    }

    public void setMaxOccursIs1(boolean bl) {
        this.maxOccursIs1 = bl;
    }

    public boolean isWSDL11MIME() {
        return this.wsdl11MIME;
    }

    public void setWSDL11MIME(boolean bl) {
        this.wsdl11MIME = bl;
    }

    private Class toClass(String string) {
        try {
            return ClassUtils.forName(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isMIMEType() {
        if (this.isWSDL11MIME()) {
            String string = this.getJavaType().getName();
            return "java.awt.Image".equals(string) || "javax.xml.transform.Source".equals(string) || "javax.mail.internet.MimeMultipart".equals(string) || "javax.activation.DataHandler".equals(string);
        }
        return false;
    }
}

