/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleValueSerializer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;

public class CalendarSerializer
implements SimpleValueSerializer {
    private static final SimpleDateFormat zuluDateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final SimpleDateFormat zuluDate = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat zuluTime = new SimpleDateFormat("HH:mm:ss.SSS'Z'");
    protected QName xmlType;
    protected Class javaType;
    private QName componentTypeQName;

    public CalendarSerializer(Class clazz, QName qName, QName qName2, QName qName3) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.componentTypeQName = qName3 == null ? qName : qName3;
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        serializationContext.getSerializationWriter().simpleElement(qName, attributes, this.getValueAsString(object, serializationContext));
    }

    public String getValueAsString(Object object, SerializationContext serializationContext) {
        if (Constants.equals(Constants.XSD_DATE, this.componentTypeQName)) {
            return CalendarSerializer.getDateValueAsString(object);
        }
        if (Constants.equals(Constants.XSD_TIME, this.componentTypeQName)) {
            return CalendarSerializer.getTimeValueAsString(object);
        }
        return CalendarSerializer.getDateTimeValueAsString(object);
    }

    public static synchronized String getDateValueAsString(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (((Calendar)object).get(0) == 0) {
            stringBuffer.append("-");
            ((Calendar)object).set(0, 1);
        }
        Date date = ((Calendar)object).getTime();
        stringBuffer.append(zuluDate.format(date));
        return stringBuffer.toString();
    }

    public static synchronized String getTimeValueAsString(Object object) {
        return zuluTime.format(((Calendar)object).getTime());
    }

    public static synchronized String getDateTimeValueAsString(Object object) {
        Date date = object instanceof Date ? (Date)object : ((Calendar)object).getTime();
        return zuluDateTime.format(date);
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return null;
    }

    static {
        zuluDateTime.setTimeZone(TimeZone.getTimeZone("GMT"));
        zuluTime.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

