/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.resources;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;

public class ProjectResourceBundle
extends ResourceBundle {
    protected static Log log = LogFactory.getLog(ProjectResourceBundle.class.getName());
    private static final boolean ENABLE_DEBUG = false;
    private static final Hashtable bundleCache = new Hashtable();
    private static final Locale defaultLocale = Locale.getDefault();
    private final ResourceBundle resourceBundle;
    private final String resourceName;

    protected Object handleGetObject(String string) throws MissingResourceException {
        Object object;
        try {
            object = this.resourceBundle.getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            object = null;
        }
        return object;
    }

    public Enumeration getKeys() {
        Enumeration<String> enumeration = this.resourceBundle.getKeys();
        if (this.parent == null) {
            return enumeration;
        }
        final HashSet<String> hashSet = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        Enumeration<String> enumeration2 = this.parent.getKeys();
        while (enumeration2.hasMoreElements()) {
            hashSet.add(enumeration2.nextElement());
        }
        return new Enumeration(){
            private Iterator it;
            {
                this.it = hashSet.iterator();
            }

            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            public Object nextElement() {
                return this.it.next();
            }
        };
    }

    public static ProjectResourceBundle getBundle(String string, String string2, String string3) throws MissingResourceException {
        return ProjectResourceBundle.getBundle(string, string2, string3, null, null, null);
    }

    public static ProjectResourceBundle getBundle(String string, Class clazz, String string2, Locale locale) throws MissingResourceException {
        return ProjectResourceBundle.getBundle(string, clazz, string2, locale, null);
    }

    public static ProjectResourceBundle getBundle(String string, String string2, String string3, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        return ProjectResourceBundle.getBundle(string, string2, string3, locale, classLoader, null);
    }

    public static ProjectResourceBundle getBundle(String string, Class clazz, String string2, Locale locale, ResourceBundle resourceBundle) throws MissingResourceException {
        return ProjectResourceBundle.getBundle(string, ProjectResourceBundle.getPackage(clazz.getClass().getName()), string2, locale, clazz.getClass().getClassLoader(), resourceBundle);
    }

    public static ProjectResourceBundle getBundle(String string, String string2, String string3, Locale locale, ClassLoader classLoader, ResourceBundle resourceBundle) throws MissingResourceException {
        if (log.isDebugEnabled()) {
            log.debug("getBundle(" + string + "," + string2 + "," + string3 + "," + String.valueOf(locale) + ",...)");
        }
        Context context = new Context();
        context.setLocale(locale);
        context.setLoader(classLoader);
        context.setProjectName(string);
        context.setResourceName(string3);
        context.setParentBundle(resourceBundle);
        string2 = context.validate(string2);
        ProjectResourceBundle projectResourceBundle = null;
        try {
            projectResourceBundle = ProjectResourceBundle.getBundle(context, string2);
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException(runtimeException, "com.ibm.ws.webservices.engine.resources.ProjectResourceBundle.getBundle", "323");
            log.debug("Exception: ", runtimeException);
            throw runtimeException;
        }
        if (projectResourceBundle == null) {
            throw new MissingResourceException("Cannot find resource '" + string2 + '.' + string3 + "'", string3, "");
        }
        return projectResourceBundle;
    }

    private static synchronized ProjectResourceBundle getBundle(Context context, String string) throws MissingResourceException {
        String string2 = context.getCacheKey(string);
        ProjectResourceBundle projectResourceBundle = (ProjectResourceBundle)bundleCache.get(string2);
        if (projectResourceBundle == null) {
            String string3 = string + '.' + context.getResourceName();
            ResourceBundle resourceBundle = context.loadBundle(string);
            ResourceBundle resourceBundle2 = context.getParentBundle(string);
            if (resourceBundle != null) {
                projectResourceBundle = new ProjectResourceBundle(string3, resourceBundle);
                projectResourceBundle.setParent(resourceBundle2);
                if (log.isDebugEnabled()) {
                    log.debug("Created " + projectResourceBundle + ", linked to parent " + String.valueOf(resourceBundle2));
                }
            } else if (resourceBundle2 != null) {
                projectResourceBundle = resourceBundle2 instanceof ProjectResourceBundle ? (ProjectResourceBundle)resourceBundle2 : new ProjectResourceBundle(string3, resourceBundle2);
                if (log.isDebugEnabled()) {
                    log.debug("Root package not found, cross link to " + resourceBundle2);
                }
            }
            if (projectResourceBundle != null) {
                bundleCache.put(string2, projectResourceBundle);
            }
        }
        return projectResourceBundle;
    }

    private static final String getPackage(String string) {
        return string.substring(0, string.lastIndexOf(46)).intern();
    }

    private ProjectResourceBundle(String string, ResourceBundle resourceBundle) throws MissingResourceException {
        this.resourceBundle = resourceBundle;
        this.resourceName = string;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public static void clearCache() {
        bundleCache.clear();
    }

    public String toString() {
        return this.resourceName;
    }

    private static class Context {
        private Locale _locale;
        private ClassLoader _loader;
        private String _projectName;
        private String _resourceName;
        private ResourceBundle _parent;

        private Context() {
        }

        void setLocale(Locale locale) {
            this._locale = locale == null ? defaultLocale : locale;
        }

        void setLoader(ClassLoader classLoader) {
            this._loader = classLoader != null ? classLoader : this.getClass().getClassLoader();
        }

        void setProjectName(String string) {
            this._projectName = string.intern();
        }

        void setResourceName(String string) {
            this._resourceName = string.intern();
        }

        void setParentBundle(ResourceBundle resourceBundle) {
            this._parent = resourceBundle;
        }

        Locale getLocale() {
            return this._locale;
        }

        ClassLoader getLoader() {
            return this._loader;
        }

        String getProjectName() {
            return this._projectName;
        }

        String getResourceName() {
            return this._resourceName;
        }

        ResourceBundle getParentBundle() {
            return this._parent;
        }

        String getCacheKey(String string) {
            String string2 = this._loader == null ? "" : ":" + this._loader.hashCode();
            return string + "." + this._resourceName + ":" + this._locale + ":" + defaultLocale + string2;
        }

        ResourceBundle loadBundle(String string) {
            try {
                return ResourceBundle.getBundle(string + '.' + this._resourceName, this._locale, this._loader);
            }
            catch (MissingResourceException missingResourceException) {
                log.debug("loadBundle: Ignoring MissingResourceException: " + missingResourceException.getMessage());
                return null;
            }
        }

        ResourceBundle getParentBundle(String string) {
            ResourceBundle resourceBundle;
            if (string != this._projectName) {
                resourceBundle = ProjectResourceBundle.getBundle(this, ProjectResourceBundle.getPackage(string));
            } else {
                resourceBundle = this._parent;
                this._parent = null;
            }
            return resourceBundle;
        }

        String validate(String string) throws MissingResourceException {
            if (this._projectName == null || this._projectName.length() == 0) {
                log.debug("Project name not specified");
                throw new MissingResourceException("Project name not specified", "", "");
            }
            if (string == null || string.length() == 0) {
                log.debug("Package name not specified");
                throw new MissingResourceException("Package not specified", string, "");
            }
            if ((string = string.intern()) != this._projectName && !string.startsWith(this._projectName + '.')) {
                log.debug("Project not a prefix of Package");
                throw new MissingResourceException("Project '" + this._projectName + "' must be a prefix of Package '" + string + "'", string + '.' + this._resourceName, "");
            }
            return string;
        }
    }
}

