/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.uow.UOWManager;
import com.ibm.ws.uow.UOWManagerFactory;
import com.ibm.ws.uow.UOWToken;
import com.ibm.ws.webservices.engine.WebServicesFault;

public class TransactionSuspender {
    private UOWToken suspendedUOW = null;
    private boolean usingLocalTran = false;
    private static UOWManager uowMgr;
    private static TraceComponent _tc;

    public static boolean isTxnServiceEnabled() {
        return uowMgr != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendTransaction() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "suspendTransaction");
        }
        try {
            if (TransactionSuspender.isTxnServiceEnabled()) {
                this.suspendedUOW = uowMgr.suspend();
                if (_tc.isDebugEnabled()) {
                    if (this.suspendedUOW != null) {
                        Tr.debug(_tc, "Suspended UOW: " + this.suspendedUOW.toString());
                    } else {
                        Tr.debug(_tc, "No UOW to suspend.");
                    }
                }
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "suspendTransaction");
            }
        }
    }

    public void beginLocalTransaction() throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "beginLocalTransaction");
        }
        try {
            if (TransactionSuspender.isTxnServiceEnabled()) {
                LocalTransactionCurrent localTransactionCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
                if (localTransactionCurrent != null) {
                    localTransactionCurrent.begin(false, false, true);
                    this.usingLocalTran = true;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Started local transaction.");
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "LTC not available.");
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Transactions code is not present.");
            }
        }
        catch (Exception exception) {
            WebServicesFault webServicesFault = WebServicesFault.makeFault("Error while starting local transaction.", exception);
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.transport.TransactionSuspender.beginLocalTransaction", "157", this);
            throw webServicesFault;
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "beginLocalTransaction");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitLocalTransaction() throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "commitLocalTransaction");
        }
        try {
            this.completeLocalTransaction(true);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "commitLocalTransaction");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackLocalTransaction() throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "rollbackLocalTransaction");
        }
        try {
            this.completeLocalTransaction(false);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "rollbackLocalTransaction");
            }
        }
    }

    public void resumeTransaction() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "resumeTransaction");
        }
        if (TransactionSuspender.isTxnServiceEnabled()) {
            try {
                if (_tc.isDebugEnabled()) {
                    if (this.suspendedUOW == null) {
                        Tr.debug(_tc, "No UOW to resume.");
                    } else {
                        Tr.debug(_tc, "About to resume UOW: " + this.suspendedUOW.toString());
                    }
                }
                uowMgr.resume(this.suspendedUOW);
                this.suspendedUOW = null;
            }
            catch (Throwable throwable) {}
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "No Current object present.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "resumeTransaction");
        }
    }

    private void completeLocalTransaction(boolean bl) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "completeLocalTransaction, action=" + (bl ? "commit" : "rollback"));
        }
        try {
            if (TransactionSuspender.isTxnServiceEnabled() && this.usingLocalTran) {
                this.usingLocalTran = false;
                LocalTransactionCurrent localTransactionCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
                if (localTransactionCurrent != null) {
                    localTransactionCurrent.complete(bl ? 0 : 1);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Completed local transaction.");
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "LTC not available.");
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Transactions code is not present.");
            }
        }
        catch (Exception exception) {
            WebServicesFault webServicesFault = WebServicesFault.makeFault("Error while completing local transaction.", exception);
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.transport.TransactionSuspender.commitLocalTransaction", "213", this);
            throw webServicesFault;
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "completeLocalTransaction");
            }
        }
    }

    static {
        block5: {
            uowMgr = null;
            _tc = Tr.register(TransactionSuspender.class, "WebServices", "com.ibm.ws.webservices.engine.resources.engineMessages");
            try {
                uowMgr = UOWManagerFactory.getUOWManager();
                if (_tc.isDebugEnabled()) {
                    if (uowMgr == null) {
                        Tr.debug(_tc, "UOW Manager has not been started.");
                    } else {
                        Tr.debug(_tc, "Obtained UOWManager object.");
                    }
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                uowMgr = null;
                if (!_tc.isDebugEnabled()) break block5;
                Tr.debug(_tc, "Transactions code is not present.");
            }
        }
    }
}

