/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ws.webservices.engine.session.Session;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.xml.rpc.server.ServiceLifecycle;

public class WebServicesHttpSession
implements Session {
    private static final String SESSION_LISTENER_KEY = "com.ibm.ws.webservices.engine.transport.http.WebServicesHttpSession";
    private HttpSession rep;
    private HttpServletRequest req;

    public WebServicesHttpSession(HttpServletRequest httpServletRequest) {
        this.req = httpServletRequest;
    }

    protected void ensureSession() {
        if (this.rep == null) {
            this.rep = this.req.getSession();
            if (this.rep.getAttribute(SESSION_LISTENER_KEY) == null) {
                this.rep.setAttribute(SESSION_LISTENER_KEY, new SessionListener());
            }
        }
    }

    public Object get(String string) {
        this.ensureSession();
        return this.rep.getAttribute(string);
    }

    public void set(String string, Object object) {
        this.ensureSession();
        this.rep.setAttribute(string, object);
    }

    public void remove(String string) {
        this.ensureSession();
        this.rep.removeAttribute(string);
    }

    public Enumeration getKeys() {
        this.ensureSession();
        return this.rep.getAttributeNames();
    }

    public void setTimeout(int n) {
        this.ensureSession();
        this.rep.setMaxInactiveInterval(n);
    }

    public int getTimeout() {
        this.ensureSession();
        return this.rep.getMaxInactiveInterval();
    }

    public void touch() {
    }

    private class SessionListener
    implements HttpSessionBindingListener {
        private SessionListener() {
        }

        public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
            Enumeration enumeration = WebServicesHttpSession.this.getKeys();
            if (enumeration != null) {
                WebServicesHttpSession webServicesHttpSession = WebServicesHttpSession.this;
                synchronized (webServicesHttpSession) {
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Object object = WebServicesHttpSession.this.get(string);
                        if (object == null || !(object instanceof ServiceLifecycle)) continue;
                        ((ServiceLifecycle)object).destroy();
                        WebServicesHttpSession.this.remove(string);
                    }
                }
            }
        }
    }
}

