/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.utils.CLOption;
import com.ibm.ws.webservices.engine.utils.CLOptionDescriptor;
import com.ibm.ws.webservices.engine.utils.ParserControl;
import com.ibm.ws.webservices.engine.utils.Token;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Vector;

public final class CLArgsParser {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_REQUIRE_2ARGS = 1;
    private static final int STATE_REQUIRE_ARG = 2;
    private static final int STATE_OPTIONAL_ARG = 3;
    private static final int STATE_NO_OPTIONS = 4;
    private static final int STATE_OPTION_MODE = 5;
    private static final int TOKEN_SEPARATOR = 0;
    private static final int TOKEN_STRING = 1;
    private static final char[] ARG2_SEPARATORS = new char[]{'\u0000', '=', '-'};
    private static final char[] ARG_SEPARATORS = new char[]{'\u0000', '='};
    private static final char[] NULL_SEPARATORS = new char[]{'\u0000'};
    private final CLOptionDescriptor[] m_optionDescriptors;
    private final Vector m_options;
    private Hashtable m_optionIndex;
    private final ParserControl m_control;
    private String m_errorMessage;
    private String[] m_unparsedArgs = new String[0];
    private char ch;
    private String[] args;
    private boolean isLong;
    private int argIndex;
    private int stringIndex;
    private int stringLength;
    private static final int INVALID = Integer.MAX_VALUE;
    private int m_lastChar = Integer.MAX_VALUE;
    private int m_lastOptionId;
    private CLOption m_option;
    private int m_state = 0;

    public final String[] getUnparsedArgs() {
        return this.m_unparsedArgs;
    }

    public final Vector getArguments() {
        return this.m_options;
    }

    public final CLOption getArgumentById(int n) {
        return (CLOption)this.m_optionIndex.get(new Integer(n));
    }

    public final CLOption getArgumentByName(String string) {
        return (CLOption)this.m_optionIndex.get(string);
    }

    private final CLOptionDescriptor getDescriptorFor(int n) {
        for (int i = 0; i < this.m_optionDescriptors.length; ++i) {
            if (this.m_optionDescriptors[i].getId() != n) continue;
            return this.m_optionDescriptors[i];
        }
        return null;
    }

    private final CLOptionDescriptor getDescriptorFor(String string) {
        for (int i = 0; i < this.m_optionDescriptors.length; ++i) {
            if (!this.m_optionDescriptors[i].getName().equals(string)) continue;
            return this.m_optionDescriptors[i];
        }
        return null;
    }

    public final String getErrorString() {
        return this.m_errorMessage;
    }

    private final int getStateFor(CLOptionDescriptor cLOptionDescriptor) {
        int n = cLOptionDescriptor.getFlags();
        if ((n & 0x10) == 16) {
            return 1;
        }
        if ((n & 2) == 2) {
            return 2;
        }
        if ((n & 4) == 4) {
            return 3;
        }
        return 0;
    }

    public CLArgsParser(String[] stringArray, CLOptionDescriptor[] cLOptionDescriptorArray, ParserControl parserControl) {
        this.m_optionDescriptors = cLOptionDescriptorArray;
        this.m_control = parserControl;
        this.m_options = new Vector();
        this.args = stringArray;
        try {
            this.parse();
            this.checkIncompatibilities(this.m_options);
            this.buildOptionIndex();
        }
        catch (ParseException parseException) {
            FFDCFilter.processException((Throwable)parseException, "com.ibm.ws.webservices.engine.utils.CLArgsParser.CLArgsParser", "220", this);
            this.m_errorMessage = parseException.getMessage();
        }
    }

    private final void checkIncompatibilities(Vector vector) throws ParseException {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            CLOption cLOption = (CLOption)vector.elementAt(i);
            int n2 = cLOption.getId();
            CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(n2);
            if (null == cLOptionDescriptor) continue;
            int[] nArray = cLOptionDescriptor.getIncompatible();
            this.checkIncompatible(vector, nArray, i);
        }
    }

    private final void checkIncompatible(Vector vector, int[] nArray, int n) throws ParseException {
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            if (n == i) continue;
            CLOption cLOption = (CLOption)vector.elementAt(i);
            int n3 = cLOption.getId();
            for (int j = 0; j < nArray.length; ++j) {
                if (n3 != nArray[j]) continue;
                CLOption cLOption2 = (CLOption)vector.elementAt(n);
                int n4 = cLOption2.getId();
                String string = null;
                string = n3 == n4 ? "Duplicate options for " + this.describeDualOption(n4) + " found." : "Incompatible options -" + this.describeDualOption(n3) + " and " + this.describeDualOption(n4) + " found.";
                throw new ParseException(string, 0);
            }
        }
    }

    private final String describeDualOption(int n) {
        String string;
        CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(n);
        if (null == cLOptionDescriptor) {
            return "<parameter>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (Character.isLetter((char)n)) {
            stringBuffer.append('-');
            stringBuffer.append((char)n);
            bl = true;
        }
        if (null != (string = cLOptionDescriptor.getName())) {
            if (bl) {
                stringBuffer.append('/');
            }
            stringBuffer.append("--");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public CLArgsParser(String[] stringArray, CLOptionDescriptor[] cLOptionDescriptorArray) {
        this(stringArray, cLOptionDescriptorArray, null);
    }

    private final String[] subArray(String[] stringArray, int n, int n2) {
        int n3 = stringArray.length - n;
        String[] stringArray2 = new String[n3];
        if (n3 > 1) {
            System.arraycopy(stringArray, n + 1, stringArray2, 1, n3 - 1);
        }
        stringArray2[0] = stringArray[n].substring(n2 - 1);
        return stringArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void parse() throws ParseException {
        if (0 == this.args.length) {
            return;
        }
        this.stringLength = this.args[this.argIndex].length();
        while (true) {
            this.ch = this.peekAtChar();
            if (this.argIndex >= this.args.length) break;
            if (null != this.m_control && this.m_control.isFinished(this.m_lastOptionId)) {
                this.m_unparsedArgs = this.subArray(this.args, this.argIndex, this.stringIndex);
                return;
            }
            if (5 == this.m_state) {
                if ('\u0000' == this.ch) {
                    this.getChar();
                    this.m_state = 0;
                    continue;
                }
                this.parseShortOption();
                continue;
            }
            if (0 == this.m_state) {
                this.parseNormal();
                continue;
            }
            if (4 == this.m_state) {
                this.addOption(new CLOption(this.args[this.argIndex++]));
                continue;
            }
            if (3 == this.m_state && '-' == this.ch) {
                this.m_state = 0;
                this.addOption(this.m_option);
                continue;
            }
            this.parseArguments();
        }
        if (this.m_option == null) return;
        if (3 == this.m_state) {
            this.m_options.addElement(this.m_option);
            return;
        } else {
            if (2 == this.m_state) {
                CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(this.m_option.getId());
                String string = "Missing argument to option " + this.getOptionDescription(cLOptionDescriptor);
                throw new ParseException(string, 0);
            }
            if (1 != this.m_state) throw new ParseException("IllegalState " + this.m_state + ": " + this.m_option, 0);
            if (1 == this.m_option.getArgumentCount()) {
                this.m_option.addArgument("");
                this.m_options.addElement(this.m_option);
                return;
            } else {
                CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(this.m_option.getId());
                String string = "Missing argument to option " + this.getOptionDescription(cLOptionDescriptor);
                throw new ParseException(string, 0);
            }
        }
    }

    private final String getOptionDescription(CLOptionDescriptor cLOptionDescriptor) {
        if (this.isLong) {
            return "--" + cLOptionDescriptor.getName();
        }
        return "-" + (char)cLOptionDescriptor.getId();
    }

    private final char peekAtChar() {
        if (Integer.MAX_VALUE == this.m_lastChar) {
            this.m_lastChar = this.readChar();
        }
        return (char)this.m_lastChar;
    }

    private final char getChar() {
        if (Integer.MAX_VALUE != this.m_lastChar) {
            char c = (char)this.m_lastChar;
            this.m_lastChar = Integer.MAX_VALUE;
            return c;
        }
        return this.readChar();
    }

    private final char readChar() {
        if (this.stringIndex >= this.stringLength) {
            ++this.argIndex;
            this.stringIndex = 0;
            this.stringLength = this.argIndex < this.args.length ? this.args[this.argIndex].length() : 0;
            return '\u0000';
        }
        if (this.argIndex >= this.args.length) {
            return '\u0000';
        }
        return this.args[this.argIndex].charAt(this.stringIndex++);
    }

    private final Token nextToken(char[] cArray) {
        this.ch = this.getChar();
        if (this.isSeparator(this.ch, cArray)) {
            this.ch = this.getChar();
            return new Token(0, null);
        }
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append(this.ch);
            this.ch = this.getChar();
        } while (!this.isSeparator(this.ch, cArray));
        return new Token(1, stringBuffer.toString());
    }

    private final boolean isSeparator(char c, char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            return true;
        }
        return false;
    }

    private final void addOption(CLOption cLOption) {
        this.m_options.addElement(cLOption);
        this.m_lastOptionId = cLOption.getId();
        this.m_option = null;
    }

    private final void parseOption(CLOptionDescriptor cLOptionDescriptor, String string) throws ParseException {
        if (null == cLOptionDescriptor) {
            throw new ParseException("Unknown option " + string, 0);
        }
        this.m_state = this.getStateFor(cLOptionDescriptor);
        this.m_option = new CLOption(cLOptionDescriptor.getId());
        if (0 == this.m_state) {
            this.addOption(this.m_option);
        }
    }

    private final void parseShortOption() throws ParseException {
        this.ch = this.getChar();
        CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(this.ch);
        this.isLong = false;
        this.parseOption(cLOptionDescriptor, "-" + this.ch);
        if (0 == this.m_state) {
            this.m_state = 5;
        }
    }

    private final void parseArguments() throws ParseException {
        if (2 == this.m_state) {
            if ('=' == this.ch || '\u0000' == this.ch) {
                this.getChar();
            }
            Token token = this.nextToken(NULL_SEPARATORS);
            this.m_option.addArgument(token.getValue());
            this.addOption(this.m_option);
            this.m_state = 0;
        } else if (3 == this.m_state) {
            if ('-' == this.ch || '\u0000' == this.ch) {
                this.getChar();
                this.addOption(this.m_option);
                this.m_state = 0;
                return;
            }
            if ('=' == this.ch) {
                this.getChar();
            }
            Token token = this.nextToken(NULL_SEPARATORS);
            this.m_option.addArgument(token.getValue());
            this.addOption(this.m_option);
            this.m_state = 0;
        } else if (1 == this.m_state) {
            if (0 == this.m_option.getArgumentCount()) {
                Token token;
                if ('=' == this.ch || '\u0000' == this.ch) {
                    this.getChar();
                }
                if (0 == (token = this.nextToken(ARG_SEPARATORS)).getType()) {
                    CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(this.m_option.getId());
                    String string = "Unable to parse first argument for option " + this.getOptionDescription(cLOptionDescriptor);
                    throw new ParseException(string, 0);
                }
                this.m_option.addArgument(token.getValue());
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                this.ch = this.getChar();
                if ('-' == this.ch) {
                    this.m_lastChar = this.ch;
                }
                while (!this.isSeparator(this.ch, ARG2_SEPARATORS)) {
                    stringBuffer.append(this.ch);
                    this.ch = this.getChar();
                }
                String string = stringBuffer.toString();
                this.m_option.addArgument(string);
                this.addOption(this.m_option);
                this.m_option = null;
                this.m_state = 0;
            }
        }
    }

    private final void parseNormal() throws ParseException {
        if ('-' != this.ch) {
            String string = this.nextToken(NULL_SEPARATORS).getValue();
            this.addOption(new CLOption(string));
            this.m_state = 0;
        } else {
            this.getChar();
            if ('\u0000' == this.peekAtChar()) {
                throw new ParseException("Malformed option -", 0);
            }
            this.ch = this.peekAtChar();
            if ('-' != this.ch) {
                this.parseShortOption();
            } else {
                this.getChar();
                if ('\u0000' == this.peekAtChar()) {
                    this.getChar();
                    this.m_state = 4;
                } else {
                    String string = this.nextToken(ARG_SEPARATORS).getValue();
                    CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(string);
                    this.isLong = true;
                    this.parseOption(cLOptionDescriptor, "--" + string);
                }
            }
        }
    }

    private final void buildOptionIndex() {
        this.m_optionIndex = new Hashtable(this.m_options.size() * 2);
        for (int i = 0; i < this.m_options.size(); ++i) {
            CLOption cLOption = (CLOption)this.m_options.get(i);
            CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(cLOption.getId());
            this.m_optionIndex.put(new Integer(cLOption.getId()), cLOption);
            if (null == cLOptionDescriptor) continue;
            this.m_optionIndex.put(cLOptionDescriptor.getName(), cLOption);
        }
    }
}

