/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class Namespaces
extends HashMap {
    private String root;
    private static final char[] pkgSeparators = new char[]{'.', ':', '\\', '/'};
    private static final char javaPkgSeparator = pkgSeparators[0];
    private char separatorChar;

    private static String normalizePackageName(String string, char c) {
        if (string == null || string == "") {
            return string;
        }
        for (int i = 0; i < pkgSeparators.length; ++i) {
            string = string.replace(pkgSeparators[i], c);
        }
        return string;
    }

    public Namespaces(String string, char c) {
        this.root = string;
        this.separatorChar = c;
    }

    protected Namespaces(Namespaces namespaces) {
        super(namespaces);
        this.root = namespaces.root;
        this.separatorChar = namespaces.separatorChar;
    }

    public Object clone() {
        return new Namespaces(this);
    }

    public String getCreate(String string) {
        String string2 = (String)super.get(string);
        if (string2 == null) {
            string2 = Namespaces.normalizePackageName(JavaUtils.makePackageName(string), javaPkgSeparator);
            this.put(string, string2);
        }
        return string2;
    }

    public String getAsDir(String string) {
        String string2 = (String)this.get(string);
        return this.toDir(string2);
    }

    public String toDir(String string) {
        String string2 = null;
        string = string != null ? Namespaces.normalizePackageName(string, this.separatorChar) : "";
        string2 = this.root == null ? string : this.root + this.separatorChar + string;
        if (string2 == null || string2.length() == 0) {
            string2 = ".";
        }
        if (!string2.endsWith("" + this.separatorChar)) {
            string2 = string2 + this.separatorChar;
        }
        return string2;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            String string = (String)entry.getValue();
            string = this.javify(string);
            this.put(k, string);
        }
    }

    private String javify(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        string = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (JavaUtils.isJavaKeyword(string2)) {
                string2 = JavaUtils.makeNonJavaKeyword(string2);
            }
            string = string + string2;
            if (!stringTokenizer.hasMoreTokens()) continue;
            string = string + '.';
        }
        return string;
    }
}

