/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.ext;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.BaseDesc;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.builders.RequestResponseProcessor;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class RequestResponse {
    protected static Log log = LogFactory.getLog(RequestResponse.class.getName());
    protected Vector params = new Vector();
    protected boolean needDeser = false;
    OperationDesc[] tryOperations = null;
    OperationDesc operation = null;
    DeserializationContext context = null;
    SOAPBody body;
    boolean isResponse;
    QName operationQName = null;
    boolean legacyTestMode = false;
    boolean inDeserialize = false;

    public RequestResponse(String string, String string2, SOAPBody sOAPBody, boolean bl, OperationDesc[] operationDescArray, DeserializationContext deserializationContext) throws SOAPException {
        this.body = sOAPBody;
        this.isResponse = bl;
        this.tryOperations = operationDescArray;
        if (operationDescArray != null && operationDescArray.length == 1) {
            this.operation = operationDescArray[0];
        }
        this.context = deserializationContext;
        this.operationQName = QNameTable.createQName(string, string2);
        this.needDeser = true;
        if (sOAPBody != null) {
            sOAPBody.setAlternateContent(this);
        }
    }

    public RequestResponse(String string, String string2, SOAPBody sOAPBody, boolean bl) throws SOAPException {
        this.body = sOAPBody;
        this.isResponse = bl;
        this.operationQName = QNameTable.createQName(string, string2);
        if (sOAPBody != null) {
            sOAPBody.setAlternateContent(this);
        }
    }

    public SOAPBody getBody() {
        return this.body;
    }

    public void attachToBody(SOAPBody sOAPBody) throws SOAPException {
        this.body = sOAPBody;
        if (sOAPBody != null) {
            sOAPBody.setAlternateContent(this);
        }
    }

    public QName getQName() {
        return this.operationQName;
    }

    public OperationDesc getOperation() throws SAXException {
        if (this.needDeser && !this.inDeserialize) {
            this.deserialize(this.context);
        }
        return this.operation;
    }

    public void addParams(Object[] objectArray) {
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            if (objectArray[i] instanceof ParamValue) {
                this.addParam((ParamValue)objectArray[i]);
                continue;
            }
            String string = null;
            if (string == null) {
                string = "arg" + i;
            }
            this.addParam(new ParamValue("", string, objectArray[i]));
        }
    }

    public void setNeedDeser(boolean bl) {
        this.needDeser = bl;
    }

    public boolean hasDeserializedParams() {
        return !this.needDeser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deserialize(DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("RequestResponse: deserialize() starting");
        }
        this.inDeserialize = true;
        boolean bl = this.body.getSOAPFactory().getProtectState();
        this.body.getSOAPFactory().setProtectState(false);
        this.params.clear();
        MessageContext messageContext = deserializationContext.getMessageContext();
        Message message = messageContext.getCurrentMessage();
        RequestResponseProcessor requestResponseProcessor = new RequestResponseProcessor(this, this.isResponse);
        this.operation = this._resolveOperation(messageContext, message);
        if (this.operation != null) {
            messageContext.setOperation(this.operation);
        }
        if (this.tryOperations != null) {
            SAXException sAXException = null;
            if (this.tryOperations.length > 1) {
                requestResponseProcessor.setEnableSecondaryLookup(false);
            }
            for (int i = 0; i < this.tryOperations.length; ++i) {
                this.operation = this.tryOperations[i];
                messageContext.setOperation(this.operation);
                boolean bl2 = RequestResponse.isNoDataBindingOperation(this.operation);
                if (log.isDebugEnabled()) {
                    log.debug("RequestResponse: deserialize() trying to deserialize with \n" + this.operation.toString());
                }
                requestResponseProcessor.setOperation(this.operation);
                try {
                    SOAPElement sOAPElement;
                    deserializationContext.createEventConverter(new WrapperProcessor(requestResponseProcessor));
                    if (this.operation.getStyle() == Style.DOCUMENT) {
                        sOAPElement = this.body;
                    } else {
                        sOAPElement = this.body.getChildElement(0);
                        Iterator iterator = this.body.getChildElements();
                        while (iterator.hasNext()) {
                            SOAPElement sOAPElement2;
                            String string;
                            Node node = (Node)iterator.next();
                            if (!(node instanceof SOAPElement) || (string = AttributeUtils.getID((sOAPElement2 = (SOAPElement)node).getSAXAttributes())) == null) continue;
                            deserializationContext.getHrefTable().addObjectByID(string, sOAPElement2);
                        }
                    }
                    try {
                        if (bl2) {
                            requestResponseProcessor.processNoDataBinding(sOAPElement, deserializationContext);
                        } else {
                            sOAPElement.toEvents(deserializationContext.getEventConverter());
                        }
                    }
                    catch (Exception exception) {
                        throw MCUtils.interceptDeserializationException(exception, deserializationContext);
                    }
                    this.updateQName();
                    this.needDeser = false;
                    if (log.isDebugEnabled()) {
                        log.debug("RequestResponse: deserialize() ending");
                    }
                    return;
                }
                catch (SAXException sAXException2) {
                    if (log.isDebugEnabled()) {
                        log.debug("RequestResponse: deserialize() deserialize failed with \n" + sAXException2.toString());
                    }
                    if (sAXException == null) {
                        sAXException = sAXException2;
                    }
                    this.params.clear();
                    messageContext.setOperation(null);
                    continue;
                }
                finally {
                    deserializationContext.freeEventConverter();
                }
            }
            if (sAXException != null) {
                throw sAXException;
            }
            if (!messageContext.isClient()) {
                this.throwResolutionError(this.body, messageContext);
            } else {
                requestResponseProcessor.setOperation(this.tryOperations[0]);
                this.operation = this.tryOperations[0];
                this.updateQName();
            }
        } else if (this.legacyTestMode) {
            SOAPElement sOAPElement;
            requestResponseProcessor.setLegacyTestMode(this.legacyTestMode);
            if (this.tryOperations != null && this.tryOperations.length > 0 && this.operation.getStyle() == Style.DOCUMENT) {
                sOAPElement = this.body;
            } else {
                sOAPElement = this.body.getChildElement(0);
                Iterator iterator = this.body.getChildElements();
                while (iterator.hasNext()) {
                    SOAPElement sOAPElement3;
                    String string;
                    Node node = (Node)iterator.next();
                    if (!(node instanceof SOAPElement) || (string = AttributeUtils.getID((sOAPElement3 = (SOAPElement)node).getSAXAttributes())) == null) continue;
                    deserializationContext.getHrefTable().addObjectByID(string, sOAPElement3);
                }
            }
            try {
                deserializationContext.createEventConverter(new WrapperProcessor(requestResponseProcessor));
                sOAPElement.toEvents(deserializationContext.getEventConverter());
            }
            finally {
                deserializationContext.freeEventConverter();
            }
            this.body.getSOAPFactory().setProtectState(bl);
            this.needDeser = false;
            this.inDeserialize = false;
            if (log.isDebugEnabled()) {
                log.debug("RequestResponse: deserialize() ending");
            }
        }
    }

    private void updateQName() {
        if (this.operation != null && !this.isResponse && this.operation.getStyle() == Style.DOCUMENT) {
            this.operationQName = this.operation.getElementQName();
        }
    }

    public ParamValue getParam(String string) throws SAXException {
        if (this.needDeser && !this.inDeserialize) {
            this.deserialize(this.context);
        }
        for (int i = 0; i < this.params.size(); ++i) {
            ParamValue paramValue = (ParamValue)this.params.elementAt(i);
            if (!paramValue.getName().equals(string)) continue;
            return paramValue;
        }
        return null;
    }

    public Vector getParams() throws SAXException {
        if (this.needDeser && !this.inDeserialize) {
            this.deserialize(this.context);
        }
        return this.params;
    }

    public void addParam(ParamValue paramValue) {
        if (paramValue != null) {
            this.params.addElement(paramValue);
        }
    }

    public void outputImpl(SerializationContext serializationContext) throws Exception {
        boolean bl;
        String string = this.body.getEncodingStyle();
        MessageContext messageContext = serializationContext.getMessageContext();
        boolean bl2 = bl = messageContext == null || messageContext.getOperationStyleString().equals("rpc") || messageContext.getOperationStyleString().equals("wrapped");
        if (bl) {
            serializationContext.getSerializationWriter().startElement(this.operationQName, NullAttributes.singleton);
        }
        for (int i = 0; i < this.params.size(); ++i) {
            ParamValue paramValue = (ParamValue)this.params.elementAt(i);
            ParameterDesc parameterDesc = paramValue.getParamDesc();
            if (parameterDesc != null && (!this.isResponse || parameterDesc.isOutHeader()) && (this.isResponse || parameterDesc.isInHeader())) continue;
            paramValue.serialize(serializationContext, this);
        }
        if (bl) {
            serializationContext.getSerializationWriter().endElement();
        }
    }

    private void pruneDocLitOperations(Message message, MessageContext messageContext) throws SAXException {
        BaseDesc baseDesc;
        int n;
        OperationDesc operationDesc;
        Serializable serializable;
        if (this.isResponse || this.tryOperations.length <= 1 || this.tryOperations[0].getStyle() != Style.DOCUMENT || this.tryOperations[0].getUse() != Use.LITERAL) {
            return;
        }
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        for (Node node = this.body.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof SOAPElement) || arrayList.contains(serializable = ((SOAPElement)node).getQName())) continue;
            arrayList.add(serializable);
        }
        serializable = new ArrayList();
        for (int i = 0; i < this.tryOperations.length; ++i) {
            int n2;
            operationDesc = this.tryOperations[i];
            n = 1;
            baseDesc = null;
            for (n2 = 0; n2 < arrayList.size() && n != 0; ++n2) {
                QName qName = (QName)arrayList.get(n2);
                ParameterDesc parameterDesc = operationDesc.getInputParamByQName(qName);
                if (parameterDesc == null || parameterDesc.isInHeader()) {
                    n = 0;
                    continue;
                }
                if (baseDesc != null && ((ParameterDesc)baseDesc).getOrder() > parameterDesc.getOrder()) {
                    n = 0;
                    continue;
                }
                baseDesc = parameterDesc;
            }
            if (n != 0) {
                for (n2 = 0; n2 < ((ArrayList)serializable).size() && ((OperationDesc)((ArrayList)serializable).get(n2)).getNumInParams(true) < operationDesc.getNumInParams(true); ++n2) {
                }
                ((ArrayList)serializable).add(n2, operationDesc);
                if (!log.isDebugEnabled()) continue;
                log.debug("RequestResponse: pruneDocLitOperations() saving for consideration " + operationDesc.getName());
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("RequestResponse: pruneDocLitOperations() removing from consideration " + operationDesc.getName());
        }
        if (((ArrayList)serializable).size() == 0) {
            this.throwResolutionError(this.body, messageContext);
        }
        if (((ArrayList)serializable).size() > 1 && ((OperationDesc)((ArrayList)serializable).get(0)).getNumInParams(true) == ((OperationDesc)((ArrayList)serializable).get(1)).getNumInParams(true)) {
            ArrayList<QName> arrayList2 = new ArrayList<QName>();
            operationDesc = (OperationDesc)((ArrayList)serializable).get(0);
            arrayList2.add(operationDesc.getElementQName());
            for (n = 1; n < ((ArrayList)serializable).size(); ++n) {
                baseDesc = (OperationDesc)((ArrayList)serializable).get(n);
                if (((OperationDesc)baseDesc).getNumInParams(true) != operationDesc.getNumInParams(true)) continue;
                arrayList2.add(((OperationDesc)baseDesc).getElementQName());
            }
            this.throwAmbiguousError(arrayList, arrayList2, messageContext);
        }
        this.tryOperations = new OperationDesc[1];
        this.tryOperations[0] = (OperationDesc)((ArrayList)serializable).get(0);
    }

    private ArrayList getAttachments(Message message) {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        Iterator iterator = message.getAttachments();
        while (iterator.hasNext()) {
            AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
            String string = attachmentPart.getContentIdPartName();
            arrayList.add(new QName("", string));
        }
        return arrayList;
    }

    public static boolean isNoDataBindingOperation(OperationDesc operationDesc) {
        if (operationDesc.getUse() != Use.LITERAL) {
            return false;
        }
        if (operationDesc.getStyle() != Style.RPC && operationDesc.getStyle() != Style.DOCUMENT) {
            return false;
        }
        ParameterDesc parameterDesc = operationDesc.getReturnParamDesc();
        if (parameterDesc == null || parameterDesc.getJavaType() == null || !parameterDesc.getJavaType().equals(javax.xml.soap.SOAPElement.class) && !parameterDesc.getJavaType().equals(Void.TYPE)) {
            return false;
        }
        for (int i = 0; i < operationDesc.getNumParams(); ++i) {
            parameterDesc = operationDesc.getParameter(i);
            if (parameterDesc.getJavaType() != null && parameterDesc.getJavaType().equals(class$javax$xml$soap$SOAPElement == null ? RequestResponse.class$("javax.xml.soap.SOAPElement") : class$javax$xml$soap$SOAPElement)) continue;
            return false;
        }
        return true;
    }

    public static OperationDesc[] getPossibleOperationsByQName(QName qName, MessageContext messageContext) throws WebServicesFault {
        OperationDesc[] operationDescArray = null;
        SOAPPort sOAPPort = messageContext.getPort();
        if (sOAPPort == null) {
            try {
                if (qName != null) {
                    messageContext.setPort(messageContext.getEngine().getPortByNamespaceURI(qName.getNamespaceURI()));
                }
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException(webServicesFault, "com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse", "710");
            }
        }
        if (sOAPPort != null) {
            sOAPPort.getInitializedPortDesc(messageContext);
            PortDesc portDesc = sOAPPort.getPortDesc();
            if (portDesc != null) {
                Serializable serializable;
                ArrayList arrayList = portDesc.getOperations();
                ArrayList<OperationDesc> arrayList2 = null;
                boolean bl = false;
                for (int i = 0; i < arrayList.size(); ++i) {
                    serializable = (OperationDesc)arrayList.get(i);
                    if (((OperationDesc)serializable).getStyle() == Style.DOCUMENT) {
                        if ((qName != null || ((OperationDesc)serializable).getNumInParams(true) != 0) && (qName == null || ((OperationDesc)serializable).getParamByQName(qName) == null)) continue;
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<OperationDesc>();
                        }
                        arrayList2.add((OperationDesc)serializable);
                        continue;
                    }
                    bl = true;
                }
                if (bl && qName != null) {
                    operationDescArray = portDesc.getOperationsByQName(qName);
                }
                if (arrayList2 != null && arrayList2.size() > 0) {
                    OperationDesc[] operationDescArray2 = new OperationDesc[arrayList2.size()];
                    operationDescArray2 = arrayList2.toArray(operationDescArray2);
                    if (operationDescArray != null) {
                        OperationDesc operationDesc;
                        int n;
                        serializable = new ArrayList();
                        for (n = 0; n < operationDescArray.length; ++n) {
                            operationDesc = operationDescArray[n];
                            if (((ArrayList)serializable).contains(operationDesc)) continue;
                            ((ArrayList)serializable).add(operationDesc);
                        }
                        for (n = 0; n < operationDescArray2.length; ++n) {
                            operationDesc = operationDescArray2[n];
                            if (((ArrayList)serializable).contains(operationDesc)) continue;
                            ((ArrayList)serializable).add(operationDesc);
                        }
                        operationDescArray = ((ArrayList)serializable).toArray(operationDescArray);
                    } else {
                        operationDescArray = operationDescArray2;
                    }
                }
            }
        }
        return operationDescArray;
    }

    private void throwResolutionError(SOAPBody sOAPBody, MessageContext messageContext) throws SAXException {
        QName qName = null;
        if (sOAPBody.getNumChildren() > 0) {
            qName = sOAPBody.getChildElement(0).getQName();
        }
        PortDesc portDesc = messageContext != null ? messageContext.getPortDesc() : null;
        String string = qName == null ? "<no element in body>" : qName.toString();
        String string2 = portDesc == null ? "null portDesc" : portDesc.toString();
        String string3 = "";
        String string4 = "";
        if (portDesc != null) {
            Object object;
            ArrayList arrayList = portDesc.getOperations();
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (OperationDesc)arrayList.get(i);
                if (((OperationDesc)object).getStyle() != Style.DOCUMENT) {
                    if ((qName != null || ((OperationDesc)object).getNumInParams(true) != 0) && (qName == null || ((OperationDesc)object).getParamByQName(qName) == null)) continue;
                    string3 = string3 + " " + ((OperationDesc)object).getElementQName();
                    continue;
                }
                if (qName == null || !((OperationDesc)object).getElementQName().getLocalPart().equals(qName.getLocalPart())) continue;
                string4 = string4 + " " + ((OperationDesc)object).getElementQName();
            }
            String string5 = null;
            object = null;
            String string6 = null;
            if (string3.length() > 0 || string4.length() > 0) {
                if (string3.length() > 0) {
                    string5 = string3;
                    object = "document";
                    string6 = "rpc or wrapped document";
                } else {
                    string5 = string4;
                    object = "rpc or wrapped document";
                    string6 = "document";
                }
                throw new SAXException(new WebServicesFault(QNameTable.createQName(messageContext.getSOAPConstants().getEnvelopeURI(), "Client"), Messages.getMessage("noSuchOperation2", string, string5, (String)object, string6, string2), null, null));
            }
        }
        throw new SAXException(new WebServicesFault(QNameTable.createQName(messageContext.getSOAPConstants().getEnvelopeURI(), "Client"), Messages.getMessage("noSuchOperation", string, string2), null, null));
    }

    private void throwAmbiguousError(List list, List list2, MessageContext messageContext) throws SAXException {
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            string = string + list.get(i).toString() + " ";
        }
        String string2 = "";
        for (int i = 0; i < list2.size(); ++i) {
            string2 = string2 + list2.get(i).toString() + " ";
        }
        PortDesc portDesc = messageContext != null ? messageContext.getPortDesc() : null;
        String string3 = portDesc == null ? "null portDesc" : portDesc.toString();
        throw new SAXException(Messages.getMessage("ambiguousOperation00", string, string2, string3));
    }

    public OperationDesc resolveOperation(MessageContext messageContext, Message message) {
        try {
            return this._resolveOperation(messageContext, message);
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug("resolveOperation caught exception : " + exception);
            }
            this.tryOperations = null;
            this.operation = null;
            this.operationQName = null;
            return null;
        }
    }

    private OperationDesc _resolveOperation(MessageContext messageContext, Message message) throws SAXException {
        Serializable serializable;
        if (log.isDebugEnabled()) {
            log.debug("start _resolveOperation");
        }
        if (this.operation != null) {
            if (log.isDebugEnabled()) {
                log.debug("end _resolveOperation: " + this.operation.toString());
            }
            return this.operation;
        }
        if (this.tryOperations == null || this.tryOperations.length == 0) {
            this.operationQName = null;
            if (this.body.getNumChildren() > 0) {
                this.operationQName = this.body.getChildElement(0).getQName();
            }
            if (this.operationQName == null && message != null && (serializable = this.getAttachments(message)) != null && serializable.size() > 0) {
                this.operationQName = (QName)serializable.get(0);
            }
            try {
                if (log.isDebugEnabled()) {
                    if (this.operationQName == null) {
                        log.debug("call getPossibleOperationsByQName with a null QName");
                    } else {
                        log.debug("call getPossibleOperationsByQName with: " + this.operationQName.toString());
                    }
                }
                this.tryOperations = RequestResponse.getPossibleOperationsByQName(this.operationQName, messageContext);
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException(webServicesFault, "com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse", "972");
                if (log.isDebugEnabled()) {
                    log.debug("ERROR with getPossibleOperationsByQName " + webServicesFault.toString());
                    log.debug("end _resolveOperation: null");
                }
                this.tryOperations = null;
                return null;
            }
        }
        if (this.tryOperations == null || this.tryOperations.length == 0) {
            serializable = messageContext.getPortDesc();
            if (serializable != null) {
                this.throwResolutionError(this.body, messageContext);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("RequestResponse: No OperationDesc and No PortDesc.  This is an UNSUPPORTED.");
                }
                this.legacyTestMode = true;
            }
        }
        if (this.tryOperations != null) {
            if (log.isDebugEnabled()) {
                log.debug("RequestResponse: deserialize() there are " + this.tryOperations.length + " to try before prune.");
            }
            this.pruneDocLitOperations(message, messageContext);
            if (log.isDebugEnabled()) {
                log.debug("RequestResponse: deserialize() there are " + this.tryOperations.length + " to try after prune.");
            }
        }
        if (this.tryOperations != null && this.tryOperations.length == 1) {
            this.operation = this.tryOperations[0];
            if (log.isDebugEnabled()) {
                log.debug("end _resolveOperation: " + this.operation.toString());
            }
            return this.operation;
        }
        if (log.isDebugEnabled()) {
            log.debug("end _resolveOperation: null");
        }
        return null;
    }
}

