/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol;

import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.sdo.SDOConvertor;
import com.ibm.ws.webservices.multiprotocol.sdo.SDOConvertorException;
import com.ibm.ws.webservices.multiprotocol.sdo.SDOConvertorFactory;
import commonj.sdo.DataGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;

public class InvocationContext {
    private ServiceContext serviceContext = null;
    private Class generatedStubClass;
    private String endpoint;
    private String initialEndpoint;
    private Class seiClass;
    private String portName;
    private QName operationName;
    private String inputMessageName;
    private boolean oneWay;
    private boolean pastPivot;
    private Class[] inputParameterTypes;
    private Object[] inputParams;
    private Object[] outputParams;
    private HashMap properties = new HashMap();
    private List requestPropertyNames;
    private DataGraph inputDataGraph;
    private DataGraph outputDataGraph;
    private SDOConvertor sdoConvertor;
    private String sdoPortName;
    private boolean protocolOverridden;
    private Boolean wsdlOperationOneWay;

    public InvocationContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext != null ? serviceContext : new ServiceContext(null, null, null);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("InvocationContext: [seiClass=");
        stringBuffer.append(this.seiClass != null ? this.seiClass.getName() : "<none>");
        stringBuffer.append(", generatedStubClass=");
        stringBuffer.append(this.generatedStubClass != null ? this.generatedStubClass.getName() : "<none>");
        stringBuffer.append(", endpoint=");
        stringBuffer.append(this.endpoint != null ? this.endpoint : "<none>");
        stringBuffer.append(", portName=");
        stringBuffer.append(this.portName != null ? this.portName.toString() : "<null>");
        stringBuffer.append(", operationName=");
        stringBuffer.append(this.operationName != null ? this.operationName.toString() : "<none>");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void setServiceContext(ServiceContext serviceContext) {
        if (serviceContext != null) {
            this.serviceContext = serviceContext;
        }
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public Class getGeneratedStubClass() {
        return this.generatedStubClass;
    }

    public void setGeneratedStubClass(Class clazz) {
        this.generatedStubClass = clazz;
    }

    public boolean isUsingGeneratedStub() {
        return this.generatedStubClass != null;
    }

    public void setArgClasses(Class[] classArray) {
        this.inputParameterTypes = classArray;
    }

    public String getInputMessageName() {
        if (this.inputMessageName == null && this.inputDataGraph != null) {
            this.getInputParams();
        }
        return this.inputMessageName;
    }

    public String getPortName() {
        return this.portName;
    }

    public Port getPort() {
        String string = this.getPortName();
        return this.serviceContext.getPortForQName(this.serviceContext.getPortQName(string));
    }

    public Class getSeiClass() {
        return this.seiClass;
    }

    public void setInputMessageName(String string) {
        this.inputMessageName = string;
    }

    public void setPortName(String string) {
        this.portName = string;
    }

    public void setSeiClass(Class clazz) {
        this.seiClass = clazz;
    }

    public String getEndpoint() {
        Map map;
        if (this.endpoint == null && (map = this.serviceContext.getOverriddingEndpointURIs()) != null) {
            this.endpoint = (String)map.get(this.portName);
        }
        return this.endpoint;
    }

    public void setEndpoint(String string) {
        if (this.endpoint == null) {
            this.setInitialEndpoint(string);
        }
        this.endpoint = string;
    }

    protected Class[] getInputParameterTypes(QName qName, int n) {
        if (this.inputParameterTypes != null) {
            return this.inputParameterTypes;
        }
        OperationDesc[] operationDescArray = this.getOperationDescs(qName);
        if (operationDescArray == null) {
            return null;
        }
        ArrayList<OperationDesc> arrayList = new ArrayList<OperationDesc>();
        for (int i = 0; i < operationDescArray.length; ++i) {
            OperationDesc operationDesc = operationDescArray[i];
            if (operationDesc.getNumInParams() != n) continue;
            arrayList.add(operationDesc);
        }
        ArrayList arrayList2 = new ArrayList();
        boolean bl = false;
        if (arrayList.size() > 1 && this.inputParams == null) {
            return null;
        }
        block1: for (int i = 0; i < arrayList.size(); ++i) {
            OperationDesc operationDesc = (OperationDesc)arrayList.get(i);
            ArrayList arrayList3 = operationDesc.getParameters();
            ArrayList<Class> arrayList4 = new ArrayList<Class>();
            Iterator iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                Object object;
                ParameterDesc parameterDesc = (ParameterDesc)iterator.next();
                if (parameterDesc.getMode() == 2) continue;
                Class clazz = parameterDesc.getJavaType();
                if (arrayList.size() != 1 && this.inputParams != null && (object = this.inputParams[arrayList4.size()]) != null) {
                    Class<?> clazz2 = object.getClass();
                    if (!this.isAParamMatch(clazz, object)) continue block1;
                }
                arrayList4.add(clazz);
            }
            if (arrayList4.size() != n) continue;
            arrayList2 = arrayList4;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        this.inputParameterTypes = arrayList2.toArray(new Class[arrayList2.size()]);
        return this.inputParameterTypes;
    }

    private boolean isAParamMatch(Class clazz, Object object) {
        if (clazz.isPrimitive()) {
            if (clazz.getName() == "int" && object instanceof Integer) {
                return true;
            }
            if (clazz.getName() == "long" && object instanceof Long) {
                return true;
            }
            if (clazz.getName() == "boolean" && object instanceof Boolean) {
                return true;
            }
            if (clazz.getName() == "char" && object instanceof Character) {
                return true;
            }
            if (clazz.getName() == "byte" && object instanceof Byte) {
                return true;
            }
            if (clazz.getName() == "float" && object instanceof Float) {
                return true;
            }
            if (clazz.getName() == "double" && object instanceof Double) {
                return true;
            }
            if (clazz.getName() == "short" && object instanceof Short) {
                return true;
            }
        }
        return clazz.isAssignableFrom(object.getClass());
    }

    public QName[] getInputParameterNames(QName qName, int n) {
        OperationDesc[] operationDescArray = this.getOperationDescs(qName);
        if (operationDescArray == null) {
            return null;
        }
        ArrayList<QName> arrayList = new ArrayList<QName>();
        boolean bl = false;
        for (int i = 0; i < operationDescArray.length; ++i) {
            OperationDesc operationDesc = operationDescArray[i];
            if (operationDesc.getNumInParams() != n) continue;
            ArrayList arrayList2 = operationDesc.getParameters();
            if (bl) {
                return null;
            }
            bl = true;
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                ParameterDesc parameterDesc = (ParameterDesc)iterator.next();
                if (parameterDesc.getMode() == 2) continue;
                QName qName2 = parameterDesc.getQName();
                arrayList.add(qName2);
            }
        }
        return arrayList.toArray(new QName[arrayList.size()]);
    }

    public Class getReturnType() {
        QName qName = this.getOperationName();
        Object[] objectArray = this.getInputParams();
        int n = 0;
        if (objectArray != null) {
            n = objectArray.length;
        }
        Class clazz = this.getReturnType(qName, n);
        return clazz;
    }

    public Class getReturnType(QName qName, int n) {
        OperationDesc[] operationDescArray = this.getOperationDescs(qName);
        if (operationDescArray == null) {
            return null;
        }
        Class clazz = null;
        boolean bl = false;
        for (int i = 0; i < operationDescArray.length; ++i) {
            OperationDesc operationDesc = operationDescArray[i];
            if (operationDesc.getNumInParams() != n) continue;
            if (bl) {
                return null;
            }
            bl = true;
            clazz = operationDesc.getReturnClass();
        }
        return clazz;
    }

    protected OperationDesc[] getOperationDescs(QName qName) {
        if (qName == null || this.portName == null) {
            return null;
        }
        String string = qName.getLocalPart();
        if (string == null) {
            return null;
        }
        List list = this.serviceContext.getOperationDescriptions(this.portName, string);
        if (list == null) {
            return null;
        }
        return list.toArray(new OperationDesc[list.size()]);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
        if ("com.ibm.websphere.webservices.protocolNamespace".equals(string)) {
            this.setProtocolOverridden(false);
        }
    }

    public void removeProperty(String string) {
        this.properties.remove(string);
    }

    public boolean isPropertiesSet(String string) {
        return this.properties.keySet().contains(string);
    }

    public List getPropertyNames() {
        return new ArrayList(this.properties.keySet());
    }

    public List getRequestPropertyNames() {
        return this.requestPropertyNames;
    }

    public void setRequestPropertyNames(List list) {
        this.requestPropertyNames = list;
    }

    public QName getOperationName() {
        if (this.operationName == null && this.inputDataGraph != null) {
            this.getInputParams();
        }
        return this.operationName;
    }

    public void setOperationName(QName qName) {
        if (qName != null || !qName.equals(this.operationName)) {
            this.wsdlOperationOneWay = null;
        }
        this.operationName = qName;
    }

    public Object[] getInputParams() {
        if (this.inputParams == null && this.inputDataGraph != null) {
            SDOConvertor sDOConvertor = this.getSDOConvertor();
            sDOConvertor.setDataGraph(this.inputDataGraph);
            try {
                this.inputParams = sDOConvertor.getParameterValues();
                this.setInputParameterTypes(sDOConvertor.getParameterTypes());
                this.setOperationName(new QName(sDOConvertor.getOperationName()));
                this.setInputMessageName(sDOConvertor.getMessageName());
            }
            catch (SDOConvertorException sDOConvertorException) {
                throw new JAXRPCException("exception getting input parameters: " + sDOConvertorException, sDOConvertorException);
            }
        }
        return this.inputParams;
    }

    public Object[] getOutputParams() {
        if (this.outputParams == null && this.outputDataGraph != null) {
            SDOConvertor sDOConvertor = this.getSDOConvertor();
            sDOConvertor.setDataGraph(this.outputDataGraph);
            try {
                this.outputParams = sDOConvertor.getParameterValues();
            }
            catch (SDOConvertorException sDOConvertorException) {
                throw new JAXRPCException("exception getting output parameters: " + sDOConvertorException, sDOConvertorException);
            }
        }
        return this.outputParams;
    }

    public Object getOutputObject() {
        Object[] objectArray = this.getOutputParams();
        Object object = objectArray.length > 0 ? objectArray[0] : null;
        return object;
    }

    public void setInputParams(Object[] objectArray) {
        this.inputParams = objectArray;
    }

    public void setOutputParams(Object[] objectArray) {
        this.outputParams = objectArray;
    }

    public boolean isOneWay() {
        if (this.wsdlOperationOneWay == null && this.serviceContext.getDefinition() != null) {
            List list;
            this.wsdlOperationOneWay = new Boolean(false);
            Port port2 = this.getPort();
            if (port2 != null && this.operationName != null && (list = port2.getBinding().getPortType().getOperations()) != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Operation operation = (Operation)iterator.next();
                    if (!this.operationName.getLocalPart().equals(operation.getName()) || operation.getOutput() != null) continue;
                    this.wsdlOperationOneWay = new Boolean(true);
                }
            }
        }
        if (this.wsdlOperationOneWay != null) {
            return this.wsdlOperationOneWay != false ? true : this.oneWay;
        }
        return this.oneWay;
    }

    public void setOneWay(boolean bl) {
        this.oneWay = bl;
    }

    public boolean isPastPivot() {
        return this.pastPivot;
    }

    public void setPastPivot(boolean bl) {
        this.pastPivot = bl;
        if (this.pastPivot) {
            this.setRequestPropertyNames(new ArrayList(this.properties.keySet()));
        }
    }

    public String getInitialEndpoint() {
        return this.initialEndpoint;
    }

    public void setInitialEndpoint(String string) {
        this.initialEndpoint = string;
    }

    public Class[] getInputParameterTypes() {
        if (this.inputParameterTypes == null) {
            this.inputParameterTypes = this.inputParams == null || this.inputParams.length < 1 ? new Class[0] : this.getInputParameterTypes(this.operationName, this.inputParams.length);
        }
        return this.inputParameterTypes;
    }

    public void setInputParameterTypes(Class[] classArray) {
        this.inputParameterTypes = classArray;
    }

    public SDOConvertor getSDOConvertor() {
        if (this.sdoConvertor == null) {
            ServiceContext serviceContext = this.getServiceContext();
            String string = serviceContext.getSdoRepositoryKey();
            QName qName = serviceContext.getSdoServiceName();
            String string2 = this.getSdoPortName();
            Map map = serviceContext.getTypeMappings();
            try {
                this.sdoConvertor = SDOConvertorFactory.getSDOConvertor(qName, string2, string, map);
            }
            catch (SDOConvertorException sDOConvertorException) {
                throw new JAXRPCException("exception getting SDOConvertor", sDOConvertorException);
            }
        }
        return this.sdoConvertor;
    }

    public DataGraph getInputDataGraph() {
        if (this.inputDataGraph == null && this.inputParams != null) {
            SDOConvertor sDOConvertor = this.getSDOConvertor();
            sDOConvertor.setParameterValues(this.getOperationName().getLocalPart(), this.inputParams, this.getInputParameterTypes(), true);
            try {
                this.inputDataGraph = sDOConvertor.getDataGraph();
            }
            catch (SDOConvertorException sDOConvertorException) {
                throw new JAXRPCException("exception getting DataGraph: " + sDOConvertorException, sDOConvertorException);
            }
        }
        return this.inputDataGraph;
    }

    public void setInputDataGraph(DataGraph dataGraph) {
        this.inputDataGraph = dataGraph;
    }

    public DataGraph getOutputDataGraph() {
        if (this.outputDataGraph == null && this.outputParams != null) {
            SDOConvertor sDOConvertor = this.getSDOConvertor();
            sDOConvertor.setParameterValues(this.getOperationName().getLocalPart(), this.outputParams, null, false);
            try {
                this.outputDataGraph = sDOConvertor.getDataGraph();
            }
            catch (SDOConvertorException sDOConvertorException) {
                throw new JAXRPCException("exception getting DataGraph: " + sDOConvertorException, sDOConvertorException);
            }
        }
        return this.outputDataGraph;
    }

    public void setOutputDataGraph(DataGraph dataGraph) {
        this.outputDataGraph = dataGraph;
    }

    public String getSdoPortName() {
        if (this.sdoPortName == null) {
            this.sdoPortName = this.getPortName();
        }
        return this.sdoPortName;
    }

    public void setSdoPortName(String string) {
        this.sdoPortName = string;
    }

    public boolean isProtocolOverridden() {
        return this.protocolOverridden;
    }

    public void setProtocolOverridden(boolean bl) {
        this.protocolOverridden = bl;
    }
}

