/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.trace;

import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class BinaryFormatter {
    protected byte[] buf;
    protected int size;
    protected CharArrayWriter cw = new CharArrayWriter();
    protected PrintWriter pw = new PrintWriter(this.cw);

    public BinaryFormatter(byte[] byArray) {
        this.buf = byArray;
        this.size = byArray.length;
    }

    public String trace() {
        int n = 1;
        int n2 = 0;
        while (n2 < this.size) {
            this.traceRow(n2);
            n2 = (++n - 1) * 16;
        }
        this.pw.println();
        this.pw.flush();
        return this.cw.toString();
    }

    private void traceRow(int n) {
        int n2;
        this.pw.println();
        this.traceHex(n >> 12 & 0xF);
        this.traceHex(n >> 8 & 0xF);
        this.traceHex(n >> 4 & 0xF);
        this.traceHex(n & 0xF);
        this.pw.print(": ");
        for (n2 = 0; n2 < 16; ++n2) {
            this.byteAsHex(n, n2);
        }
        this.pw.print("  ");
        for (n2 = 0; n2 < 16; ++n2) {
            this.byteAsChar(n, n2);
        }
    }

    private void byteAsChar(int n, int n2) {
        if (n + n2 < this.size) {
            char c = (char)this.buf[n + n2];
            if (c > '\u001f' && c < '\u0080') {
                this.pw.print(c);
            } else {
                this.pw.print('.');
            }
        } else {
            this.pw.print(' ');
        }
    }

    private void byteAsHex(int n, int n2) {
        if (n + n2 < this.size) {
            this.traceHex(this.buf[n + n2] >> 4 & 0xF);
            this.traceHex(this.buf[n + n2] & 0xF);
            this.pw.print(" ");
            if (n2 == 7) {
                this.pw.print("- ");
            }
        } else {
            this.pw.print("   ");
            if (n2 == 7) {
                this.pw.print("  ");
            }
        }
    }

    private void traceHex(int n) {
        switch (n) {
            case 0: {
                this.pw.print('0');
                break;
            }
            case 1: {
                this.pw.print('1');
                break;
            }
            case 2: {
                this.pw.print('2');
                break;
            }
            case 3: {
                this.pw.print('3');
                break;
            }
            case 4: {
                this.pw.print('4');
                break;
            }
            case 5: {
                this.pw.print('5');
                break;
            }
            case 6: {
                this.pw.print('6');
                break;
            }
            case 7: {
                this.pw.print('7');
                break;
            }
            case 8: {
                this.pw.print('8');
                break;
            }
            case 9: {
                this.pw.print('9');
                break;
            }
            case 10: {
                this.pw.print('A');
                break;
            }
            case 11: {
                this.pw.print('B');
                break;
            }
            case 12: {
                this.pw.print('C');
                break;
            }
            case 13: {
                this.pw.print('D');
                break;
            }
            case 14: {
                this.pw.print('E');
                break;
            }
            case 15: {
                this.pw.print('F');
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray[0] == null) {
            System.out.println("Usage: BinaryFormatter <stringToDumpAsBytes>");
            return;
        }
        byte[] byArray = stringArray[0].getBytes();
        BinaryFormatter binaryFormatter = new BinaryFormatter(byArray);
        System.out.println(binaryFormatter.trace());
    }
}

