/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.trace;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.resources.Messages;

public class UserExceptionTrace {
    private static TraceComponent tc = Tr.register(UserExceptionTrace.class, "WebServices", "com.ibm.ws.webservices.engine.resources.engineMessages");

    public static boolean isUserExceptionLoggingEnabled() {
        return tc.isDebugEnabled();
    }

    public static boolean isUserDefinedException(Throwable throwable) {
        return throwable != null && throwable instanceof WebServicesFault && ((WebServicesFault)throwable).isUserException();
    }

    public static void log(Throwable throwable) {
        UserExceptionTrace.log(throwable, null, null, null);
    }

    public static void log(Throwable throwable, String string, String string2, Object object) {
        if (UserExceptionTrace.isUserDefinedException(throwable)) {
            if (UserExceptionTrace.isUserExceptionLoggingEnabled()) {
                String string3 = Messages.getMessage("logUserException00");
                Tr.debug(tc, string3, throwable);
            }
        } else {
            Tr.error(tc, "exception01", throwable);
            if (string != null && string2 != null && object != null) {
                FFDCFilter.processException(throwable, string, string2, object);
            }
        }
    }
}

