/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.wsaddressing.Constants;
import com.ibm.ws.wsaddressing.EndpointReferenceImpl;
import com.ibm.ws.wsaddressing.EndpointReferenceManager;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.binders.EndpointReferenceTypeBinder;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.ws.wsaddressing.namespace.NamespaceData200408;
import com.ibm.ws.wsaddressing.urimap.PortURIManager;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.Metadata;
import com.ibm.wsspi.wsaddressing.ServiceName;
import com.ibm.wsspi.wsaddressing.URIGenerationException;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.io.Serializable;
import java.net.URI;
import java.rmi.Remote;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Attr;

public class EndpointReferenceManagerImpl
extends EndpointReferenceManager {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.EndpointReferenceManagerImpl";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAddressingFactory.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);

    public com.ibm.websphere.wsaddressing.EndpointReference createConcreteEndpointReference(QName qName, String string) throws EndpointReferenceCreationException {
        Object object;
        Object object2;
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{qName, string};
            Tr.entry(TRACE_COMPONENT, "createConcreteEndpointReference", objectArray);
        }
        if (qName == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "Service passed to createEndpointReference was null");
            }
            throw new EndpointReferenceCreationException("Service Name specified was null");
        }
        if (string == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "Port name passed to createEndpointReference was null");
            }
            throw new EndpointReferenceCreationException("Port name specified was null");
        }
        objectArray = qName.getLocalPart();
        QName qName2 = new QName(qName.getNamespaceURI(), string);
        URI uRI = null;
        try {
            uRI = PortURIManager.getSOAPAddressForPort((String)objectArray, qName2);
        }
        catch (URIGenerationException uRIGenerationException) {
            String string2 = "Check the serviceName and endpointName.  An EndpointReferenceCreationException was thrown. " + uRIGenerationException.getMessage();
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", string2);
            }
            FFDCFilter.processException(uRIGenerationException, CLASSNAME, "1:161:1.42");
            throw new EndpointReferenceCreationException(uRIGenerationException);
        }
        if (uRI == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "URI for port could not be found");
            }
            throw new EndpointReferenceCreationException("URI for port could not be found");
        }
        AttributedURI attributedURI = WSAddressingFactory.createAttributedURI(uRI);
        EndpointReferenceImpl endpointReferenceImpl = null;
        if (attributedURI == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "AttributedURI is null");
            }
            throw new EndpointReferenceCreationException("AttributedURI is null");
        }
        if (attributedURI.getURI() == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "AttributedURI is null");
            }
            throw new EndpointReferenceCreationException("URI in AttributedURI is null");
        }
        try {
            endpointReferenceImpl = (EndpointReferenceImpl)EndpointReferenceManager.createEndpointReference(attributedURI);
            if (qName != null) {
                object2 = WSAddressingFactory.createMetadata();
                object = WSAddressingFactory.createServiceName(qName);
                if (string != null) {
                    object.setEndpointName(string);
                }
                object2.setServiceName((ServiceName)object);
                endpointReferenceImpl.setMetadata((Metadata)object2);
            }
        }
        catch (EndpointReferenceCreationException endpointReferenceCreationException) {
            String string3 = "Check the serviceName and endpointName.  An EndpointReferenceCreationException was thrown. " + endpointReferenceCreationException.getMessage();
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", string3);
            }
            FFDCFilter.processException(endpointReferenceCreationException, CLASSNAME, "1:221:1.42");
            throw new EndpointReferenceCreationException(endpointReferenceCreationException);
        }
        if (PortURIManager.intermediaryConfigured((String)objectArray, qName2)) {
            endpointReferenceImpl.setIntermediaryPresentReferenceParameter();
        }
        object2 = PortURIManager.getVirtualHostForPort((String)objectArray, qName2);
        endpointReferenceImpl.setVirtualHostName((String)object2);
        try {
            object = (Server)WsServiceRegistry.getService(Server.class, Server.class);
            String string4 = object.getCellName();
            String string5 = object.getClusterName();
            Identity identity = IdentityMapping.getApplicationServerCluster(string4, string5);
            if (identity != null) {
                endpointReferenceImpl.setRoutingKey(Constants.WLM_ROUTING_KEY, identity);
            }
        }
        catch (Exception exception) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "createConcreteEndpointReference", "Unable to obtain clusterId :" + exception);
            }
            String string6 = "Unable to access ServiceRegistry to obtain clusterId. " + exception.getMessage();
            FFDCFilter.processException(exception, CLASSNAME, "1:260:1.42");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", endpointReferenceImpl);
        }
        return endpointReferenceImpl;
    }

    protected com.ibm.websphere.wsaddressing.EndpointReference createConcreteEndpointReference(QName qName, String string, Remote remote) throws EndpointReferenceCreationException {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{qName, string, remote};
            Tr.entry(TRACE_COMPONENT, "createConcreteEndpointReference", objectArray);
        }
        objectArray = (Object[])this.createConcreteEndpointReference(qName, string);
        objectArray.setSFSBAffinity(remote);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", objectArray);
        }
        return objectArray;
    }

    public EndpointReference createConcreteEndpointReference(SOAPElement sOAPElement) throws EndpointReferenceCreationException {
        EndpointReference endpointReference = null;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createConcreteEndpointReference", sOAPElement);
        }
        EndpointReferenceTypeBinder endpointReferenceTypeBinder = new EndpointReferenceTypeBinder();
        try {
            endpointReference = (EndpointReference)endpointReferenceTypeBinder.deserialize(sOAPElement, null);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException(sOAPException, EndpointReferenceManagerImpl.class.getName() + ".EndpointReferenceManagerImpl", "1:329:1.42");
            throw new EndpointReferenceCreationException("SOAPException thrown during de-serialization of EPR", sOAPException);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", endpointReference);
        }
        return endpointReference;
    }

    public String getConcreteReferenceParameterFromMessageContext(QName qName) throws ReferenceParameterCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameterFromMessageContext", qName);
        }
        com.ibm.ws.webservices.engine.MessageContext messageContext = com.ibm.ws.webservices.engine.MessageContext.getCurrentThreadsContext();
        String string = this.getReferenceParameterFromMessageContextObject(messageContext, qName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromMessageContext", string);
        }
        return string;
    }

    protected EndpointReference createConcreteEndpointReference(URI uRI) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createConcreteEndpointReference", uRI);
        }
        if (uRI == null) {
            throw new EndpointReferenceCreationException("Unable to create EndpointReference: Null address passed to method");
        }
        EndpointReference endpointReference = null;
        AttributedURI attributedURI = WSAddressingFactory.createAttributedURI(uRI);
        endpointReference = this.createConcreteEndpointReference(attributedURI);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", endpointReference);
        }
        return endpointReference;
    }

    protected EndpointReference createConcreteEndpointReference(AttributedURI attributedURI) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createConcreteEndpointReference", attributedURI);
        }
        EndpointReferenceImpl endpointReferenceImpl = null;
        if (attributedURI == null) {
            throw new EndpointReferenceCreationException("Unable to create EndpointReference: Null address passed to method");
        }
        endpointReferenceImpl = new EndpointReferenceImpl(attributedURI);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", endpointReferenceImpl);
        }
        return endpointReferenceImpl;
    }

    protected String getConcreteReferenceParameterFromSpecificMessageContext(MessageContext messageContext, QName qName) throws ReferenceParameterCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getConcreteReferenceParameterFromSpecificMessageContext", new Object[]{messageContext, qName});
        }
        String string = this.getReferenceParameterFromMessageContextObject(messageContext, qName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getConcreteReferenceParameterFromSpecificMessageContext", string);
        }
        return string;
    }

    protected SOAPElement getConcreteSOAPElementReferenceParameterFromSpecificMessageContext(MessageContext messageContext, QName qName) throws ReferenceParameterCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getConcreteSOAPElementReferenceParameterFromSpecificMessageContext", new Object[]{messageContext, qName});
        }
        SOAPElement sOAPElement = this.getSOAPElementReferenceParameterFromMessageContextObject(messageContext, qName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getConcreteSOAPElementReferenceParameterFromSpecificMessageContext", sOAPElement);
        }
        return sOAPElement;
    }

    protected SOAPElement getConcreteSOAPElementReferenceParameterFromMessageContext(QName qName) throws ReferenceParameterCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getConcreteSOAPElementReferenceParameterFromMessageContext", new Object[]{qName});
        }
        com.ibm.ws.webservices.engine.MessageContext messageContext = com.ibm.ws.webservices.engine.MessageContext.getCurrentThreadsContext();
        SOAPElement sOAPElement = this.getSOAPElementReferenceParameterFromMessageContextObject(messageContext, qName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getConcreteSOAPElementReferenceParameterFromMessageContext", sOAPElement);
        }
        return sOAPElement;
    }

    private SOAPElement getSOAPElementReferenceParameterFromMessageContextObject(MessageContext messageContext, QName qName) throws ReferenceParameterCreationException {
        Serializable serializable;
        Object object;
        Object object2;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContextObject", qName);
        }
        if (qName == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContextObject", "ReferenceParameter QName supplied was null. Throwing ReferenceParameterCreationException");
            }
            throw new ReferenceParameterCreationException("ReferenceParameter QName supplied was null.");
        }
        SOAPElement sOAPElement = null;
        if (!(messageContext instanceof SOAPMessageContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContextObject", "MessageContext is not an instance of SOAPMessageContext. Throwing ReferenceParameterCreationException");
            }
            throw new ReferenceParameterCreationException("MessageContext is not an instance of SOAPMessageContext");
        }
        javax.xml.soap.SOAPHeader sOAPHeader = null;
        Name name2 = null;
        try {
            object2 = (SOAPMessageContext)messageContext;
            object = object2.getMessage();
            sOAPHeader = ((SOAPMessage)object).getSOAPHeader();
            serializable = ((SOAPHeader)sOAPHeader).getSOAPFactory();
            name2 = ((javax.xml.soap.SOAPFactory)((Object)serializable)).createName(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, EndpointReferenceManagerImpl.class.getName() + ".EndpointReferenceManagerImpl", "1:546:1.42", new Object[]{qName});
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContextObject", "SOAPException caught creating Name object. Throwing ReferenceParameterCreationException");
            }
            throw new ReferenceParameterCreationException(sOAPException);
        }
        object2 = sOAPHeader.getChildElements(name2);
        if (object2.hasNext()) {
            object = (SOAPElement)object2.next();
            serializable = NamespaceData.getNamespaceDataFromContext(messageContext);
            boolean bl = serializable instanceof NamespaceData200408;
            Attr attr = null;
            SOAPFactory sOAPFactory = ((SOAPHeader)sOAPHeader).getSOAPFactory();
            Name name3 = ((NamespaceData)serializable).getwsaIsReferenceParameter();
            if (serializable != null) {
                attr = object.getAttributeNodeNS(name3.getURI(), name3.getLocalName());
            }
            if (bl || attr != null && (attr.getValue().equals("true") || attr.getValue().equals("1"))) {
                Iterator iterator = object.getChildElements();
                if (!iterator.hasNext()) {
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContextObject", new Object[]{"No Child Elements", iterator});
                    }
                    return null;
                }
                sOAPElement = (SOAPElement)iterator.next();
                if (iterator.hasNext() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Element with specified QName has multiple children.", qName);
                }
            }
        }
        if (object2.hasNext() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Multiple reference parameters exist with the same name", qName);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContextObject", sOAPElement);
        }
        return sOAPElement;
    }

    private String getReferenceParameterFromMessageContextObject(MessageContext messageContext, QName qName) throws ReferenceParameterCreationException {
        Object object;
        Object object2;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameterFromMessageContextObject", new Object[]{messageContext, qName});
        }
        String string = null;
        if (messageContext == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromMessageContextObject", "MessageContext to be searched for ReferenceParameter is null. Throwing ReferenceParameterCreationException");
            }
            throw new ReferenceParameterCreationException("MessageContext to be searched for ReferenceParameter is null");
        }
        if (!(messageContext instanceof SOAPMessageContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromMessageContextObject", "MessageContext is not an instance of SOAPMessageContext. Throwing ReferenceParameterCreationException");
            }
            throw new ReferenceParameterCreationException("MessageContext is not an instance of SOAPMessageContext");
        }
        if (qName == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromMessageContextObject", "QName for RefgerenceParameter is null. Throwing ReferenceParameterCreationException");
            }
            throw new ReferenceParameterCreationException("QName for RefgerenceParameter is null");
        }
        javax.xml.soap.SOAPHeader sOAPHeader = null;
        javax.xml.soap.SOAPFactory sOAPFactory = null;
        Name name2 = null;
        try {
            object2 = (SOAPMessageContext)messageContext;
            object = object2.getMessage();
            sOAPHeader = ((SOAPMessage)object).getSOAPHeader();
            sOAPFactory = javax.xml.soap.SOAPFactory.newInstance();
            name2 = sOAPFactory.createName(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, EndpointReferenceManagerImpl.class.getName() + ".EndpointReferenceManagerImpl", "1:690:1.42", new Object[]{qName});
            throw new ReferenceParameterCreationException(sOAPException);
        }
        object2 = sOAPHeader.getChildElements(name2);
        if (object2.hasNext()) {
            object = (SOAPElement)object2.next();
            Name name3 = NamespaceData.getNamespaceDataFromContext(messageContext).getwsaIsReferenceParameter();
            Attr attr = null;
            if (name3 != null) {
                attr = object.getAttributeNodeNS(name3.getURI(), name3.getLocalName());
            }
            if (name3 == null || attr != null && (attr.getValue().equals("true") || attr.getValue().equals("1"))) {
                string = object.getValue();
            }
        }
        if (object2.hasNext() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Multiple reference parameters exist with the same name", qName);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromMessageContextObject", string);
        }
        return string;
    }

    protected URI getConcreteURIForEndpoint(QName qName, String string) throws URIGenerationException {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{qName, string};
            Tr.entry(TRACE_COMPONENT, "getConcreteURIForEndpoint", objectArray);
        }
        if (qName == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getConcreteURIForEndpoint", "Service passed to getConcreteURIForEndpoint was null");
            }
            throw new URIGenerationException("Service Name specified was null");
        }
        if (string == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getConcreteURIForEndpoint", "Port name passed to getConcreteURIForEndpoint was null");
            }
            throw new URIGenerationException("Port name specified was null");
        }
        objectArray = qName.getLocalPart();
        QName qName2 = new QName(qName.getNamespaceURI(), string);
        URI uRI = PortURIManager.getSOAPAddressForPort((String)objectArray, qName2);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getConcreteURIForEndpoint", uRI);
        }
        return uRI;
    }
}

