/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.wsaddressing.Constants;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.handlers.ActionSpecifier;
import com.ibm.ws.wsaddressing.handlers.InboundWSAProcessor;
import com.ibm.ws.wsaddressing.handlers.MAPWriter;
import com.ibm.ws.wsaddressing.handlers.MessagePivot;
import com.ibm.ws.wsaddressing.handlers.ReplyHelper;
import com.ibm.ws.wsaddressing.handlers.UsingAddressingHelper;
import com.ibm.ws.wsaddressing.handlers.WSACommonHandler;
import com.ibm.ws.wsaddressing.handlers.WSAOutboundProperties;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.webservices.rpc.handler.RPCContext;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.io.Serializable;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;

public class WSAddressingServerHandler
extends WSACommonHandler {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.WSAddressingServerHandler";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAddressingServerHandler.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private boolean wsAddressingDisabled = false;
    private static final QName[] headerElementQNames = new QName[7];

    public boolean handleRequest(MessageContext messageContext) {
        if (this.isAddressingDisabled(messageContext)) {
            return true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "handleRequest", messageContext);
        }
        boolean bl = UsingAddressingHelper.wsaddressingMandatedByUsingAddressing(messageContext);
        SOAPMessageContext sOAPMessageContext = null;
        if (!(messageContext instanceof SOAPMessageContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleRequest", "No SoapMessageContext, return true;");
            }
            return true;
        }
        sOAPMessageContext = (SOAPMessageContext)messageContext;
        InboundWSAProcessor inboundWSAProcessor = new InboundWSAProcessor();
        boolean bl2 = inboundWSAProcessor.setMessageContext(sOAPMessageContext);
        if (!bl2 && bl) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleRequest");
            }
            throw this.generateSFE();
        }
        if (bl2 && !inboundWSAProcessor.isAddressingValid()) {
            String string = "An invalid WSA Header was encountered";
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.warning(TRACE_COMPONENT, string);
            }
            SOAPFaultException sOAPFaultException = inboundWSAProcessor.getSoapFaultException();
            throw sOAPFaultException;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "handleRequest:[true]");
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "handleResponse", messageContext);
        }
        if ((object = messageContext.getProperty(Constants.WSA_FOUND_INBOUND)) == null || object instanceof Boolean && !((Boolean)object).booleanValue()) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleResponse", messageContext);
            }
            return true;
        }
        if (this.isAddressingDisabled(messageContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleResponse", "WSA Disabled, return true;");
            }
            return true;
        }
        if (!(messageContext instanceof SOAPMessageContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleResponse", "MessageContext not instanceof SOAPMessageContext, return true;");
            }
            return true;
        }
        if (((SOAPMessageContext)messageContext).getMessage() == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleResponse", "SOAPMessageContext has no message set, return true;");
            }
            return true;
        }
        EndpointReference endpointReference = (EndpointReference)messageContext.getProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR");
        NamespaceData namespaceData = NamespaceData.getNamespaceDataFromContext(messageContext);
        ReplyHelper replyHelper = new ReplyHelper(endpointReference, null, namespaceData);
        MessagePivot messagePivot = new MessagePivot();
        messagePivot.requestBecomesResponse(replyHelper, messageContext);
        this.addWSAddressingToResponseOrFaultMessage(messageContext, ActionSpecifier.MessageType.RESPONSE);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "handleResponse");
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "handleFault", messageContext);
        }
        if (this.isAddressingDisabled(messageContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleFault", "WSA Disabled, return true;");
            }
            return true;
        }
        if (!(messageContext instanceof SOAPMessageContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleFault", "MessageContext not SOAPMessageContext, return true;");
            }
            return true;
        }
        if (((SOAPMessageContext)messageContext).getMessage() == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleFault", "SOAPMessageContext has no message set, return true;");
            }
            return true;
        }
        NamespaceData namespaceData = NamespaceData.getNamespaceDataFromContext(messageContext);
        if (messageContext.containsProperty("com.ibm.ws.wsaddressing.soapfault.detail")) {
            object4 = (String)messageContext.getProperty("com.ibm.ws.wsaddressing.soapfault.detail");
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "FaultDetail string found: " + (String)object4);
            }
            messageContext.setProperty("com.ibm.wsspi.wsaddressing.action", WSAddressingFactory.createAttributedURI(namespaceData.getFaultActionURI()));
            try {
                serializable = new SOAPFactory();
                object3 = ((SOAPFactory)serializable).createElement(namespaceData.getwsaFaultDetailName());
                object2 = ((SOAPFactory)serializable).createElement(namespaceData.getwsaProblemHeaderQN());
                object3.addChildElement((SOAPElement)object2);
                object2.addTextNode(object2.getPrefix() + ":" + (String)object4);
                object = ((SOAPMessageContext)messageContext).getMessage();
                SOAPHeader sOAPHeader = ((SOAPMessage)object).getSOAPHeader();
                sOAPHeader.addChildElement((SOAPElement)object3);
            }
            catch (SOAPException sOAPException) {
                object3 = "SOAPException encountered when setting soapHeader.";
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, "com.ibm.ws.wsaddressing.handlers.WSAddressingServerHandler.handleFault", object3);
                }
                FFDCFilter.processException(sOAPException, CLASSNAME, "1:310:1.106");
            }
        }
        if ((object4 = messageContext.getProperty(Constants.WSA_FOUND_INBOUND)) == null || object4 instanceof Boolean && !((Boolean)object4).booleanValue()) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleFault", messageContext);
            }
            return true;
        }
        serializable = (EndpointReference)messageContext.getProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR");
        object3 = (EndpointReference)messageContext.getProperty("com.ibm.wsspi.wsaddressing.inbound.FaultToEPR");
        object2 = new ReplyHelper((EndpointReference)serializable, (EndpointReference)object3, namespaceData);
        object = new MessagePivot();
        ((MessagePivot)object).requestBecomesFault((ReplyHelper)object2, messageContext);
        this.addWSAddressingToResponseOrFaultMessage(messageContext, ActionSpecifier.MessageType.FAULT);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "handleFault");
        }
        return true;
    }

    private void addWSAddressingToResponseOrFaultMessage(MessageContext messageContext, ActionSpecifier.MessageType messageType) throws JAXRPCException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addWSAddressingToResponseOrFaultMessage", messageContext);
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        WSAOutboundProperties wSAOutboundProperties = new WSAOutboundProperties();
        if (wSAOutboundProperties.setMessageContextandWSAProperties(messageContext)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "addWSAddressingToResponseOrFaultMessage", "WSAddressing properties were found on the context");
            }
            if (messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectRequired") != null) {
                this.completeRedirectionChanges(messageContext);
            }
            if (messageContext.containsProperty("com.ibm.ws.wsaddressing.NoneURI")) {
                this.completeNoneURI(messageContext);
            }
            AttributedURI attributedURI = wSAOutboundProperties.getWsaddressingAction();
            RPCContext rPCContext = (RPCContext)((Object)messageContext);
            ActionSpecifier actionSpecifier = new ActionSpecifier(rPCContext);
            if (attributedURI == null) {
                if (ActionSpecifier.MessageType.RESPONSE.equals(messageType)) {
                    attributedURI = actionSpecifier.getActionForOutputMessageFromWSDL();
                } else if (ActionSpecifier.MessageType.FAULT.equals(messageType)) {
                    boolean bl = messageContext.containsProperty("com.ibm.ws.wsaddressing.soapfault.detail");
                    attributedURI = actionSpecifier.getActionForFaultMessageFromWSDL(wSAOutboundProperties.getNamespaceData(), bl);
                }
                wSAOutboundProperties.setWsaddressingAction(attributedURI);
            }
            MAPWriter mAPWriter = new MAPWriter();
            SOAPHeader sOAPHeader = null;
            try {
                sOAPHeader = mAPWriter.getSOAPHeaderFromMessageContext(sOAPMessageContext);
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.wsaddressing.handlers.WSAddressingServerHandler.addWSAddressingToResponseOrFaultMessage", "1:445:1.106", sOAPException);
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "addWSAddressingToResponseOrFaultMessage", "SOAPException whilst trying to retrieve or add a SOAPHeader to this SOAPMessage.");
                }
                throw new JAXRPCException(sOAPException);
            }
            NamespaceData namespaceData = wSAOutboundProperties.getNamespaceData();
            messageContext.setProperty("com.ibm.wsspi.wsaddressing.OutboundNamespace", namespaceData.getNamespace());
            try {
                mAPWriter.addNamespaceDeclarationToSOAPEnvelope(sOAPMessageContext, namespaceData);
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.wsaddressing.handlers.WSAddressingServerHandler.addWSAddressingToResponseOrFaultMessage", "1:459:1.106", sOAPException);
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "addWSAddressingToResponseOrFaultMessage", "SOAPException whilst trying to add namespace declaration to SOAPEnvelope.");
                }
                throw new JAXRPCException(sOAPException);
            }
            mAPWriter.addPropertiesToSoapHeader(sOAPHeader, wSAOutboundProperties);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "addWSAddressingToResponseOrFaultMessage");
            }
        }
    }

    public QName[] getHeaders() {
        return headerElementQNames;
    }

    private void completeNoneURI(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "completeNoneURI", messageContext);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "completeNoneURI", "Need to close client connection as response is targeted to the WSAddressing NoneURI indicating it should be discarded.");
        }
        com.ibm.ws.webservices.engine.MessageContext messageContext2 = (com.ibm.ws.webservices.engine.MessageContext)messageContext;
        try {
            messageContext2.oneWayEvent();
        }
        catch (Throwable throwable) {
            String string = "Runtime exception when closing connection with client.";
            Tr.warning(TRACE_COMPONENT, "completeNoneURI", string);
            FFDCFilter.processException(throwable, CLASSNAME, "1:508:1.106");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "completeNoneURI");
        }
    }

    private void completeRedirectionChanges(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "completeRedirectionChanges", messageContext);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "completeRedirectionChanges", "This response is being redirected, need to set it as the request message outbound.");
        }
        com.ibm.ws.webservices.engine.MessageContext messageContext2 = (com.ibm.ws.webservices.engine.MessageContext)messageContext;
        messageContext2.setRequestMessage(messageContext2.getResponseMessage());
        messageContext2.setSOAPActionURI("");
        try {
            if (messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectResponse") != null && messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectFault") != null) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "completeRedirectionChanges", "Client connection will have been closed by SoapRPCProcessor");
                }
            } else {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "completeRedirectionChanges", "Need to close client connection as response is targeted to a different endpoint.");
                }
                messageContext2.oneWayEvent();
            }
        }
        catch (Throwable throwable) {
            String string = "Runtime exception when closing connection with client.";
            Tr.warning(TRACE_COMPONENT, "completeRedirectionChanges", string);
            FFDCFilter.processException(throwable, CLASSNAME, "1:560:1.106");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "completeRedirectionChanges");
        }
    }

    protected boolean addressingDisabledGlobally() {
        return this.wsAddressingDisabled;
    }

    protected void setAddressingDisabledGlobally(boolean bl) {
        this.wsAddressingDisabled = bl;
    }

    private SOAPFaultException generateSFE() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "generateSFE");
        }
        String string = "A message conforming to WS-Addressing standards was expected but not found";
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.warning(TRACE_COMPONENT, string);
        }
        SOAPFault sOAPFault = null;
        SOAPFactory sOAPFactory = new SOAPFactory();
        try {
            sOAPFault = sOAPFactory.createSOAPFault();
            sOAPFault.setFaultCode(NamespaceData.getDefaultNamespaceInstance().getMessageAddressingPropertyRequired().toString());
            sOAPFault.setFaultString(string);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.wsaddressing.handlers.WSAddressingServerHandler.handleRequest", "1:606:1.106", sOAPException);
        }
        String string2 = sOAPFault.getFaultActor();
        String string3 = sOAPFault.getFaultString();
        Detail detail = sOAPFault.getDetail();
        QName qName = sOAPFault.getFaultCodeAsQName();
        SOAPFaultException sOAPFaultException = new SOAPFaultException(qName, string3, string2, detail);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "generateSFE");
        }
        return sOAPFaultException;
    }

    static {
        WSAddressingServerHandler.headerElementQNames[0] = new QName("http://www.w3.org/2005/08/addressing", "MessageID");
        WSAddressingServerHandler.headerElementQNames[1] = new QName("http://www.w3.org/2005/08/addressing", "RelatesTo");
        WSAddressingServerHandler.headerElementQNames[2] = new QName("http://www.w3.org/2005/08/addressing", "ReplyTo");
        WSAddressingServerHandler.headerElementQNames[3] = new QName("http://www.w3.org/2005/08/addressing", "FaultTo");
        WSAddressingServerHandler.headerElementQNames[4] = new QName("http://www.w3.org/2005/08/addressing", "From");
        WSAddressingServerHandler.headerElementQNames[5] = new QName("http://www.w3.org/2005/08/addressing", "To");
        WSAddressingServerHandler.headerElementQNames[6] = new QName("http://www.w3.org/2005/08/addressing", "Action");
    }
}

