/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.urimap.MetaDataLoader;
import com.ibm.ws.wsaddressing.urimap.ModuleData;
import com.ibm.ws.wsaddressing.urimap.WSADeployUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WSADeployUtilsImpl
extends WSADeployUtils {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.urimap.WSADeployUtilsImpl";
    private static TraceComponent _tc = Tr.register(WSADeployUtilsImpl.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private static String workspaceId = Long.toString(System.currentTimeMillis());

    static String trimSlash(String string) {
        if (string == null) {
            return string;
        }
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map loadModuleDataImpl(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadModuleDataImpl", new Object[]{string, string2});
        }
        MetaDataLoader metaDataLoader = null;
        WorkSpace workSpace = null;
        HashMap<String, ModuleData> hashMap = new HashMap<String, ModuleData>();
        try {
            Object object;
            workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(workspaceId);
            String string3 = AdminServiceFactory.getAdminService().getCellName();
            String string4 = "cells/" + string3 + "/applications/" + string + ".ear/deployments/" + string;
            RepositoryContext repositoryContext = workSpace.findContext(string4);
            if (repositoryContext == null) {
                object = WorkSpaceManagerFactory.getManager();
                object.releaseWorkSpace(workspaceId);
                workspaceId = Long.toString(System.currentTimeMillis());
                workSpace = object.getWorkSpace(workspaceId);
                repositoryContext = workSpace.findContext(string4);
            }
            metaDataLoader = new MetaDataLoader(repositoryContext, string2);
            metaDataLoader.load();
            object = metaDataLoader.getModuleDataList();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ModuleData moduleData = (ModuleData)iterator.next();
                String string5 = moduleData.getContextRoot();
                if (string5 == null) continue;
                if ((string5 = string5.trim()).endsWith("/")) {
                    string5 = string5.substring(0, string5.length() - 1);
                }
                if (!string5.startsWith("/")) {
                    string5 = "/" + string5;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "contextRoot = " + string5);
                }
                hashMap.put(string5, moduleData);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, CLASSNAME, "1:135:1.1");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "can not load the application metadata", exception);
            }
        }
        finally {
            block22: {
                try {
                    if (metaDataLoader != null) {
                        metaDataLoader.cleanup();
                    }
                    if (workSpace != null) {
                        WorkSpaceManagerFactory.getManager().removeWorkSpace(workspaceId);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, CLASSNAME, "1:148:1.1");
                    if (!_tc.isDebugEnabled()) break block22;
                    Tr.debug(_tc, "unable to clean up resources", exception);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadModuleDataImpl");
        }
        return hashMap;
    }
}

