/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel.values;

import com.ibm.wsspi.genericbnf.GenericKeys;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.error.HttpError;

public class StatusCodes
extends GenericKeys {
    private static final int MAX_CODE = 750;
    private static StatusCodes[] statusCodes = new StatusCodes[751];
    private String myPhrase = null;
    private byte[] myPhraseBytes = null;
    private HttpError myError = null;
    private int myIntCode = 0;
    private byte[] bytesTrailingSpace = null;
    private byte[] bytesWithPhrase = null;
    private boolean bBodyAllowed = true;
    private boolean undefined = false;

    public StatusCodes(int n, String string, boolean bl) {
        super("" + n, n);
        if (0 > this.getOrdinal() || 750 < this.getOrdinal()) {
            throw new IndexOutOfBoundsException("Ordinal " + this.getOrdinal() + " is out of bounds");
        }
        this.myPhrase = string;
        this.myPhraseBytes = HttpChannelUtils.getEnglishBytes(string);
        this.myIntCode = n;
        if (bl) {
            this.myError = new HttpError(this.getOrdinal(), this.myPhrase);
        }
        StatusCodes.statusCodes[this.getOrdinal()] = this;
        this.initSpecialArrays();
        this.checkForAllowedBody();
    }

    private StatusCodes(StatusCodes statusCodes) {
        super(statusCodes.getName(), statusCodes.getOrdinal());
        this.myPhrase = statusCodes.getDefaultPhrase();
        this.myPhraseBytes = statusCodes.getDefaultPhraseBytes();
        this.myIntCode = statusCodes.getIntCode();
        this.myError = statusCodes.getHttpError();
    }

    public static StatusCodes makeUndefinedValue(int n) {
        StatusCodes statusCodes = new StatusCodes(HttpConstants.STATUS_UNDEF);
        statusCodes.name = Integer.toString(n);
        statusCodes.byteArray = HttpChannelUtils.getEnglishBytes(statusCodes.getName());
        statusCodes.myIntCode = n;
        statusCodes.initSpecialArrays();
        statusCodes.checkForAllowedBody();
        statusCodes.hashcode = statusCodes.ordinal + statusCodes.name.hashCode();
        statusCodes.undefined = true;
        return statusCodes;
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    private void initSpecialArrays() {
        int n = this.getByteArray().length;
        int n2 = n + 1;
        this.bytesTrailingSpace = new byte[n2];
        System.arraycopy(this.getByteArray(), 0, this.bytesTrailingSpace, 0, n);
        this.bytesTrailingSpace[n] = 32;
        this.bytesWithPhrase = new byte[n2 + this.getDefaultPhraseBytes().length];
        System.arraycopy(this.getByteArray(), 0, this.bytesWithPhrase, 0, n);
        this.bytesWithPhrase[n] = 32;
        System.arraycopy(this.getDefaultPhraseBytes(), 0, this.bytesWithPhrase, n2, this.getDefaultPhraseBytes().length);
    }

    public final byte[] getStatusSpace() {
        return this.bytesTrailingSpace;
    }

    public final byte[] getStatusWithPhrase() {
        return this.bytesWithPhrase;
    }

    public static StatusCodes getByOrdinal(int n) {
        if (0 > n || n >= 750) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of bounds");
        }
        return statusCodes[n];
    }

    public final String getDefaultPhrase() {
        return this.myPhrase;
    }

    public final byte[] getDefaultPhraseBytes() {
        return this.myPhraseBytes;
    }

    public final int getIntCode() {
        return this.myIntCode;
    }

    public boolean isErrorCode() {
        return null != this.getHttpError();
    }

    public final HttpError getHttpError() {
        return this.myError;
    }

    public final String toString() {
        return "Status code: " + this.getName();
    }

    public final boolean isBodyAllowed() {
        return this.bBodyAllowed;
    }

    public final void setBodyAllowed(boolean bl) {
        this.bBodyAllowed = bl;
    }

    private void checkForAllowedBody() {
        if (204 == this.getIntCode()) {
            this.setBodyAllowed(false);
        } else if (100 <= this.getIntCode() && 200 > this.getIntCode()) {
            this.setBodyAllowed(false);
        } else if (300 <= this.getIntCode() && 400 > this.getIntCode()) {
            this.setBodyAllowed(false);
        } else {
            this.setBodyAllowed(true);
        }
    }
}

