/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel.values;

import com.ibm.wsspi.genericbnf.BaseVersionValues;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpConstants;
import java.util.ArrayList;
import java.util.List;

public class VersionValues
extends BaseVersionValues {
    private static final int NUM_REQUIRED = 1;
    private static int numDefined = 1;
    private static List allKeys = new ArrayList();
    private byte[] bytesTrailingSpace = null;
    private byte[] bytesLeadingSpace = null;
    private boolean undefined = false;

    public VersionValues(String string) {
        super(string, numDefined);
        ++numDefined;
        allKeys.add(this);
        this.initSpecialArrays();
    }

    public VersionValues(String string, int n) {
        super(string, n);
        if (n > 1) {
            throw new IllegalArgumentException("Illegal input ordinal " + n);
        }
        this.initSpecialArrays();
    }

    private VersionValues(VersionValues versionValues) {
        super(versionValues.getName(), versionValues.getOrdinal());
    }

    public static List getAllKeys() {
        return allKeys;
    }

    public static VersionValues getByOrdinal(int n) {
        if (0 > n || n >= numDefined) {
            throw new IndexOutOfBoundsException("VersionValues index " + n + " is out of bounds");
        }
        return (VersionValues)allKeys.get(n - 1);
    }

    public static VersionValues makeUndefinedValue(byte[] byArray) {
        VersionValues versionValues = new VersionValues(HttpConstants.HTTP_VERSION_UNDEF);
        versionValues.byteArray = byArray;
        versionValues.name = HttpChannelUtils.getEnglishString(byArray);
        versionValues.parseVersion();
        versionValues.initSpecialArrays();
        versionValues.hashcode = versionValues.ordinal + versionValues.name.hashCode();
        versionValues.undefined = true;
        return versionValues;
    }

    public static VersionValues makeUndefinedValue(String string) {
        VersionValues versionValues = new VersionValues(HttpConstants.HTTP_VERSION_UNDEF);
        versionValues.byteArray = HttpChannelUtils.getEnglishBytes(string);
        versionValues.name = string;
        versionValues.parseVersion();
        versionValues.initSpecialArrays();
        versionValues.hashcode = versionValues.ordinal + versionValues.name.hashCode();
        versionValues.undefined = true;
        return versionValues;
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    private void initSpecialArrays() {
        int n = this.getByteArray().length;
        int n2 = n + 1;
        this.bytesTrailingSpace = new byte[n2];
        this.bytesLeadingSpace = new byte[n2];
        System.arraycopy(this.getByteArray(), 0, this.bytesTrailingSpace, 0, n);
        this.bytesTrailingSpace[this.getByteArray().length] = 32;
        this.bytesLeadingSpace[0] = 32;
        System.arraycopy(this.getByteArray(), 0, this.bytesLeadingSpace, 1, n);
    }

    public final byte[] getVersionSpace() {
        return this.bytesTrailingSpace;
    }

    public final byte[] getSpaceVersion() {
        return this.bytesLeadingSpace;
    }

    protected void parseVersion() {
        if ("Undefined".equals(this.getName())) {
            return;
        }
        super.parseVersion();
        if (!"http".equalsIgnoreCase(this.getProtocolName())) {
            throw new IllegalArgumentException("Protocol is not HTTP");
        }
    }
}

