/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan.util;

import com.ibm.xml.xlxp.scan.DTDScannerHelper;
import com.ibm.xml.xlxp.scan.util.AttrList;
import com.ibm.xml.xlxp.scan.util.DTDGrammarCache;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.DataStore;
import com.ibm.xml.xlxp.scan.util.EntityDeclPool;
import com.ibm.xml.xlxp.scan.util.ErrorReporter;
import com.ibm.xml.xlxp.scan.util.IntegerHashtable;
import com.ibm.xml.xlxp.scan.util.NSDeclList;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;

public class DTDGrammar {
    protected static final int ATTDEF_ATTRNAME_OFFSET = 0;
    protected static final int ATTDEF_ATTTYPE_OFFSET = 1;
    protected static final int ATTDEF_DEFAULTTYPE_OFFSET = 2;
    protected static final int ATTDEF_ENUMTYPE_OFFSET = 3;
    protected static final int ATTDEF_ATTVALUE_OFFSET = 4;
    protected static final int ATTDEF_EXTERNAL_OFFSET = 5;
    protected static final int ATTDEF_RECORD_SIZE = 6;
    protected SymbolTable fSymbolTable;
    protected XMLStringBuffer fStringBuffer;
    protected DataStore fDataStore;
    protected EntityDeclPool fEntityDeclPool;
    private int fRootElementTypeHandle;
    private int fPublicIDHandle;
    private int fSystemIDHandle;
    protected XMLString fTempString;
    protected int fEnumerationTypeList;
    protected QName[] fDefaultAttrNames;
    private int fDefaultAttrNamesCount;
    private XMLString[] fDefaultAttValues;
    private int fDefaultAttValuesCount;
    private boolean fHaveAttDefs;
    private IntegerHashtable fAttDefs;
    private boolean fHaveElementContentElements;
    private IntegerHashtable fElementContentElements;

    public DTDGrammar(SymbolTable symbolTable, DataBufferFactory dataBufferFactory) {
        this.fSymbolTable = symbolTable;
        this.fEntityDeclPool = new EntityDeclPool(this.fSymbolTable);
        this.fStringBuffer = new XMLStringBuffer(dataBufferFactory);
        this.fDataStore = new DataStore();
        this.fTempString = new XMLString();
        this.fDefaultAttrNames = new QName[16];
        this.fDefaultAttValues = new XMLString[16];
    }

    public void reset(boolean bl) {
        this.fEntityDeclPool.reset(bl);
        this.fStringBuffer.reset(bl);
        this.fDataStore.reset(bl);
        if (this.fHaveElementContentElements) {
            this.fElementContentElements.clear(bl);
            this.fHaveElementContentElements = false;
            if (!bl) {
                this.fElementContentElements = null;
            }
        }
        if (this.fHaveAttDefs) {
            this.fAttDefs.clear(bl);
            this.fHaveAttDefs = false;
            if (!bl) {
                int n;
                for (n = 0; n < this.fDefaultAttrNamesCount; ++n) {
                    this.fDefaultAttrNames[n] = null;
                }
                for (n = 0; n < this.fDefaultAttValuesCount; ++n) {
                    this.fDefaultAttValues[n] = null;
                }
            }
            this.fDefaultAttrNamesCount = 0;
            this.fDefaultAttValuesCount = 0;
        }
    }

    public EntityDeclPool getEntityDeclPool() {
        return this.fEntityDeclPool;
    }

    public XMLStringBuffer getStringBuffer() {
        return this.fStringBuffer;
    }

    public void setDescription(int n, int n2, int n3) {
        this.fRootElementTypeHandle = n;
        this.fPublicIDHandle = n2;
        this.fSystemIDHandle = n3;
    }

    public void addGrammarToCache(DTDGrammarCache dTDGrammarCache) {
        dTDGrammarCache.addGrammar(this, this.fRootElementTypeHandle, this.fPublicIDHandle, this.fSystemIDHandle);
    }

    public boolean hasElementContentElements() {
        return this.fHaveElementContentElements;
    }

    public boolean hasElementContent(int n) {
        return this.fElementContentElements.get(n) != -1;
    }

    public void setElementContentElement(int n) {
        if (this.fElementContentElements == null) {
            this.fElementContentElements = new IntegerHashtable();
        }
        this.fElementContentElements.put(n, 1);
        this.fHaveElementContentElements = true;
    }

    public boolean hasAttDefs() {
        return this.fHaveAttDefs;
    }

    public void addDefaultAttributes(DTDScannerHelper dTDScannerHelper, QName qName, NSDeclList nSDeclList, AttrList attrList, boolean bl, boolean bl2) {
        int n = qName.handle;
        int n2 = this.getAttDefs(n);
        if (n2 == -1) {
            return;
        }
        int n3 = this.attDefsCount(n2);
        int[] nArray = this.attDefsArray(n2);
        int n4 = this.attDefsBase(n2);
        int n5 = 1;
        int n6 = attrList.attributeCount();
        int n7 = bl ? nSDeclList.nsDeclCount() : 0;
        for (int i = 0; i < n3; ++i) {
            XMLString xMLString;
            int n8;
            boolean bl3;
            int n9 = nArray[n4 + i];
            int[] nArray2 = this.attDefArray(n9);
            int n10 = this.attDefBase(n9);
            int n11 = nArray2[n10 + 1];
            int n12 = nArray2[n10 + 2];
            int n13 = nArray2[n10 + 4];
            boolean bl4 = n13 != -1;
            boolean bl5 = n11 != 14;
            boolean bl6 = bl3 = n12 == 24;
            if (!bl4 && !bl5 && !bl3) continue;
            int n14 = nArray2[n10 + 0];
            QName qName2 = this.defaultAttrName(n14);
            XMLString xMLString2 = this.defaultAttValue(n13);
            boolean bl7 = false;
            if (bl && (qName2.localHandle == n5 || qName2.prefixHandle == n5)) {
                for (n8 = 0; n8 < n7; ++n8) {
                    int n15 = nSDeclList.nsDeclQName(n8);
                    if (qName2.handle != n15) continue;
                    if (n12 == 23) {
                        xMLString = xMLString2;
                        this.fSymbolTable.setStringValues(nSDeclList.nsDeclURI(n8), this.fTempString);
                        this.checkFixedAttValue(dTDScannerHelper, qName, qName2, this.fTempString, xMLString);
                    }
                    if (bl5) {
                        int n16 = this.fStringBuffer.getOffset();
                        this.fSymbolTable.appendToBuffer(nSDeclList.nsDeclURI(n8), this.fStringBuffer);
                        int n17 = this.fStringBuffer.getOffset();
                        this.fStringBuffer.setStringValues(n16, n17, this.fTempString);
                        this.fStringBuffer.normalizeTextValue(this.fTempString, null);
                        dTDScannerHelper.setNSDeclURI(n8, this.fSymbolTable.addSymbol(this.fTempString));
                    }
                    bl7 = true;
                    break;
                }
                if (bl7) continue;
                if (bl3) {
                    this.requiredAttributeNotSpecified(dTDScannerHelper, qName, qName2);
                }
                if (!bl4) continue;
                this.addDefaultNSDecl(dTDScannerHelper, qName, nSDeclList, qName2, xMLString2, n9, bl2);
                continue;
            }
            for (n8 = 0; n8 < n6; ++n8) {
                if (qName2.handle != attrList.attributeName((int)n8).handle) continue;
                if (n12 == 23) {
                    XMLString xMLString3 = attrList.attributeValue(n8);
                    xMLString = xMLString2;
                    this.checkFixedAttValue(dTDScannerHelper, qName, qName2, xMLString3, xMLString);
                }
                if (bl5) {
                    attrList.setAttributeValueNormalized(n8, false);
                    dTDScannerHelper.setAttributeType(n8, n11);
                }
                bl7 = true;
                break;
            }
            if (bl7) continue;
            if (bl3) {
                this.requiredAttributeNotSpecified(dTDScannerHelper, qName, qName2);
            }
            if (!bl4) continue;
            this.addDefaultAttribute(dTDScannerHelper, qName, attrList, qName2, n11, xMLString2, n9, bl2);
        }
    }

    protected void checkFixedAttValue(ErrorReporter errorReporter, QName qName, QName qName2, XMLString xMLString, XMLString xMLString2) {
    }

    protected void requiredAttributeNotSpecified(ErrorReporter errorReporter, QName qName, QName qName2) {
    }

    protected boolean addDefaultNSDecl(DTDScannerHelper dTDScannerHelper, QName qName, NSDeclList nSDeclList, QName qName2, XMLString xMLString, int n, boolean bl) {
        return dTDScannerHelper.addDefaultNSDecl(qName2, xMLString);
    }

    protected boolean addDefaultAttribute(DTDScannerHelper dTDScannerHelper, QName qName, AttrList attrList, QName qName2, int n, XMLString xMLString, int n2, boolean bl) {
        return dTDScannerHelper.addDefaultAttribute(qName2, n, xMLString);
    }

    protected int getAttDefs(int n) {
        return this.fHaveAttDefs ? this.fAttDefs.get(n) : -1;
    }

    protected int attDefsCount(int n) {
        return this.fDataStore.getListCount(n);
    }

    protected int[] attDefsArray(int n) {
        return this.fDataStore.getListArray(n);
    }

    protected int attDefsBase(int n) {
        return this.fDataStore.getListBase(n);
    }

    protected int[] attDefArray(int n) {
        return this.fDataStore.getRecordArray(n);
    }

    protected int attDefBase(int n) {
        return this.fDataStore.getRecordBase(n);
    }

    public QName attDefAttrName(int n) {
        int[] nArray = this.attDefArray(n);
        int n2 = this.attDefBase(n);
        int n3 = nArray[n2 + 0];
        QName qName = this.defaultAttrName(n3);
        return qName;
    }

    public XMLString attDefAttValue(int n) {
        int[] nArray = this.attDefArray(n);
        int n2 = this.attDefBase(n);
        int n3 = nArray[n2 + 4];
        XMLString xMLString = this.defaultAttValue(n3);
        return xMLString;
    }

    protected boolean attDefIsExternal(int n) {
        int n2;
        int[] nArray = this.fDataStore.getRecordArray(n);
        return nArray[(n2 = this.fDataStore.getRecordBase(n)) + 5] != 0;
    }

    private QName defaultAttrName(int n) {
        return this.fDefaultAttrNames[n];
    }

    private XMLString defaultAttValue(int n) {
        return n != -1 ? this.fDefaultAttValues[n] : null;
    }

    public int lookupAttDef(QName qName, QName qName2) {
        int n;
        int n2;
        if (this.fHaveAttDefs && (n2 = this.fAttDefs.get(n = qName.handle)) != -1) {
            int n3 = this.fDataStore.getListCount(n2);
            int[] nArray = this.fDataStore.getListArray(n2);
            int n4 = this.fDataStore.getListBase(n2);
            int n5 = qName2.handle;
            for (int i = 0; i < n3; ++i) {
                int n6 = nArray[n4 + i];
                int[] nArray2 = this.fDataStore.getRecordArray(n6);
                int n7 = this.fDataStore.getRecordBase(n6);
                int n8 = nArray2[n7 + 0];
                if (n5 != this.fDefaultAttrNames[n8].handle) continue;
                return n6;
            }
        }
        return -1;
    }

    public void startAttDef(QName qName, XMLString xMLString) {
        this.fEnumerationTypeList = -1;
    }

    public void enumerationType(XMLString xMLString, ErrorReporter errorReporter) {
        this.fEnumerationTypeList = this.fDataStore.addToList(this.fEnumerationTypeList, this.fSymbolTable.addSymbol(xMLString));
    }

    public void saveAttDef(QName qName, QName qName2, XMLString xMLString, XMLString xMLString2, XMLString xMLString3, boolean bl, ErrorReporter errorReporter) {
        Object[] objectArray;
        int n = qName.handle;
        int n2 = qName2.handle;
        int n3 = this.fHaveAttDefs ? this.fAttDefs.get(n) : -1;
        int n4 = this.fDataStore.allocateRecord(6);
        int[] nArray = this.fDataStore.getRecordArray(n4);
        int n5 = this.fDataStore.getRecordBase(n4);
        if ((n2 = this.fDefaultAttrNamesCount++) == this.fDefaultAttrNames.length) {
            objectArray = new QName[n2 << 1];
            System.arraycopy(this.fDefaultAttrNames, 0, objectArray, 0, n2);
            this.fDefaultAttrNames = objectArray;
            this.fDefaultAttrNames[n2] = new QName(qName2);
        } else if (this.fDefaultAttrNames[n2] == null) {
            this.fDefaultAttrNames[n2] = new QName(qName2);
        } else {
            this.fDefaultAttrNames[n2].setValues(qName2);
        }
        nArray[n5 + 0] = n2;
        int n6 = xMLString != null ? this.fSymbolTable.addSymbol(xMLString) : -1;
        int n7 = xMLString2 != null ? this.fSymbolTable.addSymbol(xMLString2) : -1;
        nArray[n5 + 1] = n6;
        nArray[n5 + 2] = n7;
        nArray[n5 + 3] = this.fEnumerationTypeList;
        if (xMLString3 != null) {
            if (n6 != 14) {
                this.normalizeDefaultAttValue(qName2, xMLString3, n6, n4, errorReporter);
            }
            if (this.fDefaultAttValuesCount == this.fDefaultAttValues.length) {
                objectArray = new XMLString[this.fDefaultAttValuesCount << 1];
                System.arraycopy(this.fDefaultAttValues, 0, objectArray, 0, this.fDefaultAttValuesCount);
                this.fDefaultAttValues = objectArray;
                this.fDefaultAttValues[this.fDefaultAttValuesCount] = new XMLString(xMLString3);
            } else if (this.fDefaultAttValues[this.fDefaultAttValuesCount] == null) {
                this.fDefaultAttValues[this.fDefaultAttValuesCount] = new XMLString(xMLString3);
            } else {
                this.fDefaultAttValues[this.fDefaultAttValuesCount].setValues(xMLString3);
            }
            nArray[n5 + 4] = n2 = this.fDefaultAttValuesCount++;
        } else {
            nArray[n5 + 4] = -1;
        }
        int n8 = nArray[n5 + 5] = bl ? 1 : 0;
        if (n3 == -1) {
            n3 = this.fDataStore.addToList(-1, n4);
            if (this.fAttDefs == null) {
                this.fAttDefs = new IntegerHashtable();
            }
            this.fAttDefs.put(n, n3);
            this.fHaveAttDefs = true;
        } else {
            this.fDataStore.addToList(n3, n4);
        }
    }

    protected void normalizeDefaultAttValue(QName qName, XMLString xMLString, int n, int n2, ErrorReporter errorReporter) {
        this.fStringBuffer.normalizeTextValue(xMLString, null);
    }
}

