/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MimeTypeFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.activation.FileTypeMap;
import javax.activation.SecuritySupport;

public class MimetypesFileTypeMap
extends FileTypeMap {
    private static MimeTypeFile defDB = null;
    private MimeTypeFile[] DB;
    private static final int PROG = 0;
    private static String defaultType = "application/octet-stream";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimetypesFileTypeMap() {
        Vector<MimeTypeFile> dbv = new Vector<MimeTypeFile>(5);
        MimeTypeFile mf = null;
        dbv.addElement(null);
        LogSupport.log("MimetypesFileTypeMap: load HOME");
        try {
            String path;
            String user_home = System.getProperty("user.home");
            if (user_home != null && (mf = this.loadFile(path = user_home + File.separator + ".mime.types")) != null) {
                dbv.addElement(mf);
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        LogSupport.log("MimetypesFileTypeMap: load SYS");
        try {
            String system_mimetypes = System.getProperty("java.home") + File.separator + "lib" + File.separator + "mime.types";
            mf = this.loadFile(system_mimetypes);
            if (mf != null) {
                dbv.addElement(mf);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LogSupport.log("MimetypesFileTypeMap: load JAR");
        this.loadAllResources(dbv, "META-INF/mime.types");
        LogSupport.log("MimetypesFileTypeMap: load DEF");
        Class clazz = MimetypesFileTypeMap.class;
        synchronized (clazz) {
            if (defDB == null) {
                defDB = this.loadResource("/META-INF/mimetypes.default");
            }
        }
        if (defDB != null) {
            dbv.addElement(defDB);
        }
        this.DB = new MimeTypeFile[dbv.size()];
        dbv.copyInto(this.DB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private MimeTypeFile loadResource(String name2) {
        block23: {
            InputStream clis;
            block22: {
                block20: {
                    clis = null;
                    clis = SecuritySupport.getInstance().getResourceAsStream(this.getClass(), name2);
                    if (clis == null) break block20;
                    MimeTypeFile mf = new MimeTypeFile(clis);
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("MimetypesFileTypeMap: successfully loaded mime types file: " + name2);
                    }
                    MimeTypeFile mimeTypeFile = mf;
                    Object var6_7 = null;
                    try {
                        if (clis != null) {
                            clis.close();
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    return mimeTypeFile;
                }
                if (!LogSupport.isLoggable()) break block22;
                LogSupport.log("MimetypesFileTypeMap: not loading mime types file: " + name2);
            }
            Object var6_8 = null;
            try {
                if (clis != null) {
                    clis.close();
                }
                break block23;
            }
            catch (IOException ex) {}
            break block23;
            {
                catch (IOException e) {
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("MimetypesFileTypeMap: can't load " + name2, e);
                    }
                    Object var6_9 = null;
                    try {
                        if (clis != null) {
                            clis.close();
                        }
                        break block23;
                    }
                    catch (IOException ex) {}
                    break block23;
                }
                catch (SecurityException sex) {
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("MimetypesFileTypeMap: can't load " + name2, sex);
                    }
                    Object var6_10 = null;
                    try {
                        if (clis != null) {
                            clis.close();
                        }
                        break block23;
                    }
                    catch (IOException ex) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                try {
                    if (clis != null) {
                        clis.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadAllResources(Vector v, String name2) {
        boolean anyLoaded;
        block23: {
            anyLoaded = false;
            try {
                URL[] urls;
                ClassLoader cld = null;
                cld = SecuritySupport.getInstance().getContextClassLoader();
                if (cld == null) {
                    cld = this.getClass().getClassLoader();
                }
                if ((urls = cld != null ? SecuritySupport.getInstance().getResources(cld, name2) : SecuritySupport.getInstance().getSystemResources(name2)) == null) break block23;
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MimetypesFileTypeMap: getResources");
                }
                for (int i = 0; i < urls.length; ++i) {
                    InputStream clis;
                    URL url;
                    block24: {
                        url = urls[i];
                        clis = null;
                        if (LogSupport.isLoggable()) {
                            LogSupport.log("MimetypesFileTypeMap: URL " + url);
                        }
                        clis = SecuritySupport.getInstance().openStream(url);
                        if (clis != null) {
                            v.addElement(new MimeTypeFile(clis));
                            anyLoaded = true;
                            if (LogSupport.isLoggable()) {
                                LogSupport.log("MimetypesFileTypeMap: successfully loaded mime types from URL: " + url);
                            }
                            break block24;
                        }
                        if (!LogSupport.isLoggable()) break block24;
                        LogSupport.log("MimetypesFileTypeMap: not loading mime types from URL: " + url);
                    }
                    Object var11_13 = null;
                    try {
                        if (clis == null) continue;
                        clis.close();
                    }
                    catch (IOException cex) {}
                    continue;
                    {
                        catch (IOException ioex) {
                            if (LogSupport.isLoggable()) {
                                LogSupport.log("MimetypesFileTypeMap: can't load " + url, ioex);
                            }
                            var11_13 = null;
                            try {
                                if (clis == null) continue;
                                clis.close();
                            }
                            catch (IOException cex) {}
                            continue;
                        }
                        catch (SecurityException sex) {
                            if (LogSupport.isLoggable()) {
                                LogSupport.log("MimetypesFileTypeMap: can't load " + url, sex);
                            }
                            var11_13 = null;
                            try {
                                if (clis == null) continue;
                                clis.close();
                            }
                            catch (IOException cex) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var11_13 = null;
                        try {
                            if (clis != null) {
                                clis.close();
                            }
                        }
                        catch (IOException cex) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            catch (Exception ex) {
                if (!LogSupport.isLoggable()) break block23;
                LogSupport.log("MimetypesFileTypeMap: can't load " + name2, ex);
            }
        }
        if (!anyLoaded) {
            LogSupport.log("MimetypesFileTypeMap: !anyLoaded");
            MimeTypeFile mf = this.loadResource("/" + name2);
            if (mf != null) {
                v.addElement(mf);
            }
        }
    }

    private MimeTypeFile loadFile(String name2) {
        MimeTypeFile mtf = null;
        try {
            mtf = new MimeTypeFile(name2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mtf;
    }

    public MimetypesFileTypeMap(String mimeTypeFileName) throws IOException {
        this();
        this.DB[0] = new MimeTypeFile(mimeTypeFileName);
    }

    public MimetypesFileTypeMap(InputStream is) {
        this();
        try {
            this.DB[0] = new MimeTypeFile(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void addMimeTypes(String mime_types) {
        if (this.DB[0] == null) {
            this.DB[0] = new MimeTypeFile();
        }
        this.DB[0].appendToRegistry(mime_types);
    }

    public String getContentType(File f) {
        return this.getContentType(f.getName());
    }

    public synchronized String getContentType(String filename) {
        int dot_pos = filename.lastIndexOf(".");
        if (dot_pos < 0) {
            return defaultType;
        }
        String file_ext = filename.substring(dot_pos + 1);
        if (file_ext.length() == 0) {
            return defaultType;
        }
        for (int i = 0; i < this.DB.length; ++i) {
            String result;
            if (this.DB[i] == null || (result = this.DB[i].getMIMETypeString(file_ext)) == null) continue;
            return result;
        }
        return defaultType;
    }
}

