/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;

public abstract class XMIHandler
extends XMLHandler {
    protected static final String XMI_ELEMENT_TYPE = "xmi";
    protected static final String XMI_UUID = "uuid";
    protected static final String XMI_EXTENSION = "Extension";
    protected static final String XMI_TYPE_ATTRIB = "xmi:type";
    protected static final String ID_ATTRIB = "xmi:id";
    protected static final String VERSION_ATTRIB = "xmi:version";
    protected static final String UUID_ATTRIB = "xmi:uuid";
    protected static final String XMI_ELEMENT_NAME = "xmi:XMI";

    public XMIHandler(XMLResource xmiResource, XMLHelper helper, Map options) {
        super(xmiResource, helper, options);
        this.hrefAttribute = "href";
        this.notFeatures.add(VERSION_ATTRIB);
        this.notFeatures.add(XMI_TYPE_ATTRIB);
        this.notFeatures.add(UUID_ATTRIB);
    }

    protected void processElement(String name2, String prefix, String localName) {
        if (localName.equals("XMI")) {
            this.types.push(XMI_ELEMENT_TYPE);
            String namespace = this.helper.getURI(XMI_ELEMENT_TYPE);
            if (namespace != null && namespace.startsWith("http://schema.omg.org/spec/XMI/")) {
                ((XMIResource)this.xmlResource).setXMIVersion(namespace.substring("http://schema.omg.org/spec/XMI/".length()));
            }
            this.isRoot = false;
        } else if (this.isRoot) {
            String namespace = this.helper.getURI(XMI_ELEMENT_TYPE);
            if (namespace != null && namespace.startsWith("http://schema.omg.org/spec/XMI/")) {
                ((XMIResource)this.xmlResource).setXMIVersion(namespace.substring("http://schema.omg.org/spec/XMI/".length()));
            }
            super.processElement(name2, prefix, localName);
        } else {
            super.processElement(name2, prefix, localName);
        }
    }

    protected boolean isTextFeatureValue(Object type) {
        return super.isTextFeatureValue(type) && type != XMI_ELEMENT_TYPE;
    }

    protected EObject createDocumentRoot(String prefix, String uri, String name2, EFactory eFactory, boolean top) {
        if (this.extendedMetaData != null && eFactory != null && this.extendedMetaData.demandedPackages().contains(eFactory.getEPackage())) {
            EClass eClass = (EClass)this.extendedMetaData.demandType(uri, name2);
            EObject newObject = null;
            newObject = this.useNewMethods ? this.createObject(eFactory, eClass, true) : this.helper.createObject(eFactory, name2);
            this.validateCreateObjectFromFactory(eFactory, name2, newObject);
            this.handleObjectAttribs(newObject);
            if (top) {
                this.processTopObject(newObject);
            }
            return newObject;
        }
        return super.createDocumentRoot(prefix, uri, name2, eFactory, top);
    }

    protected void handleUnknownFeature(String prefix, String name2, boolean isElement, EObject peekObject, String value2) {
        if (XMI_EXTENSION.equals(name2) && "http://www.omg.org/XMI".equals(this.helper.getURI(prefix))) {
            if (this.extendedMetaData == null) {
                this.setExtendedMetaDataOption(Boolean.TRUE);
            }
            this.recordUnknownFeature(prefix, name2, isElement, peekObject, value2);
        } else {
            super.handleUnknownFeature(prefix, name2, isElement, peekObject, value2);
        }
    }
}

