/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.editors;

import com.ibm.fmi.model.Record;
import com.ibm.fmi.ui.UiPlugin;
import com.ibm.fmi.ui.editors.FileManagerIntegrationEditor;
import com.ibm.fmi.ui.editors.ICellEditorElementValidator;
import com.ibm.fmi.ui.providers.HexFieldWrapper;
import com.ibm.fmi.ui.providers.HexRecordWrapper;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPropertyListener;

public class FieldCellEditor
extends CellEditor
implements IPropertyListener {
    private Table table;
    private TableViewer viewer;
    private Text text;
    private boolean isOverwriteMode = false;
    private int column;
    private int storedPosition = 0;

    public FieldCellEditor(TableViewer viewer, int style, int column) {
        super((Composite)viewer.getTable(), style);
        this.viewer = viewer;
        this.table = viewer.getTable();
        this.column = column;
    }

    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 4);
        FormLayout fLayout = new FormLayout();
        fLayout.marginLeft = 5;
        fLayout.marginRight = 6;
        composite.setLayout((Layout)fLayout);
        this.text = new Text(composite, this.getStyle());
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.text.setLayoutData((Object)data);
        this.text.setFont(parent.getFont());
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                FieldCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FieldCellEditor.this.editOccurred(e);
            }
        });
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
            }

            public void focusLost(FocusEvent arg0) {
                FieldCellEditor.this.focusLost();
            }
        });
        return composite;
    }

    protected void editOccurred(ModifyEvent e) {
        boolean oldValid = this.isValueValid();
        boolean newValid = this.isCorrect(this.doGetValue());
        if (!newValid) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.text.getText()));
        }
        if (oldValid != newValid) {
            this.valueChanged(oldValid, newValid);
        }
    }

    protected Object doGetValue() {
        return this.text.getText();
    }

    protected void focusLost() {
        if (this.isValueValid()) {
            this.fireApplyEditorValue();
            this.deactivate();
        } else {
            this.fireCancelEditor();
        }
    }

    protected void doSetFocus() {
        this.text.setFocus();
        if (this.storedPosition != 0) {
            this.text.setSelection(this.storedPosition);
            this.storedPosition = 0;
        }
    }

    protected void doSetValue(Object value) {
        if (value instanceof String) {
            this.text.setText((String)value);
        } else {
            UiPlugin.trace(1, (Object)this, UiPlugin.getString("Editor.Cell.warning.type", new Object[]{value, value.getClass().getName()}), null);
            this.text.setText(value.toString());
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.doit && (keyEvent.keyCode == 0x1000001 || keyEvent.keyCode == 0x1000002)) {
            int index;
            int dir = 0;
            dir = keyEvent.keyCode == 0x1000001 ? -1 : 1;
            int origIndex = index = this.table.getSelectionIndex();
            int count = this.table.getItemCount();
            Object obj = null;
            do {
                if (index + dir < 0 || index + dir > count - 1) {
                    if (this.table.getSelectionIndex() != origIndex) {
                        this.table.setSelection(origIndex);
                    }
                    keyEvent.doit = false;
                    return;
                }
                obj = this.viewer.getElementAt(index += dir);
                if (obj != null) continue;
                this.table.setSelection(index);
                obj = this.viewer.getElementAt(index);
            } while (!(obj instanceof Record));
            if (this.isValueValid()) {
                this.fireApplyEditorValue();
                this.deactivate();
            } else {
                this.fireCancelEditor();
            }
            this.storedPosition = this.text.getCaretPosition();
            this.viewer.editElement(obj, this.column);
            keyEvent.doit = false;
        } else if (keyEvent.keyCode == 0x1000003) {
            if (this.text.getCaretPosition() == 0 && this.column > 1) {
                this.viewer.editElement(this.viewer.getElementAt(this.table.getSelectionIndex()), this.column - 1);
                Text widget = ((FieldCellEditor)this.viewer.getCellEditors()[this.column - 1]).getText();
                widget.setSelection(widget.getText().length());
                keyEvent.doit = false;
            }
        } else if (keyEvent.keyCode == 0x1000004) {
            if (this.text.getCaretPosition() == this.text.getText().length() && this.column + 1 < this.viewer.getCellEditors().length) {
                this.viewer.editElement(this.viewer.getElementAt(this.table.getSelectionIndex()), this.column + 1);
                keyEvent.doit = false;
            }
        } else if (keyEvent.character == '\r') {
            if (!this.isValueValid()) {
                keyEvent.doit = false;
            }
        } else if ((Character.isJavaIdentifierPart(keyEvent.character) || keyEvent.character == ' ') && !Character.isIdentifierIgnorable(keyEvent.character)) {
            int pos;
            Object obj = this.table.getSelection()[0].getData();
            int textLimit = this.text.getTextLimit();
            if (obj instanceof HexRecordWrapper) {
                if (this.column != -1) {
                    Record rec = ((HexRecordWrapper)obj).getRecord();
                    textLimit = rec.getDisplayField(this.column - 1).getActualEbcdicWidth();
                }
            } else if (obj instanceof HexFieldWrapper) {
                textLimit = ((HexFieldWrapper)obj).getField().getActualEbcdicWidth();
            }
            if ((pos = this.text.getCaretPosition()) >= textLimit && this.text.getSelectionCount() == 0) {
                keyEvent.doit = false;
                return;
            }
            if (this.isOverwriteMode) {
                if (this.text.getSelectionCount() == 0) {
                    this.text.setSelection(pos, pos + 1);
                }
            } else if (this.text.getSelectionCount() == 0 && textLimit <= this.text.getText().length()) {
                if (this.text.getText().endsWith(" ")) {
                    String str = this.text.getText();
                    this.text.setText(str.substring(0, str.length() - 1));
                    this.text.setSelection(pos);
                } else {
                    keyEvent.doit = false;
                }
            }
        }
        super.keyReleaseOccured(keyEvent);
    }

    public void performCopy() {
        this.text.copy();
    }

    public void performCut() {
        this.text.cut();
    }

    public void performDelete() {
        if (this.text.getSelectionCount() > 0) {
            this.text.insert("");
        } else {
            int pos = this.text.getCaretPosition();
            if (pos < this.text.getText().length() - 1) {
                this.text.setSelection(pos, pos + 1);
                this.text.insert("");
            }
        }
    }

    protected boolean isCorrect(Object value) {
        if (this.getValidator() != null && this.getValidator() instanceof ICellEditorElementValidator) {
            TableItem item = this.table.getSelection()[0];
            this.setErrorMessage(((ICellEditorElementValidator)this.getValidator()).isValid(item, value));
            return this.getErrorMessage() == null || this.getErrorMessage().equals("");
        }
        return super.isCorrect(value);
    }

    public void performPaste() {
        this.text.paste();
    }

    public void performSelectAll() {
        this.text.selectAll();
    }

    public boolean isCopyEnabled() {
        return true;
    }

    public boolean isCutEnabled() {
        return true;
    }

    public boolean isDeleteEnabled() {
        return true;
    }

    public boolean isPasteEnabled() {
        return true;
    }

    public boolean isSelectAllEnabled() {
        return true;
    }

    public void setOverwriteMode(boolean isOverwriteMode) {
        this.isOverwriteMode = isOverwriteMode;
    }

    protected int insertHelp(int index) {
        String str = this.text.getText();
        int i = str.length();
        while (i > index && str.charAt(i - 1) == ' ') {
            --i;
        }
        return this.text.getTextLimit() - i;
    }

    public boolean insert(String str) {
        Point sel = this.text.getSelection();
        int remove = str.length() - this.text.getSelectionCount();
        if (remove > this.insertHelp(sel.y)) {
            return false;
        }
        String newString = String.valueOf(this.text.getText(0, sel.x)) + str + this.text.getText(sel.y, this.text.getText().length() - remove);
        this.text.setText(newString);
        sel.y = sel.x + str.length();
        this.text.setSelection(sel);
        return true;
    }

    public void propertyChanged(Object source, int propId) {
        if (2050 == propId && source instanceof FileManagerIntegrationEditor) {
            this.setOverwriteMode(((FileManagerIntegrationEditor)((Object)source)).isOverwriteMode());
        }
    }

    public Text getText() {
        return this.text;
    }
}

