/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.FieldGroupVarArray;
import com.ibm.fmi.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;

public class DefiningObject
extends Field {
    public final int NO_BOUND = -1;
    public final int NO_VALUE = -1;
    private int upperBound = -1;
    private int lowerBound = -1;
    private int value = -1;
    private FieldGroupVarArray tgtArray = null;

    public DefiningObject(String name, int level, int recordOffset, int length, int numSlackBytes, int symbol, boolean isAligned, IFMIDataTypeConverter converter, Object[] conversionParameters, int lowerBound, int upperBound) throws FMIConversionException, FMIModelException {
        super(name, level, recordOffset, length, numSlackBytes, symbol, isAligned, converter, conversionParameters);
        if (!converter.isNumeric() || lowerBound < 0 || upperBound < lowerBound) {
            throw new FMIModelException("Invalid field array definition");
        }
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
        this.editable = false;
        this.empty = false;
        this.hasContent = true;
    }

    public int setEbcdic(byte[] ebcdic, int decrement, boolean initializing, boolean forceVal, boolean fireEvent) throws FMIConversionException, FMIKeyException, FMIModelException {
        super.setEbcdic(ebcdic, decrement, initializing, forceVal, fireEvent);
        this.value = Integer.parseInt(this.strValue);
        this.tgtArray.setSize(this.value);
        return 0;
    }

    public void setASCIIStr(String ascii, boolean fireEvent) throws FMIConversionException, FMIKeyException, FMIModelException {
        super.setASCIIStr(ascii, fireEvent);
        this.tgtArray.setSize(Integer.parseInt(this.strValue));
    }

    public DefiningObject copy() {
        try {
            DefiningObject copy = new DefiningObject(this.name, this.level, this.recordOffset, this.ebcdicWidth, this.numSlackBytes, this.symbol, this.isAligned, this.converter, this.conversionParams, this.lowerBound, this.upperBound);
            copy.editable = false;
            copy.empty = false;
            copy.hasRedefine = this.hasRedefine;
            copy.displayOrder = this.displayOrder;
            copy.setStartLayoutIndex(this.startLayoutIndex);
            copy.tgtArray = this.tgtArray;
            copy.upperBound = this.upperBound;
            copy.lowerBound = this.lowerBound;
            return copy;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setConverter(IFMIDataTypeConverter converter) throws FMIModelException {
        if (converter == null || !converter.isNumeric()) {
            throw new FMIModelException("Targer converter does not return integer values");
        }
        this.converter = converter;
    }

    public void validateEBCDICchange(byte[] ebcdic) throws FMIConversionException, FMIModelException, FMIKeyException {
        super.validateEBCDICchange(ebcdic);
        String tempStr = this.converter.EBCDICtoASCIIstr(ebcdic, this.maxAsciiWidth, this.conversionParams);
        this.checkSpecialCriteria(tempStr, null);
    }

    public void validateASCIIchange(String ascii) throws FMIConversionException, FMIModelException, FMIKeyException {
        super.validateASCIIchange(ascii);
        this.checkSpecialCriteria(ascii, null);
    }

    protected boolean checkSpecialCriteria(String stringValue, byte[] ebcdicValue) throws FMIModelException {
        try {
            int tempVal = Integer.parseInt(stringValue);
            if (tempVal > this.upperBound || tempVal < this.lowerBound) {
                throw new FMIModelException("Invalid defining object value");
            }
        }
        catch (Exception exception) {
            throw new FMIModelException("Targer converter does not return integer values");
        }
        return true;
    }

    public void setTgtArray(FieldGroupVarArray tgtArray) {
        this.tgtArray = tgtArray;
    }

    public FieldGroupVarArray getTgtArray() {
        return this.tgtArray;
    }

    public int getNumericValue() {
        return this.value;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public int getTargetStartLayoutIndex() {
        return this.tgtArray == null ? -1 : this.tgtArray.getStartLayoutIndex();
    }

    public int getTargetEndLayoutIndex() {
        return this.tgtArray == null ? -1 : this.tgtArray.getEndLayoutIndex();
    }
}

