/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.datatypeconverters;

import com.ibm.fmi.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.fmi.model.exception.FMIConversionException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FMIAlphaNumericDataTypeConverter
implements IFMIDataTypeConverter {
    private static final char UNKNOWN_CHAR = '\u25ad';
    private static final byte UNKNOWN_EBCDIC = 63;
    private static final String EXTRA_CHARS = "!@#$%^&*(){}[];:'\",<.>/?\\|`~_-+=";

    public byte[] ASCIIstrToEBCDIC(String asciiString, byte[] oldEBCDIC, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        if (asciiString == null) {
            asciiString = new String("");
        }
        try {
            int i;
            if (asciiString.length() < tgtWidth) {
                StringBuffer buffer = new StringBuffer(asciiString);
                i = buffer.length();
                while (i < tgtWidth) {
                    buffer.append(" ");
                    ++i;
                }
                asciiString = buffer.toString();
            }
            byte[] ebcdic = asciiString.getBytes("Cp1047");
            if (oldEBCDIC != null && ebcdic.length != oldEBCDIC.length) {
                throw new FMIConversionException("INTERNAL ERROR");
            }
            if (oldEBCDIC != null) {
                i = 0;
                while (i < ebcdic.length) {
                    if (asciiString.charAt(i) == '\u25ad') {
                        ebcdic[i] = oldEBCDIC[i];
                    }
                    ++i;
                }
            }
            return ebcdic;
        }
        catch (Exception e) {
            throw new FMIConversionException("Conversion from ASCII to EBCDIC failed: " + e.getClass().getName());
        }
    }

    public String correctASCIIStringFormat(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        return asciiString;
    }

    public String EBCDICtoASCIIstr(byte[] EBCDICval, int maxStrLength, Object[] extraParams) throws FMIConversionException {
        try {
            StringBuffer stringRep = new StringBuffer(EBCDICval.length);
            ByteArrayInputStream byteStream = new ByteArrayInputStream(EBCDICval);
            InputStreamReader byteReader = new InputStreamReader((InputStream)byteStream, "Cp1047");
            int i = 0;
            while (i < EBCDICval.length) {
                int ch = byteReader.read();
                if (!Character.isLetterOrDigit((char)ch) && !Character.isSpaceChar((char)ch) && EXTRA_CHARS.indexOf(ch) == -1) {
                    ch = 9645;
                }
                stringRep.append((char)ch);
                ++i;
            }
            if (stringRep.length() > maxStrLength) {
                throw new FMIConversionException("Field data exceeds maximum display width: " + maxStrLength);
            }
            return stringRep.toString();
        }
        catch (Exception uee) {
            throw new FMIConversionException("Conversion from EBCDIC to ASCII failed: " + uee.getClass().getName());
        }
    }

    public boolean validateASCII(String ascii, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        if (tgtWidth < ascii.length()) {
            throw new FMIConversionException("Field data exceeds maximum display width");
        }
        return true;
    }

    public int getMaxASCIIWidth(int ebcdicWidth, Object[] extraParams) throws FMIConversionException {
        return ebcdicWidth;
    }

    public boolean isNumeric() {
        return false;
    }

    public String getSymbol() {
        return "AN";
    }

    public byte[] getDefaultValue(int length, Object[] extraparams) {
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = 64;
            ++i;
        }
        return bytes;
    }

    public boolean requiresFullWordBoundary(int length) {
        return false;
    }

    public boolean requiresHalfWordBoundary(int length) {
        return false;
    }
}

