/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.datatypeconverters;

import com.ibm.fmi.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.fmi.model.exception.FMIConversionException;
import java.nio.ByteBuffer;

public class FMIBinaryDataTypeConverter
implements IFMIDataTypeConverter {
    private String MSG_UNEXPECTED_DATA_SIZE = "Could not convert binary data to String.  Unexpected data size.";

    public byte[] ASCIIstrToEBCDIC(String asciiString, byte[] oldEBCDIC, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        try {
            ByteBuffer bytes = ByteBuffer.allocate(tgtWidth);
            byte[] tgtArr = new byte[tgtWidth];
            if (asciiString == null || asciiString.equals("")) {
                int i = 0;
                while (i < tgtArr.length) {
                    tgtArr[i] = 0;
                    ++i;
                }
            } else {
                if (tgtWidth == 8) {
                    bytes.putLong(0, Long.parseLong(asciiString));
                } else if (tgtWidth == 4) {
                    bytes.putInt(0, Integer.parseInt(asciiString));
                } else if (tgtWidth == 2) {
                    bytes.putShort(0, Short.parseShort(asciiString));
                }
                bytes.get(tgtArr, 0, tgtWidth);
            }
            return tgtArr;
        }
        catch (Exception e) {
            throw new FMIConversionException("Conversion from ASCII to EBCDIC failed: " + e.getClass().getName());
        }
    }

    public String correctASCIIStringFormat(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        int aIndex = asciiString.charAt(0) == '-' ? 1 : 0;
        while (aIndex < asciiString.length() && asciiString.charAt(aIndex) == '0') {
            String string = asciiString = aIndex == 0 ? asciiString.substring(aIndex + 1) : "-" + asciiString.substring(aIndex + 1);
        }
        return asciiString;
    }

    public String EBCDICtoASCIIstr(byte[] EBCDICval, int maxWidth, Object[] extraParams) throws FMIConversionException {
        String strVal = null;
        try {
            ByteBuffer bytes = ByteBuffer.allocate(EBCDICval.length);
            bytes.put(EBCDICval);
            if (EBCDICval.length == 8) {
                strVal = Long.toString(bytes.getLong(0));
            } else if (EBCDICval.length == 4) {
                strVal = Integer.toString(bytes.getInt(0));
            } else if (EBCDICval.length == 2) {
                strVal = Short.toString(bytes.getShort(0));
            }
        }
        catch (Exception e) {
            throw new FMIConversionException("Conversion from EBCDIC to ASCII failed: " + e.getClass().getName());
        }
        if (strVal == null) {
            throw new FMIConversionException(this.MSG_UNEXPECTED_DATA_SIZE);
        }
        if (strVal.length() > maxWidth) {
            throw new FMIConversionException("Field data exceeds maximum display width");
        }
        return strVal;
    }

    public boolean validateASCII(String ascii, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        int searchStartIndex;
        if (ascii == null || ascii.equals("")) {
            return true;
        }
        char[] charArr = ascii.toCharArray();
        boolean negative = ascii.charAt(0) == '-';
        int i = searchStartIndex = negative ? 1 : 0;
        while (i < charArr.length) {
            if (!Character.isDigit(charArr[i])) {
                throw new FMIConversionException("Invalid character");
            }
            ++i;
        }
        if (tgtWidth == 2 && (negative && ascii.length() > 6 || !negative && ascii.length() > 5) || tgtWidth == 4 && (negative && ascii.length() > 11 || !negative && ascii.length() > 10) || tgtWidth == 8 && (negative && ascii.length() > 20 || !negative && ascii.length() > 19)) {
            throw new FMIConversionException("Field data exceeds maximum display width");
        }
        return true;
    }

    public int getMaxASCIIWidth(int ebcdicWidth, Object[] extraParams) throws FMIConversionException {
        if (ebcdicWidth == 2) {
            return 6;
        }
        if (ebcdicWidth == 4) {
            return 11;
        }
        if (ebcdicWidth == 8) {
            return 20;
        }
        throw new FMIConversionException("Error determining maximum ASCII field length");
    }

    public boolean isNumeric() {
        return true;
    }

    public String getSymbol() {
        return "BI";
    }

    public byte[] getDefaultValue(int length, Object[] extraParams) {
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = 0;
            ++i;
        }
        return bytes;
    }

    public boolean requiresFullWordBoundary(int length) {
        return length >= 4;
    }

    public boolean requiresHalfWordBoundary(int length) {
        return length == 2;
    }
}

