/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.fm;

import com.ibm.fmi.model.ByteUtilities;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.fm.SecondarySegmentHeader;
import com.ibm.fmi.model.fm.Segment;
import com.ibm.fmi.model.fm.SegmentFactory;
import com.ibm.fmi.model.fm.SegmentHeader;
import java.nio.ByteBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyMemberSegment
extends Segment {
    private static final int MEMBER_NAME_LENGTH = 8;
    private static final int DATE_LENGTH = 8;
    private static final int TIME_LENGTH = 8;
    private static final int EXPRESSION_INVALID_BIT = 8;
    private static final int MULTIPLE_COPYBOOKS_BIT = 7;
    SecondarySegmentHeader secHeader;
    private String memberName;
    private String date;
    private String time;
    private int version;
    private byte flags;
    private boolean invalidExpression;
    private boolean multipleCopybooks;
    private int selectionSets;
    private int nextIndex;
    private int curSymbolIndex;
    private ArrayList<SymbolRef> symbolRefs = null;
    private ArrayList<Segment> associatedSegments = null;

    CopyMemberSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
        this.getAssociatedSegments(buf);
    }

    private void getAssociatedSegments(ByteBuffer buf) throws FMIParseException {
        SegmentHeader header = new SegmentHeader(buf);
        while (header.getLength() > 0 && header.getType() > 10 && header.getType() < 19) {
            Segment seg = SegmentFactory.buildSegment(header, buf);
            if (this.associatedSegments == null) {
                this.associatedSegments = new ArrayList();
            }
            this.associatedSegments.add(seg);
            header = new SegmentHeader(buf);
        }
    }

    @Override
    public void parse(ByteBuffer buf) throws FMIParseException {
        this.secHeader = new SecondarySegmentHeader(buf);
        try {
            this.memberName = ByteUtilities.getString(buf, 8);
            this.date = ByteUtilities.getString(buf, 8);
            this.time = ByteUtilities.getString(buf, 8);
        }
        catch (FMIConversionException fMIConversionException) {
            throw new FMIParseException();
        }
        this.version = buf.get();
        byte tempByte = buf.get();
        this.invalidExpression = ByteUtilities.testBit(tempByte, 8);
        this.multipleCopybooks = ByteUtilities.testBit(tempByte, 7);
        this.selectionSets = buf.get();
        this.nextIndex = buf.get();
        this.curSymbolIndex = buf.getInt();
        this.getSymbolRefs(buf);
    }

    private void getSymbolRefs(ByteBuffer buf) {
        this.symbolRefs = new ArrayList(this.secHeader.getNumChain());
        int i = 0;
        while (i < this.secHeader.getNumChain()) {
            SymbolRef newRef = new SymbolRef(buf);
            this.symbolRefs.add(newRef);
            ++i;
        }
    }

    public int getCurSymbolIndex() {
        return this.curSymbolIndex;
    }

    public String getDate() {
        return this.date;
    }

    public byte getFlags() {
        return this.flags;
    }

    public boolean isInvalidExpression() {
        return this.invalidExpression;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public boolean isMultipleCopybooks() {
        return this.multipleCopybooks;
    }

    public int getNextIndex() {
        return this.nextIndex;
    }

    public SecondarySegmentHeader getSecondaryHeader() {
        return this.secHeader;
    }

    public int getSelectionSets() {
        return this.selectionSets;
    }

    public ArrayList<SymbolRef> getSymbolRefs() {
        return this.symbolRefs;
    }

    public String getTime() {
        return this.time;
    }

    public int getVersion() {
        return this.version;
    }

    private class SymbolRef {
        private int symbol;
        private int minLen;
        private int maxLen;
        private int rexxOffset;
        private int templatePointersOffset;

        SymbolRef(ByteBuffer buf) {
            this.symbol = buf.getInt();
            this.minLen = buf.getInt();
            this.maxLen = buf.getInt();
            this.rexxOffset = buf.getInt();
            this.templatePointersOffset = buf.getInt();
        }

        public int getMaxLen() {
            return this.maxLen;
        }

        public int getMinLen() {
            return this.minLen;
        }

        public int getRexxOffset() {
            return this.rexxOffset;
        }

        public int getSymbol() {
            return this.symbol;
        }

        public int getTemplatePointersOffset() {
            return this.templatePointersOffset;
        }
    }
}

