/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.fm;

import com.ibm.fmi.model.DefiningObject;
import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.FieldGroup;
import com.ibm.fmi.model.FieldGroupArray;
import com.ibm.fmi.model.FieldGroupVarArray;
import com.ibm.fmi.model.IRecordLayoutBuilder;
import com.ibm.fmi.model.RecordLayout;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.datatypeconverters.FMIBinaryDataTypeConverter;
import com.ibm.fmi.model.datatypeconverters.FMIPackedDecimalDataTypeConverter;
import com.ibm.fmi.model.datatypeconverters.FMIUnsignedBinaryDataTypeConverter;
import com.ibm.fmi.model.datatypeconverters.FMIZonedDecimalDataTypeConverter;
import com.ibm.fmi.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.fm.MainFieldDescriptorSegment;
import com.ibm.fmi.model.fm.PrintHeadingSegment;
import com.ibm.fmi.model.fm.RelocationTable;
import com.ibm.fmi.model.fm.Segment;
import com.ibm.fmi.model.fm.SegmentFactory;
import com.ibm.fmi.model.fm.SegmentHeader;
import com.ibm.fmi.model.fm.Symbol;
import java.nio.ByteBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FMRecordLayoutBuilder
implements IRecordLayoutBuilder {
    private static final int TEMPLATE_HEADER_SIZE = 8;

    @Override
    public ArrayList<RecordLayout> buildLayouts(byte[] template, TemplattedData data) throws FMIParseException, FMIModelException, FMIConversionException {
        ParseResults results = this.parseTemplate(template);
        ArrayList<RecordLayout> layouts = new ArrayList<RecordLayout>();
        for (MainFieldDescriptorSegment root : results.layoutRoots) {
            FieldGroup topLevelItem = this.buildFieldGroups(root.getSecHeader().getSymbol(), results.segments, null);
            topLevelItem.setSlackBytes(null);
            RecordLayout newLayout = new RecordLayout(root.getSecHeader().getSymbol(), root.getName(), data, topLevelItem);
            layouts.add(newLayout);
        }
        return layouts;
    }

    private FieldGroup buildFieldGroups(int curItem, ArrayList<Segment> segments, ArrayList<FieldGroup> siblings) throws FMIParseException, FMIModelException, FMIConversionException {
        MainFieldDescriptorSegment curFieldDescriptor = this.getMainFieldSegment(segments, curItem);
        FieldGroup[] children = null;
        if (curFieldDescriptor.getChildSymbol() != 0) {
            ArrayList<FieldGroup> childrenList = new ArrayList<FieldGroup>();
            MainFieldDescriptorSegment curChild = this.getMainFieldSegment(segments, curFieldDescriptor.getChildSymbol());
            do {
                FieldGroup currentGroup = this.buildFieldGroups(curChild.getSecHeader().getSymbol(), segments, childrenList);
                childrenList.add(currentGroup);
            } while ((curChild = curChild.getSiblingSymbol() == 0 ? null : this.getMainFieldSegment(segments, curChild.getSiblingSymbol())) != null);
            children = childrenList.toArray(new FieldGroup[0]);
        }
        return this.buildField(curFieldDescriptor, children, siblings);
    }

    private FieldGroup buildField(MainFieldDescriptorSegment segment, FieldGroup[] children, ArrayList<FieldGroup> siblings) throws FMIConversionException, FMIModelException, FMIParseException {
        FieldGroup group = null;
        String fieldName = this.getFieldName(segment);
        if (children == null) {
            IFMIDataTypeConverter converter = segment.getDataType();
            Object[] params = null;
            if (converter instanceof FMIBinaryDataTypeConverter && segment.getSignField() == 0) {
                converter = new FMIUnsignedBinaryDataTypeConverter();
            } else if (converter instanceof FMIZonedDecimalDataTypeConverter) {
                boolean signLeading = segment.getSignField() == 1;
                boolean signLeadingAndSeparate = segment.getSignField() == 2;
                boolean signSeparate = segment.getSignField() == 4;
                int impliedDecimal = segment.getScale();
                if (signLeading || signLeadingAndSeparate || signSeparate || impliedDecimal != 0) {
                    signLeading = signLeading || signLeadingAndSeparate;
                    boolean bl = signSeparate = signSeparate || signLeadingAndSeparate;
                    if (impliedDecimal == 0) {
                        impliedDecimal = -1;
                    }
                    Object[] curParams = new Object[]{new Boolean(signLeading), new Boolean(signSeparate), new Integer(impliedDecimal)};
                    params = curParams;
                }
            } else if (converter instanceof FMIPackedDecimalDataTypeConverter && segment.getScale() != 0) {
                Object[] curParams = new Object[]{new Integer(segment.getScale())};
                params = curParams;
            }
            if (segment.isODOTarget()) {
                group = new DefiningObject(fieldName, segment.getLevelNumber(), segment.getFieldStart(), segment.getFieldLength(), segment.getNumSlackBytes(), segment.getSecHeader().getSymbol(), segment.isPl1Aligned(), converter, params, segment.getOccursMin(), segment.getOccursMax());
                if (segment.getDisplayOrder() != 0) {
                    ((Field)group).setDisplayOrder(segment.getDisplayOrder());
                } else {
                    ((Field)group).setDisplayOrder(511);
                }
                return group;
            }
            group = new Field(fieldName, segment.getLevelNumber(), segment.getFieldStart(), segment.getFieldLength(), segment.getNumSlackBytes(), segment.getSecHeader().getSymbol(), segment.isPl1Aligned(), converter, params);
            if (segment.getDisplayOrder() != 0) {
                ((Field)group).setDisplayOrder(segment.getDisplayOrder());
            } else {
                ((Field)group).setDisplayOrder(511);
            }
        } else {
            group = new FieldGroup(fieldName, segment.getSecHeader().getSymbol(), segment.getFieldStart(), segment.getFieldLength(), segment.getLevelNumber(), children);
        }
        if (segment.isOccursDependingOnItem()) {
            if (siblings == null) {
                throw new FMIParseException("Invalid template - ODO must have siblings");
            }
            for (FieldGroup s : siblings) {
                if (s.getSymbol() != segment.getOccursDependingOnSymbol()) continue;
                if (!(s instanceof DefiningObject)) {
                    throw new FMIParseException("Inconsistent template - ODO points to non-defining object");
                }
                group = new FieldGroupVarArray(group, segment.getODOvalue(), segment.getLevelNumber(), segment.getFieldStart(), segment.getFieldLength(), segment.getOccursMin(), segment.getOccursMax(), segment.getODOvalue(), (DefiningObject)s);
                break;
            }
            if (!(group instanceof FieldGroupArray)) {
                throw new FMIParseException("Invalid template - VarArray with no DefiningObject amongst its siblings");
            }
        } else if (segment.isOccursItem()) {
            group = new FieldGroupArray(group, segment.getLevelNumber(), segment.getFieldStart(), segment.getFieldLength(), segment.getOccursMax());
        }
        if (segment.hasRedefines()) {
            group.setHasRedefine();
        }
        if (segment.groupContainsODO()) {
            group.setContainsODOChild();
        }
        return group;
    }

    private String getFieldName(MainFieldDescriptorSegment segment) {
        String fieldName = segment.getName();
        ArrayList<Segment> associatedSegments = segment.getAssociatedSegments();
        if (associatedSegments != null) {
            for (Segment s : associatedSegments) {
                if (!(s instanceof PrintHeadingSegment)) continue;
                fieldName = ((PrintHeadingSegment)s).getHeading();
                break;
            }
        }
        return fieldName;
    }

    private MainFieldDescriptorSegment getMainFieldSegment(ArrayList<Segment> segments, int index) throws FMIParseException {
        Segment curSegment = segments.get(index - 1);
        if (!(curSegment instanceof MainFieldDescriptorSegment)) {
            throw new FMIParseException("Invalid Segment structure");
        }
        return (MainFieldDescriptorSegment)curSegment;
    }

    private ParseResults parseTemplate(byte[] template) throws FMIParseException {
        ByteBuffer templateBuf = ByteBuffer.allocate(template.length);
        templateBuf.put(template);
        templateBuf.position(0);
        int layoutNum = templateBuf.getInt();
        if (layoutNum != 0) {
            throw new FMIParseException();
        }
        templateBuf.getInt();
        RelocationTable relTable = new RelocationTable(templateBuf);
        ParseResults results = new ParseResults();
        for (Symbol s : relTable.getSymbols()) {
            templateBuf.position(s.getSymbolOffset() + 8);
            SegmentHeader header = new SegmentHeader(templateBuf);
            Segment seg = SegmentFactory.buildSegment(header, templateBuf);
            if (seg instanceof MainFieldDescriptorSegment) {
                MainFieldDescriptorSegment cur = (MainFieldDescriptorSegment)seg;
                if (cur.getParentSymbol() == 0) {
                    results.layoutRoots.add((MainFieldDescriptorSegment)seg);
                } else {
                    MainFieldDescriptorSegment cfr_ignored_0 = (MainFieldDescriptorSegment)results.segments.get(results.segments.size() - 1);
                }
            }
            results.segments.add(seg);
        }
        return results;
    }

    private class ParseResults {
        ArrayList<Segment> segments = new ArrayList();
        ArrayList<MainFieldDescriptorSegment> layoutRoots = new ArrayList();

        ParseResults() {
        }
    }
}

