/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.fm;

import com.ibm.fmi.model.ByteUtilities;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.fm.Segment;
import java.nio.ByteBuffer;

public class FieldMappingSegment
extends Segment {
    private static final int FREE_SPACE = 3;
    private int mapSymbol;
    private short nameLength;
    private byte mapType;
    private String fieldName;

    FieldMappingSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    public void parse(ByteBuffer buf) throws FMIParseException {
        this.mapSymbol = buf.getInt();
        this.nameLength = buf.getShort();
        this.mapType = buf.get();
        buf.position(buf.position() + 3);
        try {
            if (this.nameLength > 0) {
                this.fieldName = ByteUtilities.getString(buf, this.nameLength);
            }
        }
        catch (FMIConversionException fMIConversionException) {
            throw new FMIParseException();
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public int getMapSymbol() {
        return this.mapSymbol;
    }

    public void setMapSymbol(int mapSymbol) {
        this.mapSymbol = mapSymbol;
    }

    public byte getMapType() {
        return this.mapType;
    }

    public void setMapType(byte mapType) {
        this.mapType = mapType;
    }

    public short getNameLength() {
        return this.nameLength;
    }

    public void setNameLength(short nameLength) {
        this.nameLength = nameLength;
    }
}

