/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.key;

import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.key.KSDSKeyIndex;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KSDSKeyDuplicateEntry {
    private byte[] theKey;
    private ArrayList<Record> records = null;
    public static final int A_IS_GREATER = -1;
    public static final int EQUAL = 0;
    public static final int B_IS_GREATER = 1;

    KSDSKeyDuplicateEntry(byte[] key, Record rec, KSDSKeyIndex index) {
        this.theKey = key;
        this.records = new ArrayList();
        this.records.add(rec);
    }

    void addRecord(Record rec) throws FMIModelException {
        if (this.records.size() == 1) {
            this.records.get(0).setContainsDuplicateKey();
        }
        rec.setContainsDuplicateKey();
        this.records.add(rec);
    }

    int numRecords() {
        return this.records.size();
    }

    void removeRecord(Record rec) throws FMIModelException {
        rec.clearContainsDuplicateKey();
        this.records.remove(rec);
        if (this.records.size() == 1) {
            this.records.get(0).clearContainsDuplicateKey();
            this.records.remove(0);
        }
    }

    ArrayList<Record> getRecords() {
        return this.records;
    }

    byte[] getKey() {
        return this.theKey;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KSDSKeyDuplicateEntry)) {
            return false;
        }
        KSDSKeyDuplicateEntry b = (KSDSKeyDuplicateEntry)obj;
        byte[] keyB = b.getKey();
        return Arrays.equals(this.theKey, keyB);
    }
}

