/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.shadowline;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.FMIResourceIterator;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.RecordLayout;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.shadowline.ShadowLine;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HiddenSet
extends ShadowLine {
    protected ArrayList<Record> records = null;

    public void addRecord(Record newRecord) throws FMIModelException {
        if (this.records == null) {
            this.records = new ArrayList();
        }
        this.records.add(newRecord);
    }

    public ArrayList<DisplayLine> removeRecordandSplit(Record record) throws FMIModelException {
        int index = this.records.indexOf(record);
        ArrayList<DisplayLine> lines = new ArrayList<DisplayLine>();
        if (index != -1 && this.removeRecord(record)) {
            if (index != 0 && index != this.records.size()) {
                HiddenSet newSet = null;
                try {
                    newSet = (HiddenSet)this.getClass().newInstance();
                }
                catch (Exception exception) {
                    throw new FMIModelException("Internal Error: Provided invalid shadow line class");
                }
                newSet.setParent(this.parent);
                int i = 0;
                while (i < index) {
                    Record curRec = this.records.remove(i);
                    curRec.setParent(newSet);
                    curRec.removeModelListener(this);
                    curRec.addModelListener(newSet);
                    newSet.addRecord(curRec);
                    ++i;
                }
                lines.add(newSet);
                lines.add(record);
                lines.add(this);
            } else if (this.records.size() == 0) {
                lines.add(record);
            } else if (index == 0) {
                lines.add(record);
                lines.add(this);
            } else {
                lines.add(this);
                lines.add(record);
            }
        } else {
            throw new FMIModelException("Internal Error: Invalid Record");
        }
        return lines;
    }

    public boolean removeRecord(Record record) throws FMIModelException {
        if (this.records != null && this.records.contains(record)) {
            if (this.records.remove(record)) {
                record.removeModelListener(this);
                return true;
            }
            return false;
        }
        return false;
    }

    List<Record> getRecords() {
        return this.records;
    }

    void appendRecordSet(HiddenSet toAppend) throws FMIModelException {
        if (toAppend == null) {
            throw new FMIModelException("Internal Error: No record sets available for action: RecordSet#appendRecordSet");
        }
        List<Record> newRecords = toAppend.getRecords();
        this.records.addAll(newRecords);
    }

    void insertRecordSet(int index, HiddenSet toInsert) throws FMIModelException {
        if (toInsert == null) {
            throw new FMIModelException("Internal Error: No record sets available for action: RecordSet#insertRecordSet");
        }
        if (index < 0 || index > this.records.size()) {
            throw new FMIModelException("Internal Error: Attempted to go out of bounds in: RecordSet#insertRecordSet");
        }
        List<Record> newRecords = toInsert.getRecords();
        this.records.addAll(index, newRecords);
    }

    @Override
    public DisplayLine copy() throws FMIConversionException, FMIParseException, FMIModelException, FMIKeyException {
        HiddenSet newInstance = null;
        try {
            newInstance = (HiddenSet)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new FMIConversionException("INTERNAL ERROR");
        }
        if (this.records != null) {
            for (Record r : this.records) {
                Record newRec = (Record)r.copy();
                newRec.setParent(r.getParent());
                newInstance.addRecord(newRec);
            }
        }
        return newInstance;
    }

    @Override
    public boolean storesRecordData() {
        return true;
    }

    @Override
    public int getNumRecords() {
        if (this.records == null) {
            return 0;
        }
        return this.records.size();
    }

    public void removeAllRecords() {
        this.records.clear();
    }

    public boolean recordExists(Record toFind) {
        return this.records.contains(toFind);
    }

    @Override
    public byte[] getFullEbcdic() {
        if (this.records == null) {
            return null;
        }
        int byteWidth = 0;
        for (Record r : this.records) {
            byteWidth += r.getFullEBCDICWidth();
        }
        if (byteWidth == 0) {
            return null;
        }
        byte[] ebcdic = new byte[byteWidth];
        int i_ebcdic = 0;
        for (Record r : this.records) {
            byte[] recordBytes = r.getFullEbcdic();
            if (recordBytes == null || recordBytes.length == 0) continue;
            System.arraycopy(recordBytes, 0, ebcdic, i_ebcdic, recordBytes.length);
            i_ebcdic += recordBytes.length;
        }
        return ebcdic;
    }

    @Override
    public DisplayLine splitOffBeginning(int numUpper) throws FMIModelException {
        if (numUpper < this.records.size()) {
            HiddenSet newLine = null;
            try {
                newLine = (HiddenSet)this.getClass().newInstance();
            }
            catch (Exception exception) {
                return null;
            }
            int numRemoved = 0;
            while (numRemoved < numUpper) {
                newLine.addRecord(this.records.remove(0));
                ++numRemoved;
            }
            return newLine;
        }
        return null;
    }

    @Override
    public DisplayLine splitOffEnd(int numLower) throws FMIModelException {
        if (numLower < this.records.size()) {
            HiddenSet newLine = null;
            try {
                newLine = (HiddenSet)this.getClass().newInstance();
            }
            catch (Exception exception) {
                return null;
            }
            int numRemoved = 0;
            while (numRemoved < numLower) {
                newLine.addRecord(this.records.remove(this.records.size() - 1));
                ++numRemoved;
            }
            return newLine;
        }
        return null;
    }

    @Override
    public boolean mergeBeginning(DisplayLine mergeSet) {
        return this.merge(0, mergeSet);
    }

    @Override
    public boolean mergeEnd(DisplayLine mergeSet) {
        return this.merge(this.records.size(), mergeSet);
    }

    private boolean merge(int index, DisplayLine merge) {
        if (this.getClass() != merge.getClass() || ((HiddenSet)merge).records == null || !this.canMerge((HiddenSet)merge)) {
            return false;
        }
        if (this.records == null) {
            this.records = new ArrayList();
        }
        for (Record r : ((HiddenSet)merge).records) {
            r.setParent(this);
            r.addModelListener(this);
            this.records.add(r);
        }
        return true;
    }

    public void setLayout(RecordLayout layout) {
        this.layout = layout;
    }

    @Override
    public FMIResourceIterator<Record> getRecordIterator() {
        return new FMIResourceIterator<Record>(this.records);
    }

    protected abstract boolean canMerge(HiddenSet var1);

    @Override
    public boolean containsDuplicateKey() {
        for (Record r : this.records) {
            if (!r.containsDuplicateKey()) continue;
            return true;
        }
        return false;
    }
}

