; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instcombine -S | FileCheck %s

; https://bugs.llvm.org/show_bug.cgi?id=38123

; Pattern:
;   x & (-1 >> y) == x
; Should be transformed into:
;   x u<= (-1 >> y)

; ============================================================================ ;
; Basic positive tests
; ============================================================================ ;

define i1 @p0(i8 %x, i8 %y) {
; CHECK-LABEL: @p0(
; CHECK-NEXT:    [[TMP0:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp uge i8 [[TMP0]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[TMP1]]
;
  %tmp0 = lshr i8 -1, %y
  %tmp1 = and i8 %tmp0, %x
  %ret = icmp eq i8 %tmp1, %x
  ret i1 %ret
}

; ============================================================================ ;
; Vector tests
; ============================================================================ ;

define <2 x i1> @p1_vec(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @p1_vec(
; CHECK-NEXT:    [[TMP0:%.*]] = lshr <2 x i8> <i8 -1, i8 -1>, [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp uge <2 x i8> [[TMP0]], [[X:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[TMP1]]
;
  %tmp0 = lshr <2 x i8> <i8 -1, i8 -1>, %y
  %tmp1 = and <2 x i8> %tmp0, %x
  %ret = icmp eq <2 x i8> %tmp1, %x
  ret <2 x i1> %ret
}

define <3 x i1> @p2_vec_undef(<3 x i8> %x, <3 x i8> %y) {
; CHECK-LABEL: @p2_vec_undef(
; CHECK-NEXT:    [[TMP0:%.*]] = lshr <3 x i8> <i8 -1, i8 undef, i8 -1>, [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp uge <3 x i8> [[TMP0]], [[X:%.*]]
; CHECK-NEXT:    ret <3 x i1> [[TMP1]]
;
  %tmp0 = lshr <3 x i8> <i8 -1, i8 undef, i8 -1>, %y
  %tmp1 = and <3 x i8> %tmp0, %x
  %ret = icmp eq <3 x i8> %tmp1, %x
  ret <3 x i1> %ret
}

; ============================================================================ ;
; Commutativity tests.
; ============================================================================ ;

declare i8 @gen8()

define i1 @c0(i8 %y) {
; CHECK-LABEL: @c0(
; CHECK-NEXT:    [[TMP0:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[X:%.*]] = call i8 @gen8()
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ule i8 [[X]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[TMP1]]
;
  %tmp0 = lshr i8 -1, %y
  %x = call i8 @gen8()
  %tmp1 = and i8 %x, %tmp0 ; swapped order
  %ret = icmp eq i8 %tmp1, %x
  ret i1 %ret
}

define i1 @c1(i8 %y) {
; CHECK-LABEL: @c1(
; CHECK-NEXT:    [[TMP0:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[X:%.*]] = call i8 @gen8()
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ule i8 [[X]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[TMP1]]
;
  %tmp0 = lshr i8 -1, %y
  %x = call i8 @gen8()
  %tmp1 = and i8 %tmp0, %x
  %ret = icmp eq i8 %x, %tmp1 ; swapped order
  ret i1 %ret
}

define i1 @c2(i8 %y) {
; CHECK-LABEL: @c2(
; CHECK-NEXT:    [[TMP0:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[X:%.*]] = call i8 @gen8()
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ule i8 [[X]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[TMP1]]
;
  %tmp0 = lshr i8 -1, %y
  %x = call i8 @gen8()
  %tmp1 = and i8 %x, %tmp0 ; swapped order
  %ret = icmp eq i8 %x, %tmp1 ; swapped order
  ret i1 %ret
}

; ============================================================================ ;
; One-use tests. We don't care about multi-uses here.
; ============================================================================ ;

declare void @use8(i8)

define i1 @oneuse0(i8 %x, i8 %y) {
; CHECK-LABEL: @oneuse0(
; CHECK-NEXT:    [[TMP0:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    call void @use8(i8 [[TMP0]])
; CHECK-NEXT:    [[TMP1:%.*]] = icmp uge i8 [[TMP0]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[TMP1]]
;
  %tmp0 = lshr i8 -1, %y
  call void @use8(i8 %tmp0)
  %tmp1 = and i8 %tmp0, %x
  %ret = icmp eq i8 %tmp1, %x
  ret i1 %ret
}

define i1 @oneuse1(i8 %x, i8 %y) {
; CHECK-LABEL: @oneuse1(
; CHECK-NEXT:    [[TMP0:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[TMP0]], [[X:%.*]]
; CHECK-NEXT:    call void @use8(i8 [[TMP1]])
; CHECK-NEXT:    [[TMP1:%.*]] = icmp uge i8 [[TMP0]], [[X]]
; CHECK-NEXT:    ret i1 [[TMP1]]
;
  %tmp0 = lshr i8 -1, %y
  %tmp1 = and i8 %tmp0, %x
  call void @use8(i8 %tmp1)
  %ret = icmp eq i8 %tmp1, %x
  ret i1 %ret
}

define i1 @oneuse2(i8 %x, i8 %y) {
; CHECK-LABEL: @oneuse2(
; CHECK-NEXT:    [[TMP0:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    call void @use8(i8 [[TMP0]])
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[TMP0]], [[X:%.*]]
; CHECK-NEXT:    call void @use8(i8 [[TMP1]])
; CHECK-NEXT:    [[TMP1:%.*]] = icmp uge i8 [[TMP0]], [[X]]
; CHECK-NEXT:    ret i1 [[TMP1]]
;
  %tmp0 = lshr i8 -1, %y
  call void @use8(i8 %tmp0)
  %tmp1 = and i8 %tmp0, %x
  call void @use8(i8 %tmp1)
  %ret = icmp eq i8 %tmp1, %x
  ret i1 %ret
}

; ============================================================================ ;
; Negative tests
; ============================================================================ ;

define i1 @n0(i8 %x, i8 %y, i8 %notx) {
; CHECK-LABEL: @n0(
; CHECK-NEXT:    [[TMP0:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[TMP0]], [[X:%.*]]
; CHECK-NEXT:    [[RET:%.*]] = icmp eq i8 [[TMP1]], [[NOTX:%.*]]
; CHECK-NEXT:    ret i1 [[RET]]
;
  %tmp0 = lshr i8 -1, %y
  %tmp1 = and i8 %tmp0, %x
  %ret = icmp eq i8 %tmp1, %notx ; not %x
  ret i1 %ret
}
